/*
 * Decompiled with CFR 0.152.
 */
package coltginy;

import cern.colt.list.AbstractIntList;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;
import coltginy.ColtGraphPerspective;
import coltginy.ColtginyConstants;
import coltginy.IntLinkedList;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.model.RootGraphChangeEvent;
import giny.model.RootGraphChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.EventListenerList;

public abstract class ColtRootGraph
implements RootGraph {
    protected static String NOT_INITIALIZED_EXCEPTION_STRING = "You must first initialize this ColtRootGraph.";
    protected ObjectMatrix2D coltNodeData;
    protected int coltNodeDataTop;
    protected IntLinkedList nodeDataIndices;
    protected IntArrayList availableNodeDataIndices;
    protected int nodeCount;
    protected ObjectMatrix2D coltEdgeData;
    protected int coltEdgeDataTop;
    protected IntLinkedList edgeDataIndices;
    protected IntArrayList availableEdgeDataIndices;
    protected int edgeCount;
    protected ChangeEvent coltRootGraphChangeEvent;
    EventListenerList listenerList = new EventListenerList();
    protected boolean coltRootGraphInitialized = false;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$giny$model$RootGraphChangeListener;

    public ColtRootGraph() {
        this(25, 25);
    }

    public ColtRootGraph(int node_capacity, int edge_capacity) {
        this.initializeColtRootGraph(node_capacity, edge_capacity);
    }

    protected void initializeColtRootGraph(int node_capacity, int edge_capacity) {
        if (this.coltRootGraphInitialized) {
            return;
        }
        this.coltNodeData = this.createColtNodeData(node_capacity);
        this.coltNodeDataTop = 0;
        this.nodeDataIndices = new IntLinkedList();
        this.availableNodeDataIndices = new IntArrayList(0);
        this.nodeCount = 0;
        this.coltEdgeData = this.createColtEdgeData(node_capacity, edge_capacity);
        this.edgeDataIndices = new IntLinkedList();
        this.coltEdgeDataTop = 0;
        this.availableEdgeDataIndices = new IntArrayList(0);
        this.edgeCount = 0;
        this.coltRootGraphInitialized = true;
    }

    public void ensureCapacity(int nodes, int edges) {
        if (nodes > this.getNodeCount()) {
            this.growForNewNodes(nodes, null);
        }
        if (edges > this.getEdgeCount()) {
            this.growForNewEdges(edges, null);
        }
    }

    public int getNodeCount() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.nodeCount;
    }

    public int getEdgeCount() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeCount;
    }

    public Iterator nodesIterator() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return new Iterator(){
            IntLinkedList.Entry nextNodeListItem;
            {
                this.nextNodeListItem = ColtRootGraph.this.nodeDataIndices.first();
            }

            public boolean hasNext() {
                return this.nextNodeListItem != null;
            }

            public Object next() {
                if (this.nextNodeListItem == null) {
                    throw new NoSuchElementException();
                }
                int next_node_index = this.nextNodeListItem.value();
                this.nextNodeListItem = this.nextNodeListItem.next();
                Node node = (Node)ColtRootGraph.this.coltNodeData.get(0, 0 - next_node_index);
                if (node == null) {
                    node = ColtRootGraph.this.createNode(next_node_index);
                    ColtRootGraph.this.coltNodeData.setQuick(0, 0 - next_node_index, node);
                }
                return node;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List nodesList() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        ArrayList<Node> list = new ArrayList<Node>(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int next_node_index = next_list_item.value();
            Node node = (Node)this.coltNodeData.get(0, 0 - next_node_index);
            if (node == null) {
                node = this.createNode(next_node_index);
                this.coltNodeData.setQuick(0, 0 - next_node_index, node);
            }
            list.add(node);
        }
        return list;
    }

    public int[] getNodeIndicesArray() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (this.nodeDataIndices.elements() == null) {
            return new int[0];
        }
        return this.nodeDataIndices.elements();
    }

    public Iterator edgesIterator() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgesList().iterator();
    }

    public List edgesList() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        ArrayList<Edge> list = new ArrayList<Edge>(this.edgeCount);
        for (IntLinkedList.Entry next_list_item = this.edgeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int edge_index = next_list_item.value();
            Edge edge = (Edge)((Object[])this.coltEdgeData.get(0, 0 - edge_index))[0];
            if (edge == null) {
                edge = this.createEdge(edge_index);
                ((Object[])this.coltEdgeData.get((int)0, (int)(0 - edge_index)))[0] = edge;
            }
            list.add(edge);
        }
        return list;
    }

    public int[] getEdgeIndicesArray() {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeDataIndices.elements();
    }

    public Node removeNode(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        if (node.getRootGraph() == null) {
            return null;
        }
        if (node.getRootGraph() != this) {
            throw new IllegalArgumentException("The given node is not in this RootGraph.  It is in another rootGraph: " + node.getRootGraph() + ".");
        }
        int result = this.removeNode(this.getIndex(node));
        if (result == 0) {
            return null;
        }
        return node;
    }

    public int removeNode(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return 0;
        }
        if (node_index > 0) {
            throw new IllegalArgumentException("The given value, " + node_index + ", cannot be the index of a Node in this RootGraph, in which indices are negative.");
        }
        Node node = (Node)this.coltNodeData.get(0, 0 - node_index);
        if (node == null || node == ColtginyConstants.REMOVED_NODE) {
            return 0;
        }
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addRemovedNodeIndex(node_index);
        }
        this.nodeDataIndices.delete(node_index);
        this.availableNodeDataIndices.add(node_index);
        this.coltNodeData.setQuick(0, 0 - node_index, ColtginyConstants.REMOVED_NODE);
        this.removeAllIncidentEdges(new int[]{node_index}, true, event);
        if (event != null) {
            this.fireRootGraphChanged(event);
        }
        --this.nodeCount;
        return node_index;
    }

    public List removeNodes(List nodes) {
        int node_index;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (nodes == null || nodes.isEmpty()) {
            return nodes == null ? new ArrayList() : nodes;
        }
        Iterator nodes_iterator = nodes.iterator();
        IntArrayList node_indices_to_remove = new IntArrayList(nodes.size());
        ArrayList<Node> nodes_removed = new ArrayList<Node>(nodes.size());
        while (nodes_iterator.hasNext()) {
            Node node = (Node)nodes_iterator.next();
            if (node.getRootGraph() != this) {
                throw new IllegalArgumentException("A Node in the given List is not in this RootGraph.");
            }
            node_index = this.getIndex(node);
            if (node_index == 0) continue;
            node_indices_to_remove.add(node_index);
            nodes_removed.add(node);
        }
        if (node_indices_to_remove.isEmpty()) {
            return nodes_removed;
        }
        ChangeEvent event = this.getChangeEvent();
        node_indices_to_remove.trimToSize();
        int[] node_indices_array = node_indices_to_remove.elements();
        if (event != null) {
            event.addRemovedNodeIndices(node_indices_array);
        }
        for (int node_index_i = 0; node_index_i < node_indices_array.length; ++node_index_i) {
            node_index = node_indices_array[node_index_i];
            this.nodeDataIndices.delete(node_index);
            this.availableNodeDataIndices.add(node_index);
            this.coltNodeData.setQuick(0, 0 - node_index, ColtginyConstants.REMOVED_NODE);
            --this.nodeCount;
        }
        this.removeAllIncidentEdges(node_indices_array, true, event);
        if (event != null) {
            this.fireRootGraphChanged(event);
        }
        return nodes_removed;
    }

    public int[] removeNodes(int[] node_indices) {
        int node_index;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_indices == null || node_indices.length == 0) {
            return node_indices;
        }
        int[] result_indices = new int[node_indices.length];
        IntArrayList node_indices_to_remove = new IntArrayList(node_indices.length);
        for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
            node_index = node_indices[node_index_i];
            if (node_index < 0) {
                Node node = (Node)this.coltNodeData.get(0, 0 - node_index);
                if (node == null || node == ColtginyConstants.REMOVED_NODE) {
                    result_indices[node_index_i] = 0;
                    continue;
                }
                node_indices_to_remove.add(node_index);
                result_indices[node_index_i] = node_index;
                continue;
            }
            if (node_index == 0) {
                result_indices[node_index_i] = 0;
                continue;
            }
            throw new IllegalArgumentException("One of the given Node indices is invalid: " + node_index + " > 0");
        }
        if (node_indices_to_remove.isEmpty()) {
            return result_indices;
        }
        ChangeEvent event = this.getChangeEvent();
        node_indices_to_remove.trimToSize();
        int[] node_indices_array = node_indices_to_remove.elements();
        if (event != null) {
            event.addRemovedNodeIndices(node_indices_array);
        }
        for (int node_index_i = 0; node_index_i < node_indices_array.length; ++node_index_i) {
            node_index = node_indices[node_index_i];
            this.nodeDataIndices.delete(node_index);
            this.availableNodeDataIndices.add(node_index);
            this.coltNodeData.setQuick(0, 0 - node_index, ColtginyConstants.REMOVED_NODE);
            --this.nodeCount;
        }
        this.removeAllIncidentEdges(node_indices_array, true, event);
        if (event != null) {
            this.fireRootGraphChanged(event);
        }
        return result_indices;
    }

    public int createNode() {
        return this.createNode((int[])null, (int[])null);
    }

    public int createNode(Node[] nodes, Edge[] edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        int[] node_indices_array = null;
        if (nodes != null) {
            IntArrayList node_indices = new IntArrayList(nodes.length);
            for (int node_i = 0; node_i < nodes.length; ++node_i) {
                Node node = nodes[node_i];
                if (node == null) {
                    throw new IllegalArgumentException("The Node at index " + node_i + " in the given array is null.");
                }
                if (node.getRootGraph() != this) {
                    throw new IllegalArgumentException("The Node at index " + node_i + " in the given array is not in this RootGraph.");
                }
                int node_index = this.getIndex(node);
                if (node_index == 0) continue;
                node_indices.add(node_index);
            }
            if (!node_indices.isEmpty()) {
                node_indices.trimToSize();
                node_indices_array = node_indices.elements();
            }
        }
        int[] edge_indices_array = null;
        if (edges != null) {
            IntArrayList edge_indices = new IntArrayList(edges.length);
            for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                Edge edge = edges[edge_i];
                if (edge == null) {
                    throw new IllegalArgumentException("The Edge at index " + edge_i + " in the given array is null.");
                }
                if (edge.getRootGraph() != this) {
                    throw new IllegalArgumentException("The Edge at index " + edge_i + " in the given array is not in this RootGraph.");
                }
                int edge_index = this.getIndex(edge);
                if (edge_index == 0) continue;
                edge_indices.add(edge_index);
            }
            if (!edge_indices.isEmpty()) {
                edge_indices.trimToSize();
                edge_indices_array = edge_indices.elements();
            }
        }
        return this.createNode(node_indices_array, edge_indices_array);
    }

    public int createNode(GraphPerspective perspective) {
        int[] node_indices_array = null;
        int[] edge_indices_array = null;
        if (perspective != null) {
            if (perspective.getRootGraph() != this) {
                throw new IllegalArgumentException("The given GraphPerspective is a perspective on a different RootGraph: " + perspective.getRootGraph() + ".");
            }
            node_indices_array = perspective.getNodeIndicesArray();
            edge_indices_array = perspective.getEdgeIndicesArray();
        }
        return this.createNode(node_indices_array, edge_indices_array);
    }

    public int createNode(int[] node_indices, int[] edge_indices) {
        int new_node_index;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        ChangeEvent event = this.getChangeEvent();
        if (this.availableNodeDataIndices.isEmpty()) {
            new_node_index = --this.coltNodeDataTop;
            if (0 - this.coltNodeDataTop >= this.coltNodeData.rows()) {
                this.growForNewNodes(0, event);
            }
        } else {
            int new_node_index_i = this.availableNodeDataIndices.size() - 1;
            new_node_index = this.availableNodeDataIndices.getQuick(new_node_index_i);
            this.availableNodeDataIndices.remove(new_node_index_i);
            this.coltNodeData.setQuick(0, 0 - new_node_index, null);
        }
        this.nodeDataIndices.add(new_node_index);
        if (event != null) {
            event.addCreatedNodeIndex(new_node_index);
        }
        if (node_indices != null && node_indices.length > 0 || edge_indices != null && edge_indices.length > 0) {
            AbstractIntList extra_node_indices = null;
            if (edge_indices != null) {
                IntArrayList meta_child_edge_indices = null;
                for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                    int edge_index = edge_indices[edge_index_i];
                    Edge edge = (Edge)((Object[])this.coltEdgeData.get(0, 0 - edge_index))[0];
                    if (edge_index >= 0 || edge == ColtginyConstants.REMOVED_EDGE) {
                        if (meta_child_edge_indices != null) continue;
                        meta_child_edge_indices = new IntArrayList(edge_indices.length - 1);
                        for (int i = 0; i < edge_index_i; ++i) {
                            meta_child_edge_indices.add(edge_indices[i]);
                        }
                        continue;
                    }
                    this.coltEdgeData.setQuick(0 - new_node_index, 0 - edge_index, new int[]{1});
                    if (meta_child_edge_indices == null) continue;
                    meta_child_edge_indices.add(edge_index);
                }
                if (event != null) {
                    if (meta_child_edge_indices == null) {
                        event.addCreatedMetaRelationshipEdgeIndices(new_node_index, edge_indices);
                    } else {
                        meta_child_edge_indices.trimToSize();
                        event.addCreatedMetaRelationshipEdgeIndices(new_node_index, meta_child_edge_indices.elements());
                    }
                }
            }
            if (node_indices != null || extra_node_indices != null) {
                int extra_node_indices_size;
                IntArrayList meta_child_node_indices = null;
                int node_indices_length = node_indices == null ? 0 : node_indices.length;
                int n = extra_node_indices_size = extra_node_indices == null ? 0 : extra_node_indices.size();
                if (extra_node_indices_size > 0) {
                    meta_child_node_indices = new IntArrayList(node_indices_length + extra_node_indices_size);
                }
                for (int node_index_i = 0; node_index_i < node_indices_length + extra_node_indices_size; ++node_index_i) {
                    int node_index = node_index_i >= node_indices.length ? ((IntArrayList)extra_node_indices).getQuick(node_index_i - node_indices.length) : node_indices[node_index_i];
                    Node node = (Node)this.coltNodeData.get(0, 0 - node_index);
                    if (node_index >= 0 || node == ColtginyConstants.REMOVED_NODE) {
                        if (meta_child_node_indices != null) continue;
                        meta_child_node_indices = new IntArrayList(node_indices.length - 1);
                        for (int i = 0; i < node_index_i; ++i) {
                            meta_child_node_indices.add(node_indices[i]);
                        }
                        continue;
                    }
                    this.coltNodeData.setQuick(0 - new_node_index, 0 - node_index, new int[]{1});
                    if (meta_child_node_indices == null) continue;
                    meta_child_node_indices.add(node_index);
                }
                if (event != null) {
                    if (meta_child_node_indices == null) {
                        event.addCreatedMetaRelationshipNodeIndices(new_node_index, node_indices);
                    } else {
                        meta_child_node_indices.trimToSize();
                        event.addCreatedMetaRelationshipNodeIndices(new_node_index, meta_child_node_indices.elements());
                    }
                }
            }
        }
        ++this.nodeCount;
        if (event != null) {
            this.fireRootGraphChanged(event);
        }
        return new_node_index;
    }

    public int[] createNodes(int new_node_count) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        ChangeEvent event = this.getChangeEvent();
        int new_slots = new_node_count - this.availableNodeDataIndices.size();
        if (0 - (this.coltNodeDataTop - new_slots) >= this.coltNodeData.rows()) {
            this.growForNewNodes(1 + (0 - (this.coltNodeDataTop - new_slots)) - this.coltNodeData.rows(), event);
        }
        int[] new_node_indices = new int[new_node_count];
        for (int new_node_index_i = 0; new_node_index_i < new_node_count; ++new_node_index_i) {
            if (this.availableNodeDataIndices.isEmpty()) {
                new_node_indices[new_node_index_i] = --this.coltNodeDataTop;
            } else {
                int available_node_index_i = this.availableNodeDataIndices.size() - 1;
                new_node_indices[new_node_index_i] = this.availableNodeDataIndices.getQuick(available_node_index_i);
                this.availableNodeDataIndices.remove(available_node_index_i);
            }
            this.nodeDataIndices.add(new_node_indices[new_node_index_i]);
            this.coltNodeData.set(0, 0 - new_node_indices[new_node_index_i], null);
        }
        this.nodeCount += new_node_count;
        if (event != null) {
            event.addCreatedNodeIndices(new_node_indices);
            this.fireRootGraphChanged(event);
        }
        return new_node_indices;
    }

    public Edge removeEdge(Edge edge) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            throw new IllegalArgumentException("The Edge argument must not be null.");
        }
        if (edge.getRootGraph() == null) {
            return null;
        }
        if (edge.getRootGraph() != this) {
            throw new IllegalArgumentException("The given edge is not in this RootGraph.  It is in another rootGraph: " + edge.getRootGraph() + ".");
        }
        int result = this.removeEdge(this.getIndex(edge));
        if (result == 0) {
            return null;
        }
        return edge;
    }

    public int removeEdge(int edge_index) {
        int edge_i;
        int index_in_edge_indices_of_removed_edge;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0) {
            return 0;
        }
        if (edge_index > 0) {
            throw new IllegalArgumentException("The given value, " + edge_index + ", cannot be the index of an Edge in this RootGraph, in which indices are all negative.");
        }
        Object[] edge_data = (Object[])this.coltEdgeData.get(0, 0 - edge_index);
        if (edge_data == null) {
            throw new IllegalArgumentException("The given value, " + edge_index + ", is not the index of an Edge in this RootGraph.");
        }
        Edge edge = (Edge)edge_data[0];
        if (edge == ColtginyConstants.REMOVED_EDGE) {
            return 0;
        }
        int[] incident_nodes_data = (int[])edge_data[1];
        int source_index = incident_nodes_data[0];
        int target_index = incident_nodes_data[1];
        boolean directed = incident_nodes_data[2] != 0;
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addRemovedEdgeIndex(edge_index);
        }
        this.edgeDataIndices.delete(edge_index);
        this.availableEdgeDataIndices.add(edge_index);
        edge_data[0] = ColtginyConstants.REMOVED_EDGE;
        edge_data[1] = null;
        int[] edge_indices = (int[])this.coltNodeData.get(0 - source_index, 0 - target_index);
        if (edge_indices != null && edge_indices.length > 1) {
            index_in_edge_indices_of_removed_edge = 0;
            for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                if (edge_index != edge_indices[edge_i]) continue;
                index_in_edge_indices_of_removed_edge = edge_i;
                break;
            }
            if (index_in_edge_indices_of_removed_edge != 0) {
                int[] new_edge_indices = new int[edge_indices.length - 1];
                System.arraycopy(edge_indices, 0, new_edge_indices, 0, index_in_edge_indices_of_removed_edge);
                if (index_in_edge_indices_of_removed_edge < new_edge_indices.length) {
                    System.arraycopy(edge_indices, index_in_edge_indices_of_removed_edge + 1, new_edge_indices, index_in_edge_indices_of_removed_edge, edge_indices.length - (index_in_edge_indices_of_removed_edge + 1));
                }
                this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_edge_indices);
            }
        }
        if (!directed && (edge_indices = (int[])this.coltNodeData.get(0 - target_index, 0 - source_index)) != null && edge_indices.length > 1) {
            index_in_edge_indices_of_removed_edge = 0;
            for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                if (edge_index != edge_indices[edge_i]) continue;
                index_in_edge_indices_of_removed_edge = edge_i;
                break;
            }
            if (index_in_edge_indices_of_removed_edge != 0) {
                int[] new_edge_indices = new int[edge_indices.length - 1];
                System.arraycopy(edge_indices, 0, new_edge_indices, 0, index_in_edge_indices_of_removed_edge);
                if (index_in_edge_indices_of_removed_edge < new_edge_indices.length) {
                    System.arraycopy(edge_indices, index_in_edge_indices_of_removed_edge + 1, new_edge_indices, index_in_edge_indices_of_removed_edge, edge_indices.length - (index_in_edge_indices_of_removed_edge + 1));
                }
                this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_edge_indices);
            }
        }
        --this.edgeCount;
        if (event != null) {
            this.fireRootGraphChanged(event);
        }
        return edge_index;
    }

    public List removeEdges(List edges) {
        int edge_index;
        Edge edge;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edges == null || edges.isEmpty()) {
            return edges == null ? new ArrayList() : edges;
        }
        Iterator edges_iterator = edges.iterator();
        IntArrayList edge_indices_to_remove = new IntArrayList(edges.size());
        ArrayList<Edge> edges_removed = new ArrayList<Edge>(edges.size());
        while (edges_iterator.hasNext()) {
            edge = (Edge)edges_iterator.next();
            if (edge.getRootGraph() != this) {
                throw new IllegalArgumentException("A Edge in the given List is not in this RootGraph.");
            }
            edge_index = this.getIndex(edge);
            if (edge_index == 0) continue;
            edge_indices_to_remove.add(edge_index);
        }
        if (edge_indices_to_remove.isEmpty()) {
            return edges_removed;
        }
        ChangeEvent event = this.getChangeEvent();
        edge_indices_to_remove.trimToSize();
        int[] edge_indices_tbr_array = edge_indices_to_remove.elements();
        for (int edge_index_i = 0; edge_index_i < edge_indices_tbr_array.length; ++edge_index_i) {
            int[] new_edge_indices;
            int edge_i;
            int index_in_edge_indices_of_removed_edge;
            edge_index = edge_indices_tbr_array[edge_index_i];
            Object[] edge_data = (Object[])this.coltEdgeData.get(0, 0 - edge_index);
            edge = (Edge)edge_data[0];
            if (edge == ColtginyConstants.REMOVED_EDGE) continue;
            if (event != null) {
                event.addRemovedEdgeIndex(edge_index);
            }
            edges_removed.add(edge);
            int[] incident_nodes_data = (int[])edge_data[1];
            int source_index = incident_nodes_data[0];
            int target_index = incident_nodes_data[1];
            boolean directed = incident_nodes_data[2] != 0;
            this.edgeDataIndices.delete(edge_index);
            this.availableEdgeDataIndices.add(edge_index);
            edge_data[0] = ColtginyConstants.REMOVED_EDGE;
            edge_data[1] = null;
            int[] edge_indices = (int[])this.coltNodeData.get(0 - source_index, 0 - target_index);
            if (edge_indices != null && edge_indices.length > 1) {
                index_in_edge_indices_of_removed_edge = 0;
                for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_index != edge_indices[edge_i]) continue;
                    index_in_edge_indices_of_removed_edge = edge_i;
                    break;
                }
                if (index_in_edge_indices_of_removed_edge != 0) {
                    if (edge_indices.length == 1 && edge_indices[0] != 1) {
                        this.coltNodeData.setQuick(0 - source_index, 0 - target_index, null);
                    } else {
                        new_edge_indices = new int[edge_indices.length - 1];
                        System.arraycopy(edge_indices, 0, new_edge_indices, 0, index_in_edge_indices_of_removed_edge);
                        if (index_in_edge_indices_of_removed_edge < new_edge_indices.length) {
                            System.arraycopy(edge_indices, index_in_edge_indices_of_removed_edge + 1, new_edge_indices, index_in_edge_indices_of_removed_edge, edge_indices.length - (index_in_edge_indices_of_removed_edge + 1));
                        }
                        this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_edge_indices);
                    }
                }
            }
            if (directed || (edge_indices = (int[])this.coltNodeData.get(0 - target_index, 0 - source_index)) == null || edge_indices.length <= 1) continue;
            index_in_edge_indices_of_removed_edge = 0;
            for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                if (edge_index != edge_indices[edge_i]) continue;
                index_in_edge_indices_of_removed_edge = edge_i;
                break;
            }
            if (index_in_edge_indices_of_removed_edge == 0) continue;
            if (edge_indices.length == 1 && edge_indices[0] != 1) {
                this.coltNodeData.setQuick(0 - target_index, 0 - source_index, null);
                continue;
            }
            new_edge_indices = new int[edge_indices.length - 1];
            System.arraycopy(edge_indices, 0, new_edge_indices, 0, index_in_edge_indices_of_removed_edge);
            if (index_in_edge_indices_of_removed_edge < new_edge_indices.length) {
                System.arraycopy(edge_indices, index_in_edge_indices_of_removed_edge + 1, new_edge_indices, index_in_edge_indices_of_removed_edge, edge_indices.length - (index_in_edge_indices_of_removed_edge + 1));
            }
            this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_edge_indices);
        }
        if (event != null) {
            event.addRemovedEdgeIndices(edge_indices_tbr_array);
            this.fireRootGraphChanged(event);
        }
        return edges_removed;
    }

    public int[] removeEdges(int[] edge_indices) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.removeEdges(edge_indices, this.getChangeEvent());
    }

    public int[] removeEdges(int[] edge_indices, ChangeEvent event) {
        Edge edge;
        int edge_index;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_indices == null || edge_indices.length == 0) {
            return edge_indices;
        }
        int[] result_indices = new int[edge_indices.length];
        IntArrayList edge_indices_to_remove = new IntArrayList(edge_indices.length);
        for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
            edge_index = edge_indices[edge_index_i];
            if (edge_index < 0) {
                edge = (Edge)((Object[])this.coltEdgeData.get(0, 0 - edge_index))[0];
                if (edge == ColtginyConstants.REMOVED_EDGE) {
                    result_indices[edge_index_i] = 0;
                    continue;
                }
                edge_indices_to_remove.add(edge_index);
                result_indices[edge_index_i] = edge_index;
                continue;
            }
            if (edge_index == 0) {
                result_indices[edge_index_i] = 0;
                continue;
            }
            throw new IllegalArgumentException("One of the given Edge indices is invalid: " + edge_index + " > 0");
        }
        if (edge_indices_to_remove.isEmpty()) {
            return result_indices;
        }
        edge_indices_to_remove.trimToSize();
        int[] edge_indices_tbr_array = edge_indices_to_remove.elements();
        if (event != null) {
            event.addRemovedEdgeIndices(edge_indices_tbr_array);
        }
        for (int edge_index_i = 0; edge_index_i < edge_indices_tbr_array.length; ++edge_index_i) {
            int[] new_edge_indices;
            int edge_i;
            int index_in_edge_indices_of_removed_edge;
            edge_index = edge_indices_tbr_array[edge_index_i];
            Object[] edge_data = (Object[])this.coltEdgeData.get(0, 0 - edge_index);
            edge = (Edge)edge_data[0];
            int[] incident_nodes_data = (int[])edge_data[1];
            int source_index = incident_nodes_data[0];
            int target_index = incident_nodes_data[1];
            boolean directed = incident_nodes_data[2] != 0;
            this.edgeDataIndices.delete(edge_index);
            this.availableEdgeDataIndices.add(edge_index);
            edge_data[0] = ColtginyConstants.REMOVED_EDGE;
            edge_data[1] = null;
            int[] edge_indices_for_node = (int[])this.coltNodeData.get(0 - source_index, 0 - target_index);
            if (edge_indices_for_node != null && edge_indices_for_node.length > 1) {
                index_in_edge_indices_of_removed_edge = 0;
                for (edge_i = 1; edge_i < edge_indices_for_node.length; ++edge_i) {
                    if (edge_index != edge_indices_for_node[edge_i]) continue;
                    index_in_edge_indices_of_removed_edge = edge_i;
                    break;
                }
                if (index_in_edge_indices_of_removed_edge != 0) {
                    if (edge_indices_for_node.length == 1 && edge_indices_for_node[0] != 1) {
                        this.coltNodeData.setQuick(0 - source_index, 0 - target_index, null);
                    } else {
                        new_edge_indices = new int[edge_indices_for_node.length - 1];
                        System.arraycopy(edge_indices_for_node, 0, new_edge_indices, 0, index_in_edge_indices_of_removed_edge);
                        if (index_in_edge_indices_of_removed_edge < new_edge_indices.length) {
                            System.arraycopy(edge_indices_for_node, index_in_edge_indices_of_removed_edge + 1, new_edge_indices, index_in_edge_indices_of_removed_edge, edge_indices_for_node.length - (index_in_edge_indices_of_removed_edge + 1));
                        }
                        this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_edge_indices);
                    }
                }
            }
            if (directed || (edge_indices_for_node = (int[])this.coltNodeData.get(0 - target_index, 0 - source_index)) == null || edge_indices_for_node.length <= 1) continue;
            index_in_edge_indices_of_removed_edge = 0;
            for (edge_i = 1; edge_i < edge_indices_for_node.length; ++edge_i) {
                if (edge_index != edge_indices_for_node[edge_i]) continue;
                index_in_edge_indices_of_removed_edge = edge_i;
                break;
            }
            if (index_in_edge_indices_of_removed_edge == 0) continue;
            if (edge_indices_for_node.length == 1 && edge_indices_for_node[0] != 1) {
                this.coltNodeData.setQuick(0 - target_index, 0 - source_index, null);
                continue;
            }
            new_edge_indices = new int[edge_indices_for_node.length - 1];
            System.arraycopy(edge_indices_for_node, 0, new_edge_indices, 0, index_in_edge_indices_of_removed_edge);
            if (index_in_edge_indices_of_removed_edge > new_edge_indices.length) {
                System.arraycopy(edge_indices_for_node, index_in_edge_indices_of_removed_edge + 1, new_edge_indices, index_in_edge_indices_of_removed_edge, edge_indices.length - (index_in_edge_indices_of_removed_edge + 1));
            }
            this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_edge_indices);
        }
        this.edgeCount -= edge_indices_tbr_array.length;
        if (event != null) {
            this.fireRootGraphChanged(event);
        }
        return result_indices;
    }

    public int createEdge(Node source, Node target) {
        if (this.getIndex(source) == this.getIndex(target)) {
            return this.createEdge(source, target, false);
        }
        return this.createEdge(source, target, true);
    }

    public int createEdge(Node source, Node target, boolean directed) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (source == null) {
            throw new IllegalArgumentException("The source Node must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("The target Node must not be null.");
        }
        int source_index = this.getIndex(source);
        if (source_index == 0) {
            throw new IllegalArgumentException("The given source node is not in this RootGraph.");
        }
        int target_index = this.getIndex(target);
        if (target_index == 0) {
            throw new IllegalArgumentException("The given target node is not in this RootGraph.");
        }
        return this.createEdge(source_index, target_index, directed);
    }

    public int createEdge(int source_index, int target_index) {
        if (source_index == target_index) {
            return this.createEdge(source_index, target_index, false);
        }
        return this.createEdge(source_index, target_index, true);
    }

    public int createEdge(int source_index, int target_index, boolean directed) {
        int[] new_node_data_edge_indices;
        int new_edge_index;
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (source_index >= 0) {
            throw new IllegalArgumentException("The source Node's index is not valid: " + source_index + " >= 0.");
        }
        if (target_index >= 0) {
            throw new IllegalArgumentException("The target Node's index is not valid: " + target_index + " >= 0.");
        }
        Node source_node = (Node)this.coltNodeData.get(0, 0 - source_index);
        if (source_node == ColtginyConstants.REMOVED_NODE) {
            throw new IllegalArgumentException("The given source Node index, " + source_index + ", does not correspond to any Node in this ColtRootGraph.");
        }
        Node target_node = (Node)this.coltNodeData.get(0, 0 - target_index);
        if (target_node == ColtginyConstants.REMOVED_NODE) {
            throw new IllegalArgumentException("The given target Node index, " + target_index + ", does not correspond to any Node in this ColtRootGraph.");
        }
        if (source_index == target_index && directed) {
            throw new IllegalArgumentException("It is not possible to create a directed self-edge.");
        }
        ChangeEvent event = this.getChangeEvent();
        if (this.availableEdgeDataIndices.isEmpty()) {
            new_edge_index = --this.coltEdgeDataTop;
            if (0 - this.coltEdgeDataTop >= this.coltEdgeData.columns()) {
                this.growForNewEdges(0, event);
            }
            this.edgeDataIndices.add(new_edge_index);
        } else {
            int available_edge_index_i = this.availableEdgeDataIndices.size() - 1;
            new_edge_index = this.availableEdgeDataIndices.getQuick(available_edge_index_i);
            this.edgeDataIndices.add(new_edge_index);
            this.availableEdgeDataIndices.remove(available_edge_index_i);
        }
        Object[] edge_data = new Object[2];
        int[] incident_nodes_data = new int[3];
        edge_data[1] = incident_nodes_data;
        incident_nodes_data[0] = source_index;
        incident_nodes_data[1] = target_index;
        incident_nodes_data[2] = directed ? 1 : 0;
        this.coltEdgeData.setQuick(0, 0 - new_edge_index, edge_data);
        int[] node_data_edge_indices = (int[])this.coltNodeData.get(0 - source_index, 0 - target_index);
        if (node_data_edge_indices == null) {
            new_node_data_edge_indices = new int[]{0, new_edge_index};
            this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_node_data_edge_indices);
        } else if (node_data_edge_indices.length >= 1) {
            new_node_data_edge_indices = new int[node_data_edge_indices.length + 1];
            System.arraycopy(node_data_edge_indices, 0, new_node_data_edge_indices, 0, node_data_edge_indices.length);
            new_node_data_edge_indices[node_data_edge_indices.length] = new_edge_index;
            this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_node_data_edge_indices);
        }
        if (!directed && source_index != target_index) {
            node_data_edge_indices = (int[])this.coltNodeData.get(0 - target_index, 0 - source_index);
            if (node_data_edge_indices == null) {
                new_node_data_edge_indices = new int[]{0, new_edge_index};
                this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_node_data_edge_indices);
            } else if (node_data_edge_indices.length >= 1) {
                new_node_data_edge_indices = new int[node_data_edge_indices.length + 1];
                System.arraycopy(node_data_edge_indices, 0, new_node_data_edge_indices, 0, node_data_edge_indices.length);
                new_node_data_edge_indices[node_data_edge_indices.length] = new_edge_index;
                this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_node_data_edge_indices);
            }
        }
        ++this.edgeCount;
        return new_edge_index;
    }

    public int[] createEdges(int[] source_indices, int[] target_indices, boolean directed) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (source_indices == null) {
            throw new IllegalArgumentException("The source indices must not be null.");
        }
        if (target_indices == null) {
            throw new IllegalArgumentException("The target indices must not be null.");
        }
        if (target_indices.length != source_indices.length) {
            throw new IllegalArgumentException("The target indices array must be the same length as the source indices array.");
        }
        for (int index_i = 0; index_i < source_indices.length; ++index_i) {
            if (source_indices[index_i] >= 0) {
                throw new IllegalArgumentException("The given source Node index, " + source_indices[index_i] + ", cannot be the index of a Node in this RootGraph, in which all indices are negative.");
            }
            if (target_indices[index_i] >= 0) {
                throw new IllegalArgumentException("The given target Node index, " + target_indices[index_i] + ", cannot be the index of a Node in this RootGraph, in which all indices are negative.");
            }
            Node source_node = (Node)this.coltNodeData.get(0, 0 - source_indices[index_i]);
            if (source_node == ColtginyConstants.REMOVED_NODE) {
                throw new IllegalArgumentException("The given source Node index, " + source_indices[index_i] + ", does not correspond to any Node in this ColtRootGraph.");
            }
            Node target_node = (Node)this.coltNodeData.get(0, 0 - target_indices[index_i]);
            if (target_node == ColtginyConstants.REMOVED_NODE) {
                throw new IllegalArgumentException("The given target Node index, " + target_indices[index_i] + ", does not correspond to any Node in this ColtRootGraph.");
            }
            if (!directed || source_indices[index_i] != target_indices[index_i]) continue;
            throw new IllegalArgumentException("It is not possible to create a directed self-edge.");
        }
        ChangeEvent event = this.getChangeEvent();
        int new_slots = source_indices.length - this.availableEdgeDataIndices.size();
        if (0 - (this.coltEdgeDataTop - new_slots) >= this.coltEdgeData.columns()) {
            this.growForNewEdges(1 + (0 - (this.coltEdgeDataTop - new_slots)) - this.coltEdgeData.columns(), event);
        }
        int[] edge_indices = new int[source_indices.length];
        for (int index_i = 0; index_i < source_indices.length; ++index_i) {
            int[] new_node_data_edge_indices;
            int source_index = source_indices[index_i];
            int target_index = target_indices[index_i];
            if (this.availableEdgeDataIndices.isEmpty()) {
                edge_indices[index_i] = --this.coltEdgeDataTop;
                this.edgeDataIndices.add(edge_indices[index_i]);
            } else {
                int available_edge_index_i = this.availableEdgeDataIndices.size() - 1;
                edge_indices[index_i] = this.availableEdgeDataIndices.getQuick(available_edge_index_i);
                this.edgeDataIndices.add(edge_indices[index_i]);
                this.availableEdgeDataIndices.remove(available_edge_index_i);
            }
            Object[] edge_data = new Object[2];
            int[] incident_nodes_data = new int[3];
            edge_data[1] = incident_nodes_data;
            incident_nodes_data[0] = source_index;
            incident_nodes_data[1] = target_index;
            incident_nodes_data[2] = directed ? 1 : 0;
            this.coltEdgeData.setQuick(0, 0 - edge_indices[index_i], edge_data);
            int[] node_data_edge_indices = (int[])this.coltNodeData.get(0 - source_index, 0 - target_index);
            if (node_data_edge_indices == null) {
                new_node_data_edge_indices = new int[]{0, edge_indices[index_i]};
                this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_node_data_edge_indices);
            } else if (node_data_edge_indices.length >= 1) {
                new_node_data_edge_indices = new int[node_data_edge_indices.length + 1];
                System.arraycopy(node_data_edge_indices, 0, new_node_data_edge_indices, 0, node_data_edge_indices.length);
                new_node_data_edge_indices[node_data_edge_indices.length] = edge_indices[index_i];
                this.coltNodeData.setQuick(0 - source_index, 0 - target_index, new_node_data_edge_indices);
            }
            if (directed || source_index == target_index) continue;
            node_data_edge_indices = (int[])this.coltNodeData.get(0 - target_index, 0 - source_index);
            if (node_data_edge_indices == null) {
                new_node_data_edge_indices = new int[]{0, edge_indices[index_i]};
                this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_node_data_edge_indices);
                continue;
            }
            if (node_data_edge_indices.length < 1) continue;
            new_node_data_edge_indices = new int[node_data_edge_indices.length + 1];
            System.arraycopy(node_data_edge_indices, 0, new_node_data_edge_indices, 0, node_data_edge_indices.length);
            new_node_data_edge_indices[node_data_edge_indices.length] = edge_indices[index_i];
            this.coltNodeData.setQuick(0 - target_index, 0 - source_index, new_node_data_edge_indices);
        }
        this.edgeCount += edge_indices.length;
        if (event != null) {
            event.addCreatedEdgeIndices(edge_indices);
            this.fireRootGraphChanged(event);
        }
        return edge_indices;
    }

    protected void removeAllIncidentEdges(Node[] nodes, boolean remove_meta_edges, ChangeEvent event) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (nodes == null || nodes.length == 0) {
            return;
        }
        IntArrayList edge_indices_removed = null;
        if (event != null) {
            edge_indices_removed = new IntArrayList();
        }
        for (int node_i = 0; node_i < nodes.length; ++node_i) {
            Node node = nodes[node_i];
            int node_index = this.getIndex(node);
            if (node_index == 0) continue;
            IntLinkedList.Entry next_list_item = this.nodeDataIndices.first();
            while (next_list_item != null) {
                int edge_i;
                int other_node_index = next_list_item.value();
                int[] edge_indices = (int[])this.coltNodeData.get(0 - node_index, 0 - other_node_index);
                if (edge_indices != null && (remove_meta_edges || edge_indices.length > 1)) {
                    if (event != null) {
                        for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                            edge_indices_removed.add(edge_indices[edge_i]);
                        }
                        if (remove_meta_edges && edge_indices[0] == 1) {
                            event.addRemovedMetaRelationshipNodeIndex(node_index, other_node_index);
                        }
                    }
                    if (remove_meta_edges || edge_indices[0] != 1) {
                        this.coltNodeData.setQuick(0 - node_index, 0 - other_node_index, null);
                    } else {
                        this.coltNodeData.setQuick(0 - node_index, 0 - other_node_index, new int[]{1});
                    }
                }
                if ((edge_indices = (int[])this.coltNodeData.get(0 - other_node_index, 0 - node_index)) == null || !remove_meta_edges && edge_indices.length <= 1) continue;
                if (event != null) {
                    for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                        edge_indices_removed.add(edge_indices[edge_i]);
                    }
                    if (remove_meta_edges && edge_indices[0] == 1) {
                        event.addRemovedMetaRelationshipNodeIndex(other_node_index, node_index);
                    }
                }
                if (remove_meta_edges || edge_indices[0] != 1) {
                    this.coltNodeData.setQuick(0 - other_node_index, 0 - node_index, null);
                } else {
                    this.coltNodeData.setQuick(0 - other_node_index, 0 - node_index, new int[]{1});
                }
                next_list_item = next_list_item.next();
            }
        }
        if (event != null && !edge_indices_removed.isEmpty()) {
            edge_indices_removed.trimToSize();
            event.addRemovedEdgeIndices(edge_indices_removed.elements());
        }
    }

    protected void removeAllIncidentEdges(int[] node_indices, boolean remove_meta_edges, ChangeEvent event) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_indices == null || node_indices.length == 0) {
            return;
        }
        IntArrayList edge_indices_removed = null;
        if (event != null) {
            edge_indices_removed = new IntArrayList();
        }
        for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
            int node_index = node_indices[node_index_i];
            if (node_index == 0) continue;
            IntLinkedList.Entry next_list_item = this.nodeDataIndices.first();
            while (next_list_item != null) {
                int edge_i;
                int other_node_index = next_list_item.value();
                int[] edge_indices = (int[])this.coltNodeData.get(0 - node_index, 0 - other_node_index);
                if (edge_indices != null && (remove_meta_edges || edge_indices.length > 1)) {
                    if (event != null) {
                        for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                            edge_indices_removed.add(edge_indices[edge_i]);
                        }
                        if (remove_meta_edges && edge_indices[0] == 1) {
                            event.addRemovedMetaRelationshipNodeIndex(node_index, other_node_index);
                        }
                    }
                    if (remove_meta_edges || edge_indices[0] != 1) {
                        this.coltNodeData.setQuick(0 - node_index, 0 - other_node_index, null);
                    } else {
                        this.coltNodeData.setQuick(0 - node_index, 0 - other_node_index, new int[]{1});
                    }
                }
                if ((edge_indices = (int[])this.coltNodeData.get(0 - other_node_index, 0 - node_index)) == null) {
                    next_list_item = next_list_item.next();
                    continue;
                }
                if (!remove_meta_edges && edge_indices.length <= 1) {
                    next_list_item = next_list_item.next();
                    continue;
                }
                if (event != null) {
                    for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                        edge_indices_removed.add(edge_indices[edge_i]);
                    }
                    if (remove_meta_edges && edge_indices[0] == 1) {
                        event.addRemovedMetaRelationshipNodeIndex(other_node_index, node_index);
                    }
                }
                if (remove_meta_edges || edge_indices[0] != 1) {
                    this.coltNodeData.setQuick(0 - other_node_index, 0 - node_index, null);
                } else {
                    this.coltNodeData.setQuick(0 - other_node_index, 0 - node_index, new int[]{1});
                }
                next_list_item = next_list_item.next();
            }
        }
        if (event != null && !edge_indices_removed.isEmpty()) {
            edge_indices_removed.trimToSize();
            event.addRemovedEdgeIndices(edge_indices_removed.elements());
        }
    }

    public boolean containsNode(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return node.getRootGraph() == this && this.getIndex(node) != 0;
    }

    public boolean containsEdge(Edge edge) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return edge.getRootGraph() == this && this.getIndex(edge) != 0;
    }

    public int[] getAdjacentEdgeIndicesArray(int node_index, boolean include_undirected_edges, boolean incoming_edges, boolean outgoing_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        if (!(include_undirected_edges || incoming_edges || outgoing_edges)) {
            return null;
        }
        IntArrayList adjacent_edges = new IntArrayList(this.getEdgeCount());
        int[] neighbors = this.neighborsArray(node_index);
        for (int neighbors_i = 0; neighbors_i < neighbors.length; ++neighbors_i) {
            int[] outgoing;
            int[] incoming_undirected;
            int i = neighbors[neighbors_i];
            if (include_undirected_edges && incoming_edges && outgoing_edges) {
                incoming_undirected = this.getEdgeIndicesArray(node_index, i, true);
                outgoing = this.getEdgeIndicesArray(i, node_index, false);
                if (incoming_undirected != null) {
                    adjacent_edges.addAllOf(new IntArrayList(incoming_undirected));
                }
                if (outgoing == null) continue;
                adjacent_edges.addAllOf(new IntArrayList(outgoing));
                continue;
            }
            if (include_undirected_edges && incoming_edges && !outgoing_edges) {
                incoming_undirected = this.getEdgeIndicesArray(node_index, i, true);
                adjacent_edges.addAllOf(new IntArrayList(incoming_undirected));
                continue;
            }
            if (include_undirected_edges && !incoming_edges && !outgoing_edges) {
                incoming_undirected = this.getEdgeIndicesArray(node_index, i, true);
                for (int j = 0; j < incoming_undirected.length; ++j) {
                    if (this.isEdgeDirected(incoming_undirected[j])) continue;
                    adjacent_edges.add(incoming_undirected[j]);
                }
                continue;
            }
            if (!include_undirected_edges && incoming_edges && outgoing_edges) {
                incoming_undirected = this.getEdgeIndicesArray(node_index, i, false);
                outgoing = this.getEdgeIndicesArray(i, node_index, false);
                adjacent_edges.addAllOf(new IntArrayList(incoming_undirected));
                adjacent_edges.addAllOf(new IntArrayList(outgoing));
                continue;
            }
            if (include_undirected_edges || !incoming_edges || outgoing_edges) continue;
            incoming_undirected = this.getEdgeIndicesArray(node_index, i, false);
            adjacent_edges.addAllOf(new IntArrayList(incoming_undirected));
        }
        adjacent_edges.trimToSize();
        return adjacent_edges.elements();
    }

    public int[] getConnectingNodeIndicesArray(int[] edge_indices) {
        OpenIntIntHashMap nodes = new OpenIntIntHashMap(this.getNodeCount());
        for (int i = 0; i < edge_indices.length; ++i) {
            nodes.put(this.getEdgeSourceIndex(edge_indices[i]), 1);
            nodes.put(this.getEdgeTargetIndex(edge_indices[i]), 1);
        }
        IntArrayList node_s = nodes.keys();
        node_s.trimToSize();
        return node_s.elements();
    }

    public int[] getConnectingEdgeIndicesArray(int[] node_indices) {
        IntArrayList edges = new IntArrayList();
        for (int from_node = 0; from_node < node_indices.length; ++from_node) {
            for (int to_node = from_node; to_node < node_indices.length; ++to_node) {
                int[] edges_between = this.getEdgeIndicesArray(node_indices[from_node], node_indices[to_node], true, true);
                if (edges_between == null) continue;
                for (int i = 0; i < edges_between.length; ++i) {
                    edges.add(edges_between[i]);
                }
            }
        }
        edges.trimToSize();
        return edges.elements();
    }

    public List neighborsList(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The given Node must not be null.");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        ArrayList<Node> neighbors_list = new ArrayList<Node>(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int neighbor_index = next_list_item.value();
            if (!this.isNeighbor(index, neighbor_index)) continue;
            neighbors_list.add(this.getNode(neighbor_index));
        }
        return neighbors_list;
    }

    public int[] neighborsArray(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList neighbors = new IntArrayList(this.getNodeCount());
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int neighbor_index = next_list_item.value();
            if (!this.isNeighbor(node_index, neighbor_index)) continue;
            neighbors.add(neighbor_index);
        }
        neighbors.trimToSize();
        return neighbors.elements();
    }

    public boolean isNeighbor(Node a_node, Node another_node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeExists(a_node, another_node) || this.edgeExists(another_node, a_node);
    }

    public boolean isNeighbor(int a_node_index, int another_node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeExists(a_node_index, another_node_index) || this.edgeExists(another_node_index, a_node_index);
    }

    public boolean edgeExists(Node from, Node to) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from == null || to == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        return this.edgeExists(this.getIndex(from), this.getIndex(to));
    }

    public boolean edgeExists(int from_node_index, int to_node_index) {
        if (from_node_index == 0) {
            return false;
        }
        if (to_node_index == 0) {
            return false;
        }
        int[] edge_indices = (int[])this.coltNodeData.get(0 - from_node_index, 0 - to_node_index);
        return edge_indices != null && edge_indices.length != 1;
    }

    public int getEdgeCount(Node from, Node to, boolean count_undirected_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from == null || to == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        return this.getEdgeCount(this.getIndex(from), this.getIndex(to), count_undirected_edges);
    }

    public int getEdgeCount(int from_node_index, int to_node_index, boolean count_undirected_edges) {
        if (from_node_index == 0) {
            return 0;
        }
        if (to_node_index == 0) {
            return 0;
        }
        if (from_node_index == to_node_index && !count_undirected_edges) {
            return 0;
        }
        int[] edge_indices = (int[])this.coltNodeData.get(0 - from_node_index, 0 - to_node_index);
        if (edge_indices == null || edge_indices.length == 1) {
            if (edge_indices == null) {
                return 0;
            }
            if (edge_indices.length == 1) {
                // empty if block
            }
            return 0;
        }
        if (count_undirected_edges) {
            return edge_indices.length - 1;
        }
        int edge_count = 0;
        for (int edge_index_i = 1; edge_index_i < edge_indices.length; ++edge_index_i) {
            boolean edge_is_directed;
            int edge_index = edge_indices[edge_index_i];
            boolean bl = edge_is_directed = ((int[])((Object[])this.coltEdgeData.get(0, 0 - edge_index))[1])[2] != 0;
            if (!edge_is_directed) continue;
            ++edge_count;
        }
        return edge_count;
    }

    public List edgesList(Node from, Node to) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from == null || to == null) {
            throw new IllegalArgumentException("The Node arguments must not be null.");
        }
        return this.edgesList(this.getIndex(from), this.getIndex(to), true);
    }

    public List edgesList(int from_node_index, int to_node_index, boolean include_undirected_edges) {
        if (from_node_index == 0) {
            return null;
        }
        if (to_node_index == 0) {
            return null;
        }
        if (from_node_index == to_node_index && !include_undirected_edges) {
            return null;
        }
        int[] edge_indices = (int[])this.coltNodeData.get(0 - from_node_index, 0 - to_node_index);
        if (edge_indices == null || edge_indices.length == 1) {
            return null;
        }
        ArrayList<Edge> edges_list = new ArrayList<Edge>(edge_indices.length - 1);
        boolean edge_is_directed = false;
        for (int edge_index_i = 1; edge_index_i < edge_indices.length; ++edge_index_i) {
            if (!include_undirected_edges) {
                boolean bl = edge_is_directed = ((int[])((Object[])this.coltEdgeData.get(0, 0 - edge_indices[edge_index_i]))[1])[2] != 0;
            }
            if (!include_undirected_edges && !edge_is_directed) continue;
            edges_list.add(this.getEdge(edge_indices[edge_index_i]));
        }
        if (edges_list.isEmpty()) {
            return null;
        }
        return edges_list;
    }

    public int[] getEdgeIndicesArray(int from_node_index, int to_node_index, boolean include_undirected_edges, boolean include_both_directions) {
        if (include_undirected_edges && include_both_directions) {
            int[] s_t = this.getEdgeIndicesArray(from_node_index, to_node_index, true);
            int[] t_s = this.getEdgeIndicesArray(to_node_index, from_node_index, false);
            if (s_t == null && t_s != null) {
                return t_s;
            }
            if (t_s == null && s_t != null) {
                return s_t;
            }
            if (s_t == null && t_s == null) {
                return new int[0];
            }
            int[] edges_array = new int[t_s.length + s_t.length];
            System.arraycopy(s_t, 0, edges_array, 0, s_t.length);
            System.arraycopy(t_s, 0, edges_array, s_t.length, t_s.length);
            return edges_array;
        }
        if (!include_undirected_edges && include_both_directions) {
            int[] s_t = this.getEdgeIndicesArray(from_node_index, to_node_index, false);
            int[] t_s = this.getEdgeIndicesArray(to_node_index, from_node_index, false);
            if (s_t == null && t_s != null) {
                return t_s;
            }
            if (t_s == null && s_t != null) {
                return s_t;
            }
            if (s_t == null && t_s == null) {
                return new int[0];
            }
            int[] edges_array = new int[t_s.length + s_t.length];
            System.arraycopy(s_t, 0, edges_array, 0, s_t.length);
            System.arraycopy(t_s, 0, edges_array, s_t.length, t_s.length);
            return edges_array;
        }
        if (!include_both_directions) {
            return this.getEdgeIndicesArray(from_node_index, to_node_index, include_undirected_edges);
        }
        return null;
    }

    public int[] getEdgeIndicesArray(int from_node_index, int to_node_index, boolean include_undirected_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from_node_index == 0) {
            return null;
        }
        if (to_node_index == 0) {
            return null;
        }
        if (from_node_index == to_node_index && !include_undirected_edges) {
            return null;
        }
        int[] edge_indices = (int[])this.coltNodeData.get(0 - from_node_index, 0 - to_node_index);
        if (edge_indices == null || edge_indices.length == 1) {
            return null;
        }
        if (include_undirected_edges) {
            int[] result = new int[edge_indices.length - 1];
            System.arraycopy(edge_indices, 1, result, 0, result.length);
            return result;
        }
        IntArrayList edge_indices_list = new IntArrayList(edge_indices.length);
        for (int edge_index_i = 1; edge_index_i < edge_indices.length; ++edge_index_i) {
            boolean edge_is_directed;
            boolean bl = edge_is_directed = ((int[])((Object[])this.coltEdgeData.get(0, 0 - edge_indices[edge_index_i]))[1])[2] != 0;
            if (!edge_is_directed) continue;
            edge_indices_list.add(edge_indices[edge_index_i]);
        }
        if (edge_indices_list.isEmpty()) {
            return null;
        }
        edge_indices_list.trimToSize();
        return edge_indices_list.elements();
    }

    public int getInDegree(Node node) {
        return this.getInDegree(node, true);
    }

    public int getInDegree(int node_index) {
        return this.getInDegree(node_index, true);
    }

    public int getInDegree(Node node, boolean count_undirected_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        return this.getInDegree(this.getIndex(node), count_undirected_edges);
    }

    public int getInDegree(int node_index, boolean count_undirected_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return 0;
        }
        int in_degree = 0;
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int from_node_index = next_list_item.value();
            in_degree += this.getEdgeCount(from_node_index, node_index, count_undirected_edges);
        }
        return in_degree;
    }

    public int getOutDegree(Node node) {
        return this.getOutDegree(node, true);
    }

    public int getOutDegree(int node_index) {
        return this.getOutDegree(node_index, true);
    }

    public int getOutDegree(Node node, boolean count_undirected_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        return this.getOutDegree(this.getIndex(node), count_undirected_edges);
    }

    public int getOutDegree(int node_index, boolean count_undirected_edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return 0;
        }
        int out_degree = 0;
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int to_node_index = next_list_item.value();
            out_degree += this.getEdgeCount(node_index, to_node_index, count_undirected_edges);
        }
        return out_degree;
    }

    public int getDegree(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        return this.getInDegree(node, true) + this.getOutDegree(node, false);
    }

    public int getDegree(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.getInDegree(node_index, true) + this.getOutDegree(node_index, false);
    }

    public int getIndex(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        if (node.getRootGraph() != this) {
            return 0;
        }
        return node.getRootGraphIndex();
    }

    public Node getNode(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0 || node_index < this.coltNodeDataTop) {
            return null;
        }
        if (node_index > 0) {
            throw new IllegalArgumentException("The given value, " + node_index + ", cannot be the index of a Node in this RootGraph, in which indices are all negative.");
        }
        Node node = (Node)this.coltNodeData.get(0, 0 - node_index);
        if (node == ColtginyConstants.REMOVED_NODE) {
            return null;
        }
        if (node == null) {
            node = this.createNode(node_index);
            this.coltNodeData.setQuick(0, 0 - node_index, node);
        }
        return node;
    }

    public int getIndex(Edge edge) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            throw new IllegalArgumentException("The Edge argument must not be null.");
        }
        if (edge.getRootGraph() != this) {
            return 0;
        }
        return edge.getRootGraphIndex();
    }

    public Edge getEdge(int edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0 || edge_index < this.coltEdgeDataTop) {
            return null;
        }
        Object[] edge_data = (Object[])this.coltEdgeData.get(0, 0 - edge_index);
        Edge edge = (Edge)edge_data[0];
        if (edge == ColtginyConstants.REMOVED_EDGE) {
            return null;
        }
        if (edge == null) {
            edge = this.createEdge(edge_index);
            edge_data[0] = edge;
        }
        return edge;
    }

    public int getEdgeSourceIndex(int edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0 || edge_index < this.coltEdgeDataTop) {
            return 0;
        }
        return ((int[])((Object[])this.coltEdgeData.get(0, 0 - edge_index))[1])[0];
    }

    public int getEdgeTargetIndex(int edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0 || edge_index < this.coltEdgeDataTop) {
            return 0;
        }
        return ((int[])((Object[])this.coltEdgeData.get(0, 0 - edge_index))[1])[1];
    }

    public boolean isEdgeDirected(int edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0 || edge_index < this.coltEdgeDataTop) {
            return false;
        }
        return ((int[])((Object[])this.coltEdgeData.get(0, 0 - edge_index))[1])[2] != 0;
    }

    public boolean addMetaChild(Node parent, Node child) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (parent == null || child == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        int parent_index = this.getIndex(parent);
        if (parent_index == 0) {
            throw new IllegalArgumentException("The given parent Node is not in this RootGraph.");
        }
        int child_index = this.getIndex(child);
        if (child_index == 0) {
            throw new IllegalArgumentException("The given child Node is not in this RootGraph.");
        }
        return this.addNodeMetaChild(parent_index, child_index);
    }

    public boolean addNodeMetaChild(int parent_index, int child_node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child_node_index == parent_index) {
            return false;
        }
        if (parent_index == 0) {
            throw new IllegalArgumentException("The parent Node index must not be 0.");
        }
        if (child_node_index == 0) {
            throw new IllegalArgumentException("The child Node index must not be 0.");
        }
        int[] edge_indices = (int[])this.coltNodeData.get(0 - parent_index, 0 - child_node_index);
        if (edge_indices == null) {
            this.coltNodeData.set(0 - parent_index, 0 - child_node_index, new int[]{1});
        } else if (edge_indices[0] != 1) {
            edge_indices[0] = 1;
        } else {
            return false;
        }
        return true;
    }

    public boolean isMetaParent(Node child, Node parent) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child == null || parent == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        int child_index = this.getIndex(child);
        if (child_index == 0) {
            return false;
        }
        int parent_index = this.getIndex(parent);
        if (parent_index == 0) {
            return false;
        }
        return this.isNodeMetaParent(child_index, parent_index);
    }

    public boolean isNodeMetaParent(int child_node_index, int parent_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child_node_index == parent_index) {
            return false;
        }
        if (child_node_index == 0) {
            return false;
        }
        if (parent_index == 0) {
            return false;
        }
        int[] edge_indices = (int[])this.coltNodeData.get(0 - parent_index, 0 - child_node_index);
        return edge_indices != null && edge_indices[0] == 1;
    }

    public List metaParentsList(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        return this.nodeMetaParentsList(index);
    }

    public List nodeMetaParentsList(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        ArrayList<Node> meta_parents_list = new ArrayList<Node>(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int parent_node_index = next_list_item.value();
            if (!this.isNodeMetaParent(node_index, parent_node_index)) continue;
            meta_parents_list.add(this.getNode(parent_node_index));
        }
        return meta_parents_list;
    }

    public int[] getNodeMetaParentIndicesArray(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList meta_parent_indices_list = new IntArrayList(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int parent_node_index = next_list_item.value();
            if (!this.isNodeMetaParent(node_index, parent_node_index)) continue;
            meta_parent_indices_list.add(parent_node_index);
        }
        meta_parent_indices_list.trimToSize();
        return meta_parent_indices_list.elements();
    }

    public boolean isMetaChild(Node parent, Node child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isNodeMetaChild(int parent_index, int child_node_index) {
        return this.isNodeMetaParent(child_node_index, parent_index);
    }

    public boolean isNodeMetaChild(int parent_index, int child_node_index, boolean recursive) {
        if (this.isNodeMetaChild(parent_index, child_node_index)) {
            return true;
        }
        if (!recursive) {
            return false;
        }
        int[] parents = this.getNodeMetaParentIndicesArray(child_node_index);
        for (int i = 0; i < parents.length; ++i) {
            if (!this.isNodeMetaChild(parent_index, parents[i], true)) continue;
            return true;
        }
        return false;
    }

    public List nodeMetaChildrenList(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        return this.nodeMetaChildrenList(index);
    }

    public List nodeMetaChildrenList(int parent_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (parent_index == 0) {
            return null;
        }
        ArrayList<Node> meta_children_list = new ArrayList<Node>(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int child_node_index = next_list_item.value();
            if (!this.isNodeMetaChild(parent_index, child_node_index)) continue;
            meta_children_list.add(this.getNode(child_node_index));
        }
        return meta_children_list;
    }

    public int[] getNodeMetaChildIndicesArray(int node_index) {
        return this.getNodeMetaChildIndicesArray(node_index, false);
    }

    public int[] getNodeMetaChildIndicesArray(int node_index, boolean recursive) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList meta_children_indices_list = new IntArrayList(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int child_node_index = next_list_item.value();
            if (!this.isNodeMetaChild(node_index, child_node_index, recursive)) continue;
            meta_children_indices_list.add(child_node_index);
        }
        meta_children_indices_list.trimToSize();
        return meta_children_indices_list.elements();
    }

    public int[] getChildlessMetaDescendants(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList childless_descendant_indices_list = new IntArrayList(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int child_node_index = next_list_item.value();
            int[] children = this.getNodeMetaChildIndicesArray(child_node_index);
            if (children != null && children.length != 0 || !this.isNodeMetaChild(node_index, child_node_index, true)) continue;
            childless_descendant_indices_list.add(child_node_index);
        }
        childless_descendant_indices_list.trimToSize();
        return childless_descendant_indices_list.elements();
    }

    public boolean addMetaChild(Node parent, Edge child) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (parent == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("The Edge argument must not be null");
        }
        int parent_index = this.getIndex(parent);
        if (parent_index == 0) {
            throw new IllegalArgumentException("The given parent Node is not in this RootGraph.");
        }
        int child_index = this.getIndex(child);
        if (child_index == 0) {
            throw new IllegalArgumentException("The given child Edge is not in this RootGraph.");
        }
        return this.addEdgeMetaChild(parent_index, child_index);
    }

    public boolean addEdgeMetaChild(int parent_index, int child_edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (parent_index == 0) {
            throw new IllegalArgumentException("The parent Node index must not be 0.");
        }
        if (child_edge_index == 0) {
            throw new IllegalArgumentException("The child Edge index must not be 0.");
        }
        int[] meta_edge = (int[])this.coltEdgeData.get(0 - parent_index, 0 - child_edge_index);
        if (meta_edge == null) {
            this.coltEdgeData.set(0 - parent_index, 0 - child_edge_index, new int[]{1});
        } else if (meta_edge[0] != 1) {
            meta_edge[0] = 1;
        } else {
            return false;
        }
        return true;
    }

    public boolean isMetaParent(Edge child, Node parent) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child == null) {
            throw new IllegalArgumentException("The Edge argument must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int child_index = this.getIndex(child);
        if (child_index == 0) {
            return false;
        }
        int parent_index = this.getIndex(parent);
        if (parent_index == 0) {
            return false;
        }
        return this.isEdgeMetaParent(child_index, parent_index);
    }

    public boolean isEdgeMetaParent(int child_edge_index, int parent_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child_edge_index == 0) {
            return false;
        }
        if (parent_index == 0) {
            return false;
        }
        int[] meta_edge = (int[])this.coltEdgeData.get(0 - parent_index, 0 - child_edge_index);
        return meta_edge != null && meta_edge[0] == 1;
    }

    public List metaParentsList(Edge edge) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            throw new IllegalArgumentException("The Edge argument must not be null");
        }
        int index = this.getIndex(edge);
        if (index == 0) {
            return null;
        }
        return this.edgeMetaParentsList(index);
    }

    public List edgeMetaParentsList(int edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0) {
            return null;
        }
        ArrayList<Node> meta_parents_list = new ArrayList<Node>(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int parent_node_index = next_list_item.value();
            if (!this.isEdgeMetaParent(edge_index, parent_node_index)) continue;
            meta_parents_list.add(this.getNode(parent_node_index));
        }
        return meta_parents_list;
    }

    public int[] getEdgeMetaParentIndicesArray(int edge_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0) {
            return null;
        }
        IntArrayList meta_parent_indices_list = new IntArrayList(this.nodeCount);
        for (IntLinkedList.Entry next_list_item = this.nodeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int parent_node_index = next_list_item.value();
            if (!this.isEdgeMetaParent(edge_index, parent_node_index)) continue;
            meta_parent_indices_list.add(parent_node_index);
        }
        meta_parent_indices_list.trimToSize();
        return meta_parent_indices_list.elements();
    }

    public boolean isMetaChild(Node parent, Edge child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isEdgeMetaChild(int parent_index, int child_edge_index) {
        return this.isEdgeMetaParent(child_edge_index, parent_index);
    }

    public List edgeMetaChildrenList(Node node) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        return this.edgeMetaChildrenList(index);
    }

    public List edgeMetaChildrenList(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        ArrayList<Edge> meta_children_list = new ArrayList<Edge>(this.edgeCount);
        for (IntLinkedList.Entry next_list_item = this.edgeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int child_edge_index = next_list_item.value();
            if (!this.isEdgeMetaChild(node_index, child_edge_index)) continue;
            meta_children_list.add(this.getEdge(child_edge_index));
        }
        return meta_children_list;
    }

    public int[] getEdgeMetaChildIndicesArray(int node_index) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList meta_children_indices_list = new IntArrayList(this.edgeCount);
        for (IntLinkedList.Entry next_list_item = this.edgeDataIndices.first(); next_list_item != null; next_list_item = next_list_item.next()) {
            int child_edge_index = next_list_item.value();
            if (!this.isEdgeMetaChild(node_index, child_edge_index)) continue;
            meta_children_indices_list.add(child_edge_index);
        }
        meta_children_indices_list.trimToSize();
        return meta_children_indices_list.elements();
    }

    public void addRootGraphChangeListener(RootGraphChangeListener listener) {
        this.listenerList.add(class$giny$model$RootGraphChangeListener == null ? (class$giny$model$RootGraphChangeListener = ColtRootGraph.class$("giny.model.RootGraphChangeListener")) : class$giny$model$RootGraphChangeListener, listener);
    }

    public void removeRootGraphChangeListener(RootGraphChangeListener listener) {
        this.listenerList.remove(class$giny$model$RootGraphChangeListener == null ? (class$giny$model$RootGraphChangeListener = ColtRootGraph.class$("giny.model.RootGraphChangeListener")) : class$giny$model$RootGraphChangeListener, listener);
    }

    protected void fireRootGraphChanged(ChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$giny$model$RootGraphChangeListener == null ? ColtRootGraph.class$("giny.model.RootGraphChangeListener") : class$giny$model$RootGraphChangeListener)) continue;
            ((RootGraphChangeListener)listeners[i + 1]).rootGraphChanged(event);
        }
        event.reset();
    }

    protected ChangeEvent getChangeEvent() {
        if (this.coltRootGraphChangeEvent == null) {
            this.coltRootGraphChangeEvent = this.createChangeEvent();
        }
        return this.coltRootGraphChangeEvent;
    }

    protected ObjectMatrix2D createColtNodeDataPerspective(ColtGraphPerspective graph_perspective, OpenIntIntHashMap root_node_index_to_perspective_node_index_map) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        IntArrayList node_indices = new IntArrayList(root_node_index_to_perspective_node_index_map.size());
        root_node_index_to_perspective_node_index_map.keysSortedByValue(node_indices);
        int[] positive_node_indices = new int[node_indices.size() + 1];
        positive_node_indices[0] = 0;
        for (int node_index_i = 0; node_index_i < positive_node_indices.length - 1; ++node_index_i) {
            int negative_node_index = node_indices.getQuick(node_index_i);
            if (negative_node_index >= 0) {
                throw new IllegalArgumentException("One of the given keys, " + negative_node_index + ", is not a valid Node index in this RootGraph (it's not negative!)");
            }
            if (negative_node_index < this.coltNodeDataTop) {
                throw new IllegalArgumentException("One of the given keys, " + negative_node_index + ", is not a valid Node index in this RootGraph.");
            }
            if (this.coltNodeData.getQuick(0, 0 - negative_node_index) == ColtginyConstants.REMOVED_NODE) {
                throw new IllegalArgumentException("One of the given keys, " + negative_node_index + ", is not a valid Node index in this RootGraph (that Node has been removed!)");
            }
            positive_node_indices[node_index_i + 1] = 0 - negative_node_index;
        }
        return this.coltNodeData.viewSelection(positive_node_indices, positive_node_indices);
    }

    protected ObjectMatrix2D createColtEdgeDataPerspective(ColtGraphPerspective graph_perspective, OpenIntIntHashMap root_node_index_to_perspective_node_index_map, OpenIntIntHashMap root_edge_index_to_perspective_edge_index_map) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        IntArrayList node_indices = new IntArrayList(root_node_index_to_perspective_node_index_map.size());
        root_node_index_to_perspective_node_index_map.keysSortedByValue(node_indices);
        int[] positive_node_indices = new int[node_indices.size() + 1];
        positive_node_indices[0] = 0;
        for (int node_index_i = 0; node_index_i < positive_node_indices.length - 1; ++node_index_i) {
            int negative_node_index = node_indices.getQuick(node_index_i);
            if (negative_node_index >= 0) {
                throw new IllegalArgumentException("One of the given keys, " + negative_node_index + ", is not a valid Node index in this RootGraph (it's not negative!)");
            }
            if (negative_node_index < this.coltNodeDataTop) {
                throw new IllegalArgumentException("One of the given keys, " + negative_node_index + ", is not a valid Node index in this RootGraph.");
            }
            if (this.coltNodeData.getQuick(0, 0 - negative_node_index) == ColtginyConstants.REMOVED_NODE) {
                throw new IllegalArgumentException("One of the given keys, " + negative_node_index + ", is not a valid Node index in this RootGraph (that Node has been removed!)");
            }
            positive_node_indices[node_index_i + 1] = 0 - negative_node_index;
        }
        IntArrayList edge_indices = new IntArrayList(root_edge_index_to_perspective_edge_index_map.size());
        root_edge_index_to_perspective_edge_index_map.keysSortedByValue(edge_indices);
        int[] positive_edge_indices = new int[edge_indices.size() + 1];
        positive_edge_indices[0] = 0;
        for (int edge_index_i = 0; edge_index_i < positive_edge_indices.length - 1; ++edge_index_i) {
            int negative_edge_index = edge_indices.getQuick(edge_index_i);
            if (negative_edge_index >= 0) {
                throw new IllegalArgumentException("One of the given keys, " + negative_edge_index + ", is not a valid Edge index in this RootGraph (it's not negative!)");
            }
            if (negative_edge_index < this.coltEdgeDataTop) {
                throw new IllegalArgumentException("One of the given keys, " + negative_edge_index + ", is not a valid Edge index in this RootGraph.");
            }
            Edge edge = (Edge)((Object[])this.coltEdgeData.getQuick(0, 0 - negative_edge_index))[0];
            if (edge == ColtginyConstants.REMOVED_EDGE) {
                throw new IllegalArgumentException("One of the given keys, " + negative_edge_index + ", is not a valid Edge index in this RootGraph (that Edge has been removed!)");
            }
            positive_edge_indices[edge_index_i + 1] = 0 - negative_edge_index;
        }
        return this.coltEdgeData.viewSelection(positive_node_indices, positive_edge_indices);
    }

    public GraphPerspective createGraphPerspective(Node[] nodes, Edge[] edges) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        int[] node_indices = new int[nodes.length];
        for (int node_i = 0; node_i < nodes.length; ++node_i) {
            if (nodes[node_i] == null) {
                throw new IllegalArgumentException("All Nodes must not be null.  The node at index " + node_i + " into the given nodes array is null.");
            }
            if (nodes[node_i].getRootGraph() != this) {
                throw new IllegalArgumentException("All Nodes must be from this RootGraph.  The node at index " + node_i + " into the given nodes array is from a different RootGraph: " + nodes[node_i].getRootGraph() + ".");
            }
            int node_index = nodes[node_i].getRootGraphIndex();
            if (node_index == 0) {
                throw new IllegalArgumentException("All Nodes must be from this RootGraph.  The node at index " + node_i + " into the given nodes array is no longer in this RootGraph (its getRootGraphIndex() method has returned 0).");
            }
            node_indices[node_i] = node_index;
        }
        int[] edge_indices = new int[edges.length];
        for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
            if (edges[edge_i] == null) {
                throw new IllegalArgumentException("All Edges must not be null.  The edge at index " + edge_i + " into the given edges array is null.");
            }
            if (edges[edge_i].getRootGraph() != this) {
                throw new IllegalArgumentException("All Edges must be from this RootGraph.  The edge at index " + edge_i + " into the given edges array is from a different RootGraph: " + edges[edge_i].getRootGraph() + ".");
            }
            int edge_index = edges[edge_i].getRootGraphIndex();
            if (edge_index == 0) {
                throw new IllegalArgumentException("All Edges must be from this RootGraph.  The edge at index " + edge_i + " into the given edges array is no longer in this RootGraph (its getRootGraphIndex() method has returned 0).");
            }
            edge_indices[edge_i] = edge_index;
        }
        return this.createGraphPerspective(node_indices, edge_indices);
    }

    public GraphPerspective createGraphPerspective(int[] node_indices, int[] edge_indices) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        OpenIntIntHashMap r_node_i_to_p_node_i_map = new OpenIntIntHashMap(node_indices.length);
        for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
            if (node_indices[node_index_i] >= 0) {
                throw new IllegalArgumentException("Node indices must be negative!  At index " + node_index_i + " into the given node_indices array, we find this: " + node_indices[node_index_i] + ".");
            }
            r_node_i_to_p_node_i_map.put(node_indices[node_index_i], node_index_i + 1);
        }
        OpenIntIntHashMap r_edge_i_to_p_edge_i_map = new OpenIntIntHashMap(edge_indices.length);
        for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
            if (edge_indices[edge_index_i] >= 0) {
                throw new IllegalArgumentException("Edge indices must be negative!  At index " + edge_index_i + " into the given edge_indices array, we find this: " + edge_indices[edge_index_i] + ".");
            }
            r_edge_i_to_p_edge_i_map.put(edge_indices[edge_index_i], edge_index_i + 1);
        }
        return new ColtGraphPerspective(this, r_node_i_to_p_node_i_map, r_edge_i_to_p_edge_i_map);
    }

    protected ObjectMatrix2D createColtNodeData(int rows_and_columns) {
        return new SparseObjectMatrix2D(rows_and_columns, rows_and_columns);
    }

    protected ObjectMatrix2D createColtEdgeData(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    protected void growForNewNodes(int grow_by, ChangeEvent event) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (grow_by <= 0) {
            grow_by = this.coltNodeData.rows();
        }
        ObjectMatrix2D new_node_data = this.createColtNodeData(this.coltNodeData.rows() + grow_by);
        IntArrayList row_list = new IntArrayList();
        IntArrayList column_list = new IntArrayList();
        ObjectArrayList value_list = new ObjectArrayList();
        this.coltNodeData.getNonZeros(row_list, column_list, value_list);
        int num_values = value_list.size();
        for (int value_i = 0; value_i < num_values; ++value_i) {
            new_node_data.setQuick(row_list.getQuick(value_i), column_list.getQuick(value_i), value_list.getQuick(value_i));
        }
        ObjectMatrix2D new_edge_data = this.createColtEdgeData(this.coltEdgeData.rows() + grow_by, this.coltEdgeData.columns());
        row_list.clear();
        column_list.clear();
        value_list.clear();
        this.coltEdgeData.getNonZeros(row_list, column_list, value_list);
        num_values = value_list.size();
        for (int value_i = 0; value_i < num_values; ++value_i) {
            new_edge_data.setQuick(row_list.getQuick(value_i), column_list.getQuick(value_i), value_list.getQuick(value_i));
        }
        this.coltNodeData = new_node_data;
        this.coltEdgeData = new_edge_data;
        if (event != null) {
            event.setColtNodeDataChangedType(true);
            event.setColtEdgeDataChangedType(true);
        }
    }

    protected void growForNewEdges(int grow_by, ChangeEvent event) {
        if (!this.coltRootGraphInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (grow_by <= 0) {
            grow_by = this.coltEdgeData.columns();
        }
        ObjectMatrix2D new_edge_data = this.createColtEdgeData(this.coltEdgeData.rows(), this.coltEdgeData.columns() + grow_by);
        IntArrayList row_list = new IntArrayList();
        IntArrayList column_list = new IntArrayList();
        ObjectArrayList value_list = new ObjectArrayList();
        this.coltEdgeData.getNonZeros(row_list, column_list, value_list);
        int num_values = value_list.size();
        for (int value_i = 0; value_i < num_values; ++value_i) {
            new_edge_data.setQuick(row_list.getQuick(value_i), column_list.getQuick(value_i), value_list.getQuick(value_i));
        }
        this.coltEdgeData = new_edge_data;
        if (event != null) {
            event.setColtEdgeDataChangedType(true);
        }
    }

    protected abstract Node createNode(int var1);

    protected abstract Edge createEdge(int var1);

    protected ChangeEvent createChangeEvent() {
        return new ChangeEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ChangeEvent
    extends RootGraphChangeEvent {
        public static final int COLT_NODE_DATA_CHANGED_TYPE = 256;
        public static final int COLT_EDGE_DATA_CHANGED_TYPE = 512;
        protected int type;
        protected int[] createdNodeIndices;
        protected int[] createdEdgeIndices;
        protected int[] removedNodeIndices;
        protected int[] removedEdgeIndices;
        protected int[][] metaRelationshipCreatedNodeIndices;
        protected OpenIntIntHashMap metaRelationshipCreatedNodeIndicesMap;
        protected int[][] metaRelationshipCreatedEdgeIndices;
        protected OpenIntIntHashMap metaRelationshipCreatedEdgeIndicesMap;
        protected int[][] metaRelationshipRemovedNodeIndices;
        protected OpenIntIntHashMap metaRelationshipRemovedNodeIndicesMap;
        protected int[][] metaRelationshipRemovedEdgeIndices;
        protected OpenIntIntHashMap metaRelationshipRemovedEdgeIndicesMap;
        protected Node[] createdNodes;
        protected Edge[] createdEdges;
        protected Node[] removedNodes;
        protected Edge[] removedEdges;
        protected Node[][] metaRelationshipCreatedNodes;
        protected Object[][] metaRelationshipCreatedEdges;
        protected Node[][] metaRelationshipRemovedNodes;
        protected Object[][] metaRelationshipRemovedEdges;

        ChangeEvent() {
            super(ColtRootGraph.this);
            this.reset();
        }

        public void reset() {
            this.type = 0;
            this.createdNodeIndices = null;
            this.createdEdgeIndices = null;
            this.removedNodeIndices = null;
            this.removedEdgeIndices = null;
            this.metaRelationshipCreatedNodeIndices = null;
            this.metaRelationshipCreatedEdgeIndices = null;
            this.metaRelationshipRemovedNodeIndices = null;
            this.metaRelationshipRemovedEdgeIndices = null;
            this.createdNodes = null;
            this.createdEdges = null;
            this.removedNodes = null;
            this.removedEdges = null;
            this.metaRelationshipCreatedNodes = null;
            this.metaRelationshipCreatedEdges = null;
            this.metaRelationshipRemovedNodes = null;
            this.metaRelationshipRemovedEdges = null;
        }

        public int getType() {
            return this.type;
        }

        public boolean isNodesCreatedType() {
            return (this.type & 1) != 0;
        }

        public boolean isEdgesCreatedType() {
            return (this.type & 2) != 0;
        }

        public boolean isNodesRemovedType() {
            return (this.type & 4) != 0;
        }

        public boolean isEdgesRemovedType() {
            return (this.type & 8) != 0;
        }

        public boolean isMetaRelationshipNodesCreatedType() {
            return (this.type & 0x10) != 0;
        }

        public boolean isMetaRelationshipEdgesCreatedType() {
            return (this.type & 0x20) != 0;
        }

        public boolean isMetaRelationshipNodesRemovedType() {
            return (this.type & 0x40) != 0;
        }

        public boolean isMetaRelationshipEdgesRemovedType() {
            return (this.type & 0x80) != 0;
        }

        public boolean isColtNodeDataChangedType() {
            return (this.type & 0x100) != 0;
        }

        public void setColtNodeDataChangedType(boolean colt_node_data_has_changed) {
            this.type = colt_node_data_has_changed ? (this.type |= 0x100) : (this.type &= 0xFFFFFEFF);
        }

        public boolean isColtEdgeDataChangedType() {
            return (this.type & 0x200) != 0;
        }

        public void setColtEdgeDataChangedType(boolean colt_edge_data_has_changed) {
            this.type = colt_edge_data_has_changed ? (this.type |= 0x200) : (this.type &= 0xFFFFFDFF);
        }

        public Node[] getCreatedNodes() {
            if ((this.type & 1) == 0) {
                return null;
            }
            if (this.createdNodes == null) {
                this.createdNodes = new Node[this.createdNodeIndices.length];
                for (int node_i = 0; node_i < this.createdNodes.length; ++node_i) {
                    this.createdNodes[node_i] = ((ColtRootGraph)this.source).getNode(this.createdNodeIndices[node_i]);
                }
            }
            return this.createdNodes;
        }

        public Edge[] getCreatedEdges() {
            if ((this.type & 2) == 0) {
                return null;
            }
            if (this.createdEdges == null) {
                this.createdEdges = new Edge[this.createdEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.createdEdges.length; ++edge_i) {
                    this.createdEdges[edge_i] = ((ColtRootGraph)this.source).getEdge(this.createdEdgeIndices[edge_i]);
                }
            }
            return this.createdEdges;
        }

        public Node[] getRemovedNodes() {
            if ((this.type & 4) == 0) {
                return null;
            }
            if (this.removedNodes == null) {
                this.removedNodes = new Node[this.removedNodeIndices.length];
                for (int node_i = 0; node_i < this.removedNodes.length; ++node_i) {
                    this.removedNodes[node_i] = ((ColtRootGraph)this.source).getNode(this.removedNodeIndices[node_i]);
                }
            }
            return this.removedNodes;
        }

        public Edge[] getRemovedEdges() {
            if ((this.type & 8) == 0) {
                return null;
            }
            if (this.removedEdges == null) {
                this.removedEdges = new Edge[this.removedEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.removedEdges.length; ++edge_i) {
                    this.removedEdges[edge_i] = ((ColtRootGraph)this.source).getEdge(this.removedEdgeIndices[edge_i]);
                }
            }
            return this.removedEdges;
        }

        public int[] getCreatedNodeIndices() {
            if ((this.type & 1) == 0) {
                return null;
            }
            if (this.createdNodeIndices == null) {
                this.createdNodeIndices = new int[this.createdNodes.length];
                for (int node_i = 0; node_i < this.createdNodeIndices.length; ++node_i) {
                    this.createdNodeIndices[node_i] = ColtRootGraph.this.getIndex(this.createdNodes[node_i]);
                }
            }
            return this.createdNodeIndices;
        }

        public int[] getCreatedEdgeIndices() {
            if ((this.type & 2) == 0) {
                return null;
            }
            if (this.createdEdgeIndices == null) {
                this.createdEdgeIndices = new int[this.createdEdges.length];
                for (int edge_i = 0; edge_i < this.createdEdgeIndices.length; ++edge_i) {
                    this.createdEdgeIndices[edge_i] = ColtRootGraph.this.getIndex(this.createdEdges[edge_i]);
                }
            }
            return this.createdEdgeIndices;
        }

        public int[] getRemovedNodeIndices() {
            if ((this.type & 4) == 0) {
                return null;
            }
            if (this.removedNodeIndices == null) {
                this.removedNodeIndices = new int[this.removedNodes.length];
                for (int node_i = 0; node_i < this.removedNodeIndices.length; ++node_i) {
                    this.removedNodeIndices[node_i] = ColtRootGraph.this.getIndex(this.removedNodes[node_i]);
                }
            }
            return this.removedNodeIndices;
        }

        public int[] getRemovedEdgeIndices() {
            if ((this.type & 8) == 0) {
                return null;
            }
            if (this.removedEdgeIndices == null) {
                this.removedEdgeIndices = new int[this.removedEdges.length];
                for (int edge_i = 0; edge_i < this.removedEdgeIndices.length; ++edge_i) {
                    this.removedEdgeIndices[edge_i] = ColtRootGraph.this.getIndex(this.removedEdges[edge_i]);
                }
            }
            return this.removedEdgeIndices;
        }

        public Node[][] getMetaRelationshipCreatedNodes() {
            if ((this.type & 0x10) == 0) {
                return null;
            }
            if (this.metaRelationshipCreatedNodes == null) {
                this.metaRelationshipCreatedNodes = new Node[this.metaRelationshipCreatedNodeIndices.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodes.length; ++parent_node_i) {
                    this.metaRelationshipCreatedNodes[parent_node_i] = new Node[this.metaRelationshipCreatedNodeIndices[parent_node_i].length];
                    this.metaRelationshipCreatedNodes[parent_node_i][0] = ((ColtRootGraph)this.source).getNode(this.metaRelationshipCreatedNodeIndices[parent_node_i][0]);
                    for (int child_node_i = 1; child_node_i < this.metaRelationshipCreatedNodes[parent_node_i].length; ++child_node_i) {
                        this.metaRelationshipCreatedNodes[parent_node_i][child_node_i] = ((ColtRootGraph)this.source).getNode(this.metaRelationshipCreatedNodeIndices[parent_node_i][child_node_i]);
                    }
                }
            }
            return this.metaRelationshipCreatedNodes;
        }

        public Object[][] getMetaRelationshipCreatedEdges() {
            if ((this.type & 0x20) == 0) {
                return null;
            }
            if (this.metaRelationshipCreatedEdges == null) {
                this.metaRelationshipCreatedEdges = new Object[this.metaRelationshipCreatedEdgeIndices.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdges.length; ++parent_node_i) {
                    this.metaRelationshipCreatedEdges[parent_node_i] = new Object[this.metaRelationshipCreatedEdgeIndices[parent_node_i].length];
                    this.metaRelationshipCreatedEdges[parent_node_i][0] = ((ColtRootGraph)this.source).getNode(this.metaRelationshipCreatedEdgeIndices[parent_node_i][0]);
                    for (int child_edge_i = 1; child_edge_i < this.metaRelationshipCreatedEdges[parent_node_i].length; ++child_edge_i) {
                        this.metaRelationshipCreatedEdges[parent_node_i][child_edge_i] = ((ColtRootGraph)this.source).getEdge(this.metaRelationshipCreatedEdgeIndices[parent_node_i][child_edge_i]);
                    }
                }
            }
            return this.metaRelationshipCreatedEdges;
        }

        public Node[][] getMetaRelationshipRemovedNodes() {
            if ((this.type & 0x40) == 0) {
                return null;
            }
            if (this.metaRelationshipRemovedNodes == null) {
                this.metaRelationshipRemovedNodes = new Node[this.metaRelationshipRemovedNodeIndices.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodes.length; ++parent_node_i) {
                    this.metaRelationshipRemovedNodes[parent_node_i] = new Node[this.metaRelationshipRemovedNodeIndices[parent_node_i].length];
                    this.metaRelationshipRemovedNodes[parent_node_i][0] = ((ColtRootGraph)this.source).getNode(this.metaRelationshipRemovedNodeIndices[parent_node_i][0]);
                    for (int child_node_i = 1; child_node_i < this.metaRelationshipRemovedNodes[parent_node_i].length; ++child_node_i) {
                        this.metaRelationshipRemovedNodes[parent_node_i][child_node_i] = ((ColtRootGraph)this.source).getNode(this.metaRelationshipRemovedNodeIndices[parent_node_i][child_node_i]);
                    }
                }
            }
            return this.metaRelationshipRemovedNodes;
        }

        public Object[][] getMetaRelationshipRemovedEdges() {
            if ((this.type & 0x80) == 0) {
                return null;
            }
            if (this.metaRelationshipRemovedEdges == null) {
                this.metaRelationshipRemovedEdges = new Object[this.metaRelationshipRemovedEdgeIndices.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdges.length; ++parent_node_i) {
                    this.metaRelationshipRemovedEdges[parent_node_i] = new Object[this.metaRelationshipRemovedEdgeIndices[parent_node_i].length];
                    this.metaRelationshipRemovedEdges[parent_node_i][0] = ((ColtRootGraph)this.source).getNode(this.metaRelationshipRemovedEdgeIndices[parent_node_i][0]);
                    for (int child_edge_i = 1; child_edge_i < this.metaRelationshipRemovedEdges[parent_node_i].length; ++child_edge_i) {
                        this.metaRelationshipRemovedEdges[parent_node_i][child_edge_i] = ((ColtRootGraph)this.source).getEdge(this.metaRelationshipRemovedEdgeIndices[parent_node_i][child_edge_i]);
                    }
                }
            }
            return this.metaRelationshipRemovedEdges;
        }

        public int[][] getMetaRelationshipCreatedNodeIndices() {
            if ((this.type & 0x10) == 0) {
                return null;
            }
            if (this.metaRelationshipCreatedNodeIndices == null) {
                this.metaRelationshipCreatedNodeIndices = new int[this.metaRelationshipCreatedNodes.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i) {
                    this.metaRelationshipCreatedNodeIndices[parent_node_i] = new int[this.metaRelationshipCreatedNodes[parent_node_i].length];
                    this.metaRelationshipCreatedNodeIndices[parent_node_i][0] = this.metaRelationshipCreatedNodes[parent_node_i][0].getRootGraphIndex();
                    for (int child_node_i = 1; child_node_i < this.metaRelationshipCreatedNodeIndices[parent_node_i].length; ++child_node_i) {
                        this.metaRelationshipCreatedNodeIndices[parent_node_i][child_node_i] = this.metaRelationshipCreatedNodes[parent_node_i][child_node_i].getRootGraphIndex();
                    }
                }
            }
            return this.metaRelationshipCreatedNodeIndices;
        }

        public int[][] getMetaRelationshipCreatedEdgeIndices() {
            if ((this.type & 0x20) == 0) {
                return null;
            }
            if (this.metaRelationshipCreatedEdgeIndices == null) {
                this.metaRelationshipCreatedEdgeIndices = new int[this.metaRelationshipCreatedEdges.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i) {
                    this.metaRelationshipCreatedEdgeIndices[parent_node_i] = new int[this.metaRelationshipCreatedEdges[parent_node_i].length];
                    this.metaRelationshipCreatedEdgeIndices[parent_node_i][0] = ((Edge)this.metaRelationshipCreatedEdges[parent_node_i][0]).getRootGraphIndex();
                    for (int child_edge_i = 1; child_edge_i < this.metaRelationshipCreatedEdgeIndices[parent_node_i].length; ++child_edge_i) {
                        this.metaRelationshipCreatedEdgeIndices[parent_node_i][child_edge_i] = ((Edge)this.metaRelationshipCreatedEdges[parent_node_i][child_edge_i]).getRootGraphIndex();
                    }
                }
            }
            return this.metaRelationshipCreatedEdgeIndices;
        }

        public int[][] getMetaRelationshipRemovedNodeIndices() {
            if ((this.type & 0x40) == 0) {
                return null;
            }
            if (this.metaRelationshipRemovedNodeIndices == null) {
                this.metaRelationshipRemovedNodeIndices = new int[this.metaRelationshipRemovedNodes.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i) {
                    this.metaRelationshipRemovedNodeIndices[parent_node_i] = new int[this.metaRelationshipRemovedNodes[parent_node_i].length];
                    this.metaRelationshipRemovedNodeIndices[parent_node_i][0] = this.metaRelationshipRemovedNodes[parent_node_i][0].getRootGraphIndex();
                    for (int child_node_i = 1; child_node_i < this.metaRelationshipRemovedNodeIndices[parent_node_i].length; ++child_node_i) {
                        this.metaRelationshipRemovedNodeIndices[parent_node_i][child_node_i] = this.metaRelationshipRemovedNodes[parent_node_i][child_node_i].getRootGraphIndex();
                    }
                }
            }
            return this.metaRelationshipRemovedNodeIndices;
        }

        public int[][] getMetaRelationshipRemovedEdgeIndices() {
            if ((this.type & 0x80) == 0) {
                return null;
            }
            if (this.metaRelationshipRemovedEdgeIndices == null) {
                this.metaRelationshipRemovedEdgeIndices = new int[this.metaRelationshipRemovedEdges.length][];
                for (int parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i) {
                    this.metaRelationshipRemovedEdgeIndices[parent_node_i] = new int[this.metaRelationshipRemovedEdges[parent_node_i].length];
                    this.metaRelationshipRemovedEdgeIndices[parent_node_i][0] = ((Node)this.metaRelationshipRemovedEdges[parent_node_i][0]).getRootGraphIndex();
                    for (int child_edge_i = 1; child_edge_i < this.metaRelationshipRemovedEdgeIndices[parent_node_i].length; ++child_edge_i) {
                        this.metaRelationshipRemovedEdgeIndices[parent_node_i][child_edge_i] = ((Edge)this.metaRelationshipRemovedEdges[parent_node_i][child_edge_i]).getRootGraphIndex();
                    }
                }
            }
            return this.metaRelationshipRemovedEdgeIndices;
        }

        public void addRemovedNode(Node node) {
            if ((this.type & 4) == 0) {
                this.removedNodes = new Node[1];
                this.removedNodes[0] = node;
                this.type |= 4;
            } else {
                if (this.removedNodes != null) {
                    Node[] new_removed_nodes = new Node[this.removedNodes.length + 1];
                    System.arraycopy(this.removedNodes, 0, new_removed_nodes, 0, this.removedNodes.length);
                    new_removed_nodes[this.removedNodes.length] = node;
                    this.removedNodes = new_removed_nodes;
                }
                if (this.removedNodeIndices != null) {
                    int[] new_removed_node_indices = new int[this.removedNodeIndices.length + 1];
                    System.arraycopy(this.removedNodeIndices, 0, new_removed_node_indices, 0, this.removedNodeIndices.length);
                    new_removed_node_indices[this.removedNodeIndices.length] = node.getRootGraphIndex();
                    this.removedNodeIndices = new_removed_node_indices;
                }
            }
        }

        public void addRemovedNodes(Node[] nodes) {
            if ((this.type & 4) == 0) {
                this.removedNodes = nodes;
                this.type |= 4;
            } else {
                if (this.removedNodes != null) {
                    Node[] new_removed_nodes = new Node[this.removedNodes.length + nodes.length];
                    System.arraycopy(this.removedNodes, 0, new_removed_nodes, 0, this.removedNodes.length);
                    System.arraycopy(nodes, 0, new_removed_nodes, this.removedNodes.length, nodes.length);
                    this.removedNodes = new_removed_nodes;
                }
                if (this.removedNodeIndices != null) {
                    int[] new_removed_node_indices = new int[this.removedNodeIndices.length + nodes.length];
                    System.arraycopy(this.removedNodeIndices, 0, new_removed_node_indices, 0, this.removedNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_removed_node_indices[this.removedNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.removedNodeIndices = new_removed_node_indices;
                }
            }
        }

        public void addRemovedNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if ((this.type & 4) == 0) {
                this.removedNodeIndices = new int[1];
                this.removedNodeIndices[0] = node_index;
                this.type |= 4;
            } else {
                if (this.removedNodeIndices != null) {
                    int[] new_removed_node_indices = new int[this.removedNodeIndices.length + 1];
                    System.arraycopy(this.removedNodeIndices, 0, new_removed_node_indices, 0, this.removedNodeIndices.length);
                    new_removed_node_indices[this.removedNodeIndices.length] = node_index;
                    this.removedNodeIndices = new_removed_node_indices;
                }
                if (this.removedNodes != null) {
                    Node[] new_removed_nodes = new Node[this.removedNodes.length + 1];
                    System.arraycopy(this.removedNodes, 0, new_removed_nodes, 0, this.removedNodes.length);
                    new_removed_nodes[this.removedNodes.length] = ((RootGraph)this.source).getNode(node_index);
                    this.removedNodes = new_removed_nodes;
                }
            }
        }

        public void addRemovedNodeIndices(int[] node_indices) {
            if ((this.type & 4) == 0) {
                this.removedNodeIndices = node_indices;
                this.type |= 4;
            } else {
                if (this.removedNodeIndices != null) {
                    int[] new_removed_node_indices = new int[this.removedNodeIndices.length + node_indices.length];
                    System.arraycopy(this.removedNodeIndices, 0, new_removed_node_indices, 0, this.removedNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_removed_node_indices, this.removedNodeIndices.length, node_indices.length);
                    this.removedNodeIndices = new_removed_node_indices;
                }
                if (this.removedNodes != null) {
                    Node[] new_removed_nodes = new Node[this.removedNodes.length + node_indices.length];
                    System.arraycopy(this.removedNodes, 0, new_removed_nodes, 0, this.removedNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_removed_nodes[this.removedNodes.length + node_index_i] = ColtRootGraph.this.getNode(node_indices[node_index_i]);
                    }
                    this.removedNodes = new_removed_nodes;
                }
            }
        }

        public void addCreatedNode(Node node) {
            if ((this.type & 1) == 0) {
                this.createdNodes = new Node[1];
                this.createdNodes[0] = node;
                this.type |= 1;
            } else {
                if (this.createdNodes != null) {
                    Node[] new_created_nodes = new Node[this.createdNodes.length + 1];
                    System.arraycopy(this.createdNodes, 0, new_created_nodes, 0, this.createdNodes.length);
                    new_created_nodes[this.createdNodes.length] = node;
                    this.createdNodes = new_created_nodes;
                }
                if (this.createdNodeIndices != null) {
                    int[] new_created_node_indices = new int[this.createdNodeIndices.length + 1];
                    System.arraycopy(this.createdNodeIndices, 0, new_created_node_indices, 0, this.createdNodeIndices.length);
                    new_created_node_indices[this.createdNodeIndices.length] = node.getRootGraphIndex();
                    this.createdNodeIndices = new_created_node_indices;
                }
            }
        }

        public void addCreatedNodes(Node[] nodes) {
            if ((this.type & 1) == 0) {
                this.createdNodes = nodes;
                this.type |= 1;
            } else {
                if (this.createdNodes != null) {
                    Node[] new_created_nodes = new Node[this.createdNodes.length + nodes.length];
                    System.arraycopy(this.createdNodes, 0, new_created_nodes, 0, this.createdNodes.length);
                    System.arraycopy(nodes, 0, new_created_nodes, this.createdNodes.length, nodes.length);
                    this.createdNodes = new_created_nodes;
                }
                if (this.createdNodeIndices != null) {
                    int[] new_created_node_indices = new int[this.createdNodeIndices.length + nodes.length];
                    System.arraycopy(this.createdNodeIndices, 0, new_created_node_indices, 0, this.createdNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_created_node_indices[this.createdNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.createdNodeIndices = new_created_node_indices;
                }
            }
        }

        public void addCreatedNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if ((this.type & 1) == 0) {
                this.createdNodeIndices = new int[1];
                this.createdNodeIndices[0] = node_index;
                this.type |= 1;
            } else {
                if (this.createdNodeIndices != null) {
                    int[] new_created_node_indices = new int[this.createdNodeIndices.length + 1];
                    System.arraycopy(this.createdNodeIndices, 0, new_created_node_indices, 0, this.createdNodeIndices.length);
                    new_created_node_indices[this.createdNodeIndices.length] = node_index;
                    this.createdNodeIndices = new_created_node_indices;
                }
                if (this.createdNodes != null) {
                    Node[] new_created_nodes = new Node[this.createdNodes.length + 1];
                    System.arraycopy(this.createdNodes, 0, new_created_nodes, 0, this.createdNodes.length);
                    new_created_nodes[this.createdNodes.length] = ((RootGraph)this.source).getNode(node_index);
                    this.createdNodes = new_created_nodes;
                }
            }
        }

        public void addCreatedNodeIndices(int[] node_indices) {
            if ((this.type & 1) == 0) {
                this.createdNodeIndices = node_indices;
                this.type |= 1;
            } else {
                if (this.createdNodeIndices != null) {
                    int[] new_created_node_indices = new int[this.createdNodeIndices.length + node_indices.length];
                    System.arraycopy(this.createdNodeIndices, 0, new_created_node_indices, 0, this.createdNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_created_node_indices, this.createdNodeIndices.length, node_indices.length);
                    this.createdNodeIndices = new_created_node_indices;
                }
                if (this.createdNodes != null) {
                    Node[] new_created_nodes = new Node[this.createdNodes.length + node_indices.length];
                    System.arraycopy(this.createdNodes, 0, new_created_nodes, 0, this.createdNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_created_nodes[this.createdNodes.length + node_index_i] = ColtRootGraph.this.getNode(node_indices[node_index_i]);
                    }
                    this.createdNodes = new_created_nodes;
                }
            }
        }

        public void addRemovedEdge(Edge edge) {
            if ((this.type & 8) == 0) {
                this.removedEdges = new Edge[1];
                this.removedEdges[0] = edge;
                this.type |= 8;
            } else {
                if (this.removedEdges != null) {
                    Edge[] new_removed_edges = new Edge[this.removedEdges.length + 1];
                    System.arraycopy(this.removedEdges, 0, new_removed_edges, 0, this.removedEdges.length);
                    new_removed_edges[this.removedEdges.length] = edge;
                    this.removedEdges = new_removed_edges;
                }
                if (this.removedEdgeIndices != null) {
                    int[] new_removed_edge_indices = new int[this.removedEdgeIndices.length + 1];
                    System.arraycopy(this.removedEdgeIndices, 0, new_removed_edge_indices, 0, this.removedEdgeIndices.length);
                    new_removed_edge_indices[this.removedEdgeIndices.length] = edge.getRootGraphIndex();
                    this.removedEdgeIndices = new_removed_edge_indices;
                }
            }
        }

        public void addRemovedEdges(Edge[] edges) {
            if ((this.type & 8) == 0) {
                this.removedEdges = edges;
                this.type |= 8;
            } else {
                if (this.removedEdges != null) {
                    Edge[] new_removed_edges = new Edge[this.removedEdges.length + edges.length];
                    System.arraycopy(this.removedEdges, 0, new_removed_edges, 0, this.removedEdges.length);
                    System.arraycopy(edges, 0, new_removed_edges, this.removedEdges.length, edges.length);
                    this.removedEdges = new_removed_edges;
                }
                if (this.removedEdgeIndices != null) {
                    int[] new_removed_edge_indices = new int[this.removedEdgeIndices.length + edges.length];
                    System.arraycopy(this.removedEdgeIndices, 0, new_removed_edge_indices, 0, this.removedEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_removed_edge_indices[this.removedEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.removedEdgeIndices = new_removed_edge_indices;
                }
            }
        }

        public void addRemovedEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if ((this.type & 8) == 0) {
                this.removedEdgeIndices = new int[1];
                this.removedEdgeIndices[0] = edge_index;
                this.type |= 8;
            } else {
                if (this.removedEdgeIndices != null) {
                    int[] new_removed_edge_indices = new int[this.removedEdgeIndices.length + 1];
                    System.arraycopy(this.removedEdgeIndices, 0, new_removed_edge_indices, 0, this.removedEdgeIndices.length);
                    new_removed_edge_indices[this.removedEdgeIndices.length] = edge_index;
                    this.removedEdgeIndices = new_removed_edge_indices;
                }
                if (this.removedEdges != null) {
                    Edge[] new_removed_edges = new Edge[this.removedEdges.length + 1];
                    System.arraycopy(this.removedEdges, 0, new_removed_edges, 0, this.removedEdges.length);
                    new_removed_edges[this.removedEdges.length] = ((RootGraph)this.source).getEdge(edge_index);
                    this.removedEdges = new_removed_edges;
                }
            }
        }

        public void addRemovedEdgeIndices(int[] edge_indices) {
            if ((this.type & 8) == 0) {
                this.removedEdgeIndices = edge_indices;
                this.type |= 8;
            } else {
                if (this.removedEdgeIndices != null) {
                    int[] new_removed_edge_indices = new int[this.removedEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.removedEdgeIndices, 0, new_removed_edge_indices, 0, this.removedEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_removed_edge_indices, this.removedEdgeIndices.length, edge_indices.length);
                    this.removedEdgeIndices = new_removed_edge_indices;
                }
                if (this.removedEdges != null) {
                    Edge[] new_removed_edges = new Edge[this.removedEdges.length + edge_indices.length];
                    System.arraycopy(this.removedEdges, 0, new_removed_edges, 0, this.removedEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_removed_edges[this.removedEdges.length + edge_index_i] = ColtRootGraph.this.getEdge(edge_indices[edge_index_i]);
                    }
                    this.removedEdges = new_removed_edges;
                }
            }
        }

        public void addCreatedEdge(Edge edge) {
            if ((this.type & 2) == 0) {
                this.createdEdges = new Edge[1];
                this.createdEdges[0] = edge;
                this.type |= 2;
            } else {
                if (this.createdEdges != null) {
                    Edge[] new_created_edges = new Edge[this.createdEdges.length + 1];
                    System.arraycopy(this.createdEdges, 0, new_created_edges, 0, this.createdEdges.length);
                    new_created_edges[this.createdEdges.length] = edge;
                    this.createdEdges = new_created_edges;
                }
                if (this.createdEdgeIndices != null) {
                    int[] new_created_edge_indices = new int[this.createdEdgeIndices.length + 1];
                    System.arraycopy(this.createdEdgeIndices, 0, new_created_edge_indices, 0, this.createdEdgeIndices.length);
                    new_created_edge_indices[this.createdEdgeIndices.length] = edge.getRootGraphIndex();
                    this.createdEdgeIndices = new_created_edge_indices;
                }
            }
        }

        public void addCreatedEdges(Edge[] edges) {
            if ((this.type & 2) == 0) {
                this.createdEdges = edges;
                this.type |= 2;
            } else {
                if (this.createdEdges != null) {
                    Edge[] new_created_edges = new Edge[this.createdEdges.length + edges.length];
                    System.arraycopy(this.createdEdges, 0, new_created_edges, 0, this.createdEdges.length);
                    System.arraycopy(edges, 0, new_created_edges, this.createdEdges.length, edges.length);
                    this.createdEdges = new_created_edges;
                }
                if (this.createdEdgeIndices != null) {
                    int[] new_created_edge_indices = new int[this.createdEdgeIndices.length + edges.length];
                    System.arraycopy(this.createdEdgeIndices, 0, new_created_edge_indices, 0, this.createdEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_created_edge_indices[this.createdEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.createdEdgeIndices = new_created_edge_indices;
                }
            }
        }

        public void addCreatedEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if ((this.type & 2) == 0) {
                this.createdEdgeIndices = new int[1];
                this.createdEdgeIndices[0] = edge_index;
                this.type |= 2;
            } else {
                if (this.createdEdgeIndices != null) {
                    int[] new_created_edge_indices = new int[this.createdEdgeIndices.length + 1];
                    System.arraycopy(this.createdEdgeIndices, 0, new_created_edge_indices, 0, this.createdEdgeIndices.length);
                    new_created_edge_indices[this.createdEdgeIndices.length] = edge_index;
                    this.createdEdgeIndices = new_created_edge_indices;
                }
                if (this.createdEdges != null) {
                    Edge[] new_created_edges = new Edge[this.createdEdges.length + 1];
                    System.arraycopy(this.createdEdges, 0, new_created_edges, 0, this.createdEdges.length);
                    new_created_edges[this.createdEdges.length] = ((RootGraph)this.source).getEdge(edge_index);
                    this.createdEdges = new_created_edges;
                }
            }
        }

        public void addCreatedEdgeIndices(int[] edge_indices) {
            if ((this.type & 2) == 0) {
                this.createdEdgeIndices = edge_indices;
                this.type |= 2;
            } else {
                if (this.createdEdgeIndices != null) {
                    int[] new_created_edge_indices = new int[this.createdEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.createdEdgeIndices, 0, new_created_edge_indices, 0, this.createdEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_created_edge_indices, this.createdEdgeIndices.length, edge_indices.length);
                    this.createdEdgeIndices = new_created_edge_indices;
                }
                if (this.createdEdges != null) {
                    Edge[] new_created_edges = new Edge[this.createdEdges.length + edge_indices.length];
                    System.arraycopy(this.createdEdges, 0, new_created_edges, 0, this.createdEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_created_edges[this.createdEdges.length + edge_index_i] = ColtRootGraph.this.getEdge(edge_indices[edge_index_i]);
                    }
                    this.createdEdges = new_created_edges;
                }
            }
        }

        public void addCreatedMetaRelationshipNode(Node parent_node, Node child_node) {
            if ((this.type & 0x10) == 0) {
                this.metaRelationshipCreatedNodes = new Node[1][];
                this.metaRelationshipCreatedNodes[0] = new Node[2];
                this.metaRelationshipCreatedNodes[0][0] = parent_node;
                this.metaRelationshipCreatedNodes[0][1] = child_node;
                this.type |= 0x10;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_created_nodes = 0;
                if (this.metaRelationshipCreatedNodeIndicesMap != null) {
                    if (this.metaRelationshipCreatedNodeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_created_nodes = this.metaRelationshipCreatedNodeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipCreatedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[][] new_mr_created_nodes = new Node[this.metaRelationshipCreatedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodes, 0, new_mr_created_nodes, 0, this.metaRelationshipCreatedNodes.length);
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length] = new Node[2];
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][0] = parent_node;
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][1] = child_node;
                        this.metaRelationshipCreatedNodes = new_mr_created_nodes;
                    }
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[][] new_mr_created_node_indices = new int[this.metaRelationshipCreatedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodeIndices, 0, new_mr_created_node_indices, 0, this.metaRelationshipCreatedNodeIndices.length);
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length] = new int[2];
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length][0] = parent_node_root_graph_index;
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length][1] = child_node.getRootGraphIndex();
                        this.metaRelationshipCreatedNodeIndices = new_mr_created_node_indices;
                    }
                    if (this.metaRelationshipCreatedNodeIndicesMap == null && this.metaRelationshipCreatedNodes.length >= 2) {
                        this.metaRelationshipCreatedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedNodes.length);
                        if (this.metaRelationshipCreatedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[] brethren = this.metaRelationshipCreatedNodes[parent_node_root_graph_index];
                        Node[] new_brethren = new Node[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = child_node;
                        this.metaRelationshipCreatedNodes[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedNodeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_node.getRootGraphIndex();
                        this.metaRelationshipCreatedNodeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipNodes(Node parent_node, Node[] child_nodes) {
            if ((this.type & 0x10) == 0) {
                this.metaRelationshipCreatedNodes = new Node[1][];
                this.metaRelationshipCreatedNodes[0] = new Node[1 + child_nodes.length];
                this.metaRelationshipCreatedNodes[0][0] = parent_node;
                System.arraycopy(child_nodes, 0, this.metaRelationshipCreatedNodes[0], 1, child_nodes.length);
                this.type |= 0x10;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_created_nodes = 0;
                if (this.metaRelationshipCreatedNodeIndicesMap != null) {
                    if (this.metaRelationshipCreatedNodeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_created_nodes = this.metaRelationshipCreatedNodeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipCreatedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[][] new_mr_created_nodes = new Node[this.metaRelationshipCreatedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodes, 0, new_mr_created_nodes, 0, this.metaRelationshipCreatedNodes.length);
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length] = new Node[1 + child_nodes.length];
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][0] = parent_node;
                        System.arraycopy(child_nodes, 0, this.metaRelationshipCreatedNodes[0], 1, child_nodes.length);
                        this.metaRelationshipCreatedNodes = new_mr_created_nodes;
                    }
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[][] new_mr_created_node_indices = new int[this.metaRelationshipCreatedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodeIndices, 0, new_mr_created_node_indices, 0, this.metaRelationshipCreatedNodeIndices.length);
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length] = new int[1 + child_nodes.length];
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length][0] = parent_node_root_graph_index;
                        for (int child_node_i = 0; child_node_i < child_nodes.length; ++child_node_i) {
                            new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length][1 + child_node_i] = child_nodes[child_node_i].getRootGraphIndex();
                        }
                        this.metaRelationshipCreatedNodeIndices = new_mr_created_node_indices;
                    }
                    if (this.metaRelationshipCreatedNodeIndicesMap == null && this.metaRelationshipCreatedNodes.length >= 2) {
                        this.metaRelationshipCreatedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedNodes.length);
                        if (this.metaRelationshipCreatedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[] brethren = this.metaRelationshipCreatedNodes[parent_node_root_graph_index];
                        Node[] new_brethren = new Node[brethren.length + child_nodes.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        System.arraycopy(child_nodes, 0, new_brethren, brethren.length, child_nodes.length);
                        this.metaRelationshipCreatedNodes[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedNodeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_nodes.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        for (int child_node_i = 0; child_node_i < child_nodes.length; ++child_node_i) {
                            new_brethren_indices[brethren_indices.length + child_node_i] = child_nodes[child_node_i].getRootGraphIndex();
                        }
                        this.metaRelationshipCreatedNodeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipNodeIndex(int parent_node_index, int child_node_index) {
            if ((this.type & 0x10) == 0) {
                this.metaRelationshipCreatedNodeIndices = new int[1][];
                this.metaRelationshipCreatedNodeIndices[0] = new int[2];
                this.metaRelationshipCreatedNodeIndices[0][0] = parent_node_index;
                this.metaRelationshipCreatedNodeIndices[0][1] = child_node_index;
                this.type |= 0x10;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_created_nodes = 0;
                if (this.metaRelationshipCreatedNodeIndicesMap != null) {
                    if (this.metaRelationshipCreatedNodeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_created_nodes = this.metaRelationshipCreatedNodeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipCreatedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[][] new_mr_created_node_indices = new int[this.metaRelationshipCreatedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodeIndices, 0, new_mr_created_node_indices, 0, this.metaRelationshipCreatedNodeIndices.length);
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length] = new int[2];
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length][0] = parent_node_index;
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodes.length][1] = child_node_index;
                        this.metaRelationshipCreatedNodeIndices = new_mr_created_node_indices;
                    }
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[][] new_mr_created_nodes = new Node[this.metaRelationshipCreatedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodes, 0, new_mr_created_nodes, 0, this.metaRelationshipCreatedNodes.length);
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length] = new Node[2];
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][1] = ColtRootGraph.this.getNode(child_node_index);
                        this.metaRelationshipCreatedNodes = new_mr_created_nodes;
                    }
                    if (this.metaRelationshipCreatedNodeIndicesMap == null && this.metaRelationshipCreatedNodes.length >= 2) {
                        this.metaRelationshipCreatedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedNodes.length);
                        if (this.metaRelationshipCreatedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedNodeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_node_index;
                        this.metaRelationshipCreatedNodeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[] brethren = this.metaRelationshipCreatedNodes[parent_node_index];
                        Node[] new_brethren = new Node[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = ColtRootGraph.this.getNode(child_node_index);
                        this.metaRelationshipCreatedNodes[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipNodeIndices(int parent_node_index, int[] child_node_indices) {
            if ((this.type & 0x10) == 0) {
                this.metaRelationshipCreatedNodeIndices = new int[1][];
                this.metaRelationshipCreatedNodeIndices[0] = new int[1 + child_node_indices.length];
                this.metaRelationshipCreatedNodeIndices[0][0] = parent_node_index;
                System.arraycopy(child_node_indices, 0, this.metaRelationshipCreatedNodeIndices[0], 1, child_node_indices.length);
                this.type |= 0x10;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_created_nodes = 0;
                if (this.metaRelationshipCreatedNodeIndicesMap != null) {
                    if (this.metaRelationshipCreatedNodeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_created_nodes = this.metaRelationshipCreatedNodeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipCreatedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_created_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[][] new_mr_created_node_indices = new int[this.metaRelationshipCreatedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodeIndices, 0, new_mr_created_node_indices, 0, this.metaRelationshipCreatedNodeIndices.length);
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length] = new int[1 + child_node_indices.length];
                        new_mr_created_node_indices[this.metaRelationshipCreatedNodeIndices.length][0] = parent_node_index;
                        System.arraycopy(child_node_indices, 0, this.metaRelationshipCreatedNodeIndices[0], 1, child_node_indices.length);
                        this.metaRelationshipCreatedNodeIndices = new_mr_created_node_indices;
                    }
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[][] new_mr_created_nodes = new Node[this.metaRelationshipCreatedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedNodes, 0, new_mr_created_nodes, 0, this.metaRelationshipCreatedNodes.length);
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length] = new Node[1 + child_node_indices.length];
                        new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        for (int child_node_i = 0; child_node_i < child_node_indices.length; ++child_node_i) {
                            new_mr_created_nodes[this.metaRelationshipCreatedNodes.length][1 + child_node_i] = ColtRootGraph.this.getNode(child_node_indices[child_node_i]);
                        }
                        this.metaRelationshipCreatedNodes = new_mr_created_nodes;
                    }
                    if (this.metaRelationshipCreatedNodeIndicesMap == null && this.metaRelationshipCreatedNodes.length >= 2) {
                        this.metaRelationshipCreatedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedNodes.length);
                        if (this.metaRelationshipCreatedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedNodeIndicesMap.put(this.metaRelationshipCreatedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedNodeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_node_indices.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        System.arraycopy(child_node_indices, 0, new_brethren_indices, brethren_indices.length, child_node_indices.length);
                        this.metaRelationshipCreatedNodeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipCreatedNodes != null) {
                        Node[] brethren = this.metaRelationshipCreatedNodes[parent_node_index];
                        Node[] new_brethren = new Node[brethren.length + child_node_indices.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        for (int child_node_i = 0; child_node_i < child_node_indices.length; ++child_node_i) {
                            new_brethren[brethren.length + child_node_i] = ColtRootGraph.this.getNode(child_node_indices[child_node_i]);
                        }
                        this.metaRelationshipCreatedNodes[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipEdge(Node parent_node, Edge child_edge) {
            if ((this.type & 0x20) == 0) {
                this.metaRelationshipCreatedEdges = new Object[1][];
                this.metaRelationshipCreatedEdges[0] = new Object[2];
                this.metaRelationshipCreatedEdges[0][0] = parent_node;
                this.metaRelationshipCreatedEdges[0][1] = child_edge;
                this.type |= 0x20;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_created_edges = 0;
                if (this.metaRelationshipCreatedEdgeIndicesMap != null) {
                    if (this.metaRelationshipCreatedEdgeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_created_edges = this.metaRelationshipCreatedEdgeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipCreatedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedEdgeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipCreatedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[][] new_mr_created_edges = new Object[this.metaRelationshipCreatedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdges, 0, new_mr_created_edges, 0, this.metaRelationshipCreatedEdges.length);
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length] = new Object[2];
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length][0] = parent_node;
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length][1] = child_edge;
                        this.metaRelationshipCreatedEdges = new_mr_created_edges;
                    }
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[][] new_mr_created_edge_indices = new int[this.metaRelationshipCreatedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdgeIndices, 0, new_mr_created_edge_indices, 0, this.metaRelationshipCreatedEdgeIndices.length);
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length] = new int[2];
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length][0] = parent_node_root_graph_index;
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length][1] = child_edge.getRootGraphIndex();
                        this.metaRelationshipCreatedEdgeIndices = new_mr_created_edge_indices;
                    }
                    if (this.metaRelationshipCreatedEdgeIndicesMap == null && this.metaRelationshipCreatedEdges.length >= 2) {
                        this.metaRelationshipCreatedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedEdges.length);
                        if (this.metaRelationshipCreatedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(this.metaRelationshipCreatedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(((Edge)this.metaRelationshipCreatedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[] brethren = this.metaRelationshipCreatedEdges[parent_node_root_graph_index];
                        Object[] new_brethren = new Object[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = child_edge;
                        this.metaRelationshipCreatedEdges[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedEdgeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_edge.getRootGraphIndex();
                        this.metaRelationshipCreatedEdgeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipEdges(Node parent_node, Edge[] child_edges) {
            if ((this.type & 0x20) == 0) {
                this.metaRelationshipCreatedEdges = new Object[1][];
                this.metaRelationshipCreatedEdges[0] = new Object[1 + child_edges.length];
                this.metaRelationshipCreatedEdges[0][0] = parent_node;
                System.arraycopy(child_edges, 0, this.metaRelationshipCreatedEdges[0], 1, child_edges.length);
                this.type |= 0x20;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_created_edges = 0;
                if (this.metaRelationshipCreatedEdgeIndicesMap != null) {
                    if (this.metaRelationshipCreatedEdgeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_created_edges = this.metaRelationshipCreatedEdgeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipCreatedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedEdgeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipCreatedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[][] new_mr_created_edges = new Object[this.metaRelationshipCreatedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdges, 0, new_mr_created_edges, 0, this.metaRelationshipCreatedEdges.length);
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length] = new Object[1 + child_edges.length];
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length][0] = parent_node;
                        System.arraycopy(child_edges, 0, this.metaRelationshipCreatedEdges[0], 1, child_edges.length);
                        this.metaRelationshipCreatedEdges = new_mr_created_edges;
                    }
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[][] new_mr_created_edge_indices = new int[this.metaRelationshipCreatedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdgeIndices, 0, new_mr_created_edge_indices, 0, this.metaRelationshipCreatedEdgeIndices.length);
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length] = new int[1 + child_edges.length];
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length][0] = parent_node_root_graph_index;
                        for (int child_edge_i = 0; child_edge_i < child_edges.length; ++child_edge_i) {
                            new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length][1 + child_edge_i] = child_edges[child_edge_i].getRootGraphIndex();
                        }
                        this.metaRelationshipCreatedEdgeIndices = new_mr_created_edge_indices;
                    }
                    if (this.metaRelationshipCreatedEdgeIndicesMap == null && this.metaRelationshipCreatedEdges.length >= 2) {
                        this.metaRelationshipCreatedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedEdges.length);
                        if (this.metaRelationshipCreatedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(this.metaRelationshipCreatedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(((Edge)this.metaRelationshipCreatedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[] brethren = this.metaRelationshipCreatedEdges[parent_node_root_graph_index];
                        Object[] new_brethren = new Object[brethren.length + child_edges.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        System.arraycopy(child_edges, 0, new_brethren, brethren.length, child_edges.length);
                        this.metaRelationshipCreatedEdges[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedEdgeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_edges.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        for (int child_edge_i = 0; child_edge_i < child_edges.length; ++child_edge_i) {
                            new_brethren_indices[brethren_indices.length + child_edge_i] = child_edges[child_edge_i].getRootGraphIndex();
                        }
                        this.metaRelationshipCreatedEdgeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipEdgeIndex(int parent_node_index, int child_edge_index) {
            if ((this.type & 0x20) == 0) {
                this.metaRelationshipCreatedEdgeIndices = new int[1][];
                this.metaRelationshipCreatedEdgeIndices[0] = new int[2];
                this.metaRelationshipCreatedEdgeIndices[0][0] = parent_node_index;
                this.metaRelationshipCreatedEdgeIndices[0][1] = child_edge_index;
                this.type |= 0x20;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_created_edges = 0;
                if (this.metaRelationshipCreatedEdgeIndicesMap != null) {
                    if (this.metaRelationshipCreatedEdgeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_created_edges = this.metaRelationshipCreatedEdgeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipCreatedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedEdgeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipCreatedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[][] new_mr_created_edge_indices = new int[this.metaRelationshipCreatedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdgeIndices, 0, new_mr_created_edge_indices, 0, this.metaRelationshipCreatedEdgeIndices.length);
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length] = new int[2];
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length][0] = parent_node_index;
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdges.length][1] = child_edge_index;
                        this.metaRelationshipCreatedEdgeIndices = new_mr_created_edge_indices;
                    }
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[][] new_mr_created_edges = new Object[this.metaRelationshipCreatedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdges, 0, new_mr_created_edges, 0, this.metaRelationshipCreatedEdges.length);
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length] = new Object[2];
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length][1] = ColtRootGraph.this.getEdge(child_edge_index);
                        this.metaRelationshipCreatedEdges = new_mr_created_edges;
                    }
                    if (this.metaRelationshipCreatedEdgeIndicesMap == null && this.metaRelationshipCreatedEdges.length >= 2) {
                        this.metaRelationshipCreatedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedEdges.length);
                        if (this.metaRelationshipCreatedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(this.metaRelationshipCreatedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(((Edge)this.metaRelationshipCreatedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedEdgeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_edge_index;
                        this.metaRelationshipCreatedEdgeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[] brethren = this.metaRelationshipCreatedEdges[parent_node_index];
                        Object[] new_brethren = new Object[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = ColtRootGraph.this.getEdge(child_edge_index);
                        this.metaRelationshipCreatedEdges[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addCreatedMetaRelationshipEdgeIndices(int parent_node_index, int[] child_edge_indices) {
            if ((this.type & 0x20) == 0) {
                this.metaRelationshipCreatedEdgeIndices = new int[1][];
                this.metaRelationshipCreatedEdgeIndices[0] = new int[1 + child_edge_indices.length];
                this.metaRelationshipCreatedEdgeIndices[0][0] = parent_node_index;
                System.arraycopy(child_edge_indices, 0, this.metaRelationshipCreatedEdgeIndices[0], 1, child_edge_indices.length);
                this.type |= 0x20;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_created_edges = 0;
                if (this.metaRelationshipCreatedEdgeIndicesMap != null) {
                    if (this.metaRelationshipCreatedEdgeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_created_edges = this.metaRelationshipCreatedEdgeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipCreatedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipCreatedEdgeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipCreatedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipCreatedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_created_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[][] new_mr_created_edge_indices = new int[this.metaRelationshipCreatedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdgeIndices, 0, new_mr_created_edge_indices, 0, this.metaRelationshipCreatedEdgeIndices.length);
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length] = new int[1 + child_edge_indices.length];
                        new_mr_created_edge_indices[this.metaRelationshipCreatedEdgeIndices.length][0] = parent_node_index;
                        System.arraycopy(child_edge_indices, 0, this.metaRelationshipCreatedEdgeIndices[0], 1, child_edge_indices.length);
                        this.metaRelationshipCreatedEdgeIndices = new_mr_created_edge_indices;
                    }
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[][] new_mr_created_edges = new Object[this.metaRelationshipCreatedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipCreatedEdges, 0, new_mr_created_edges, 0, this.metaRelationshipCreatedEdges.length);
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length] = new Object[1 + child_edge_indices.length];
                        new_mr_created_edges[this.metaRelationshipCreatedEdges.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        for (int child_edge_i = 0; child_edge_i < child_edge_indices.length; ++child_edge_i) {
                            new_mr_created_edges[this.metaRelationshipCreatedEdges.length][1 + child_edge_i] = ColtRootGraph.this.getEdge(child_edge_indices[child_edge_i]);
                        }
                        this.metaRelationshipCreatedEdges = new_mr_created_edges;
                    }
                    if (this.metaRelationshipCreatedEdgeIndicesMap == null && this.metaRelationshipCreatedEdges.length >= 2) {
                        this.metaRelationshipCreatedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipCreatedEdges.length);
                        if (this.metaRelationshipCreatedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipCreatedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(this.metaRelationshipCreatedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipCreatedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipCreatedEdgeIndicesMap.put(((Edge)this.metaRelationshipCreatedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipCreatedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipCreatedEdgeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_edge_indices.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        System.arraycopy(child_edge_indices, 0, new_brethren_indices, brethren_indices.length, child_edge_indices.length);
                        this.metaRelationshipCreatedEdgeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipCreatedEdges != null) {
                        Object[] brethren = this.metaRelationshipCreatedEdges[parent_node_index];
                        Object[] new_brethren = new Object[brethren.length + child_edge_indices.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        for (int child_edge_i = 0; child_edge_i < child_edge_indices.length; ++child_edge_i) {
                            new_brethren[brethren.length + child_edge_i] = ColtRootGraph.this.getEdge(child_edge_indices[child_edge_i]);
                        }
                        this.metaRelationshipCreatedEdges[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipNode(Node parent_node, Node child_node) {
            if ((this.type & 0x40) == 0) {
                this.metaRelationshipRemovedNodes = new Node[1][];
                this.metaRelationshipRemovedNodes[0] = new Node[2];
                this.metaRelationshipRemovedNodes[0][0] = parent_node;
                this.metaRelationshipRemovedNodes[0][1] = child_node;
                this.type |= 0x40;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_removed_nodes = 0;
                if (this.metaRelationshipRemovedNodeIndicesMap != null) {
                    if (this.metaRelationshipRemovedNodeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_removed_nodes = this.metaRelationshipRemovedNodeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipRemovedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[][] new_mr_removed_nodes = new Node[this.metaRelationshipRemovedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodes, 0, new_mr_removed_nodes, 0, this.metaRelationshipRemovedNodes.length);
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length] = new Node[2];
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][0] = parent_node;
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][1] = child_node;
                        this.metaRelationshipRemovedNodes = new_mr_removed_nodes;
                    }
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[][] new_mr_removed_node_indices = new int[this.metaRelationshipRemovedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodeIndices, 0, new_mr_removed_node_indices, 0, this.metaRelationshipRemovedNodeIndices.length);
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length] = new int[2];
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length][0] = parent_node_root_graph_index;
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length][1] = child_node.getRootGraphIndex();
                        this.metaRelationshipRemovedNodeIndices = new_mr_removed_node_indices;
                    }
                    if (this.metaRelationshipRemovedNodeIndicesMap == null && this.metaRelationshipRemovedNodes.length >= 2) {
                        this.metaRelationshipRemovedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedNodes.length);
                        if (this.metaRelationshipRemovedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[] brethren = this.metaRelationshipRemovedNodes[parent_node_root_graph_index];
                        Node[] new_brethren = new Node[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = child_node;
                        this.metaRelationshipRemovedNodes[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedNodeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_node.getRootGraphIndex();
                        this.metaRelationshipRemovedNodeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipNodes(Node parent_node, Node[] child_nodes) {
            if ((this.type & 0x40) == 0) {
                this.metaRelationshipRemovedNodes = new Node[1][];
                this.metaRelationshipRemovedNodes[0] = new Node[1 + child_nodes.length];
                this.metaRelationshipRemovedNodes[0][0] = parent_node;
                System.arraycopy(child_nodes, 0, this.metaRelationshipRemovedNodes[0], 1, child_nodes.length);
                this.type |= 0x40;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_removed_nodes = 0;
                if (this.metaRelationshipRemovedNodeIndicesMap != null) {
                    if (this.metaRelationshipRemovedNodeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_removed_nodes = this.metaRelationshipRemovedNodeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipRemovedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[][] new_mr_removed_nodes = new Node[this.metaRelationshipRemovedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodes, 0, new_mr_removed_nodes, 0, this.metaRelationshipRemovedNodes.length);
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length] = new Node[1 + child_nodes.length];
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][0] = parent_node;
                        System.arraycopy(child_nodes, 0, this.metaRelationshipRemovedNodes[0], 1, child_nodes.length);
                        this.metaRelationshipRemovedNodes = new_mr_removed_nodes;
                    }
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[][] new_mr_removed_node_indices = new int[this.metaRelationshipRemovedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodeIndices, 0, new_mr_removed_node_indices, 0, this.metaRelationshipRemovedNodeIndices.length);
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length] = new int[1 + child_nodes.length];
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length][0] = parent_node_root_graph_index;
                        for (int child_node_i = 0; child_node_i < child_nodes.length; ++child_node_i) {
                            new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length][1 + child_node_i] = child_nodes[child_node_i].getRootGraphIndex();
                        }
                        this.metaRelationshipRemovedNodeIndices = new_mr_removed_node_indices;
                    }
                    if (this.metaRelationshipRemovedNodeIndicesMap == null && this.metaRelationshipRemovedNodes.length >= 2) {
                        this.metaRelationshipRemovedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedNodes.length);
                        if (this.metaRelationshipRemovedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[] brethren = this.metaRelationshipRemovedNodes[parent_node_root_graph_index];
                        Node[] new_brethren = new Node[brethren.length + child_nodes.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        System.arraycopy(child_nodes, 0, new_brethren, brethren.length, child_nodes.length);
                        this.metaRelationshipRemovedNodes[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedNodeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_nodes.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        for (int child_node_i = 0; child_node_i < child_nodes.length; ++child_node_i) {
                            new_brethren_indices[brethren_indices.length + child_node_i] = child_nodes[child_node_i].getRootGraphIndex();
                        }
                        this.metaRelationshipRemovedNodeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipNodeIndex(int parent_node_index, int child_node_index) {
            if ((this.type & 0x40) == 0) {
                this.metaRelationshipRemovedNodeIndices = new int[1][];
                this.metaRelationshipRemovedNodeIndices[0] = new int[2];
                this.metaRelationshipRemovedNodeIndices[0][0] = parent_node_index;
                this.metaRelationshipRemovedNodeIndices[0][1] = child_node_index;
                this.type |= 0x40;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_removed_nodes = 0;
                if (this.metaRelationshipRemovedNodeIndicesMap != null) {
                    if (this.metaRelationshipRemovedNodeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_removed_nodes = this.metaRelationshipRemovedNodeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipRemovedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[][] new_mr_removed_node_indices = new int[this.metaRelationshipRemovedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodeIndices, 0, new_mr_removed_node_indices, 0, this.metaRelationshipRemovedNodeIndices.length);
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length] = new int[2];
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length][0] = parent_node_index;
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodes.length][1] = child_node_index;
                        this.metaRelationshipRemovedNodeIndices = new_mr_removed_node_indices;
                    }
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[][] new_mr_removed_nodes = new Node[this.metaRelationshipRemovedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodes, 0, new_mr_removed_nodes, 0, this.metaRelationshipRemovedNodes.length);
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length] = new Node[2];
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][1] = ColtRootGraph.this.getNode(child_node_index);
                        this.metaRelationshipRemovedNodes = new_mr_removed_nodes;
                    }
                    if (this.metaRelationshipRemovedNodeIndicesMap == null && this.metaRelationshipRemovedNodes.length >= 2) {
                        this.metaRelationshipRemovedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedNodes.length);
                        if (this.metaRelationshipRemovedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedNodeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_node_index;
                        this.metaRelationshipRemovedNodeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[] brethren = this.metaRelationshipRemovedNodes[parent_node_index];
                        Node[] new_brethren = new Node[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = ColtRootGraph.this.getNode(child_node_index);
                        this.metaRelationshipRemovedNodes[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipNodeIndices(int parent_node_index, int[] child_node_indices) {
            if ((this.type & 0x40) == 0) {
                this.metaRelationshipRemovedNodeIndices = new int[1][];
                this.metaRelationshipRemovedNodeIndices[0] = new int[1 + child_node_indices.length];
                this.metaRelationshipRemovedNodeIndices[0][0] = parent_node_index;
                System.arraycopy(child_node_indices, 0, this.metaRelationshipRemovedNodeIndices[0], 1, child_node_indices.length);
                this.type |= 0x40;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_removed_nodes = 0;
                if (this.metaRelationshipRemovedNodeIndicesMap != null) {
                    if (this.metaRelationshipRemovedNodeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_removed_nodes = this.metaRelationshipRemovedNodeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipRemovedNodeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedNodes.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedNodes[parent_node_i][0].getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_removed_nodes = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[][] new_mr_removed_node_indices = new int[this.metaRelationshipRemovedNodeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodeIndices, 0, new_mr_removed_node_indices, 0, this.metaRelationshipRemovedNodeIndices.length);
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length] = new int[1 + child_node_indices.length];
                        new_mr_removed_node_indices[this.metaRelationshipRemovedNodeIndices.length][0] = parent_node_index;
                        System.arraycopy(child_node_indices, 0, this.metaRelationshipRemovedNodeIndices[0], 1, child_node_indices.length);
                        this.metaRelationshipRemovedNodeIndices = new_mr_removed_node_indices;
                    }
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[][] new_mr_removed_nodes = new Node[this.metaRelationshipRemovedNodes.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedNodes, 0, new_mr_removed_nodes, 0, this.metaRelationshipRemovedNodes.length);
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length] = new Node[1 + child_node_indices.length];
                        new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        for (int child_node_i = 0; child_node_i < child_node_indices.length; ++child_node_i) {
                            new_mr_removed_nodes[this.metaRelationshipRemovedNodes.length][1 + child_node_i] = ColtRootGraph.this.getNode(child_node_indices[child_node_i]);
                        }
                        this.metaRelationshipRemovedNodes = new_mr_removed_nodes;
                    }
                    if (this.metaRelationshipRemovedNodeIndicesMap == null && this.metaRelationshipRemovedNodes.length >= 2) {
                        this.metaRelationshipRemovedNodeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedNodes.length);
                        if (this.metaRelationshipRemovedNodeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedNodeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedNodes.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedNodeIndicesMap.put(this.metaRelationshipRemovedNodes[parent_node_i3][0].getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedNodeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedNodeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_node_indices.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        System.arraycopy(child_node_indices, 0, new_brethren_indices, brethren_indices.length, child_node_indices.length);
                        this.metaRelationshipRemovedNodeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipRemovedNodes != null) {
                        Node[] brethren = this.metaRelationshipRemovedNodes[parent_node_index];
                        Node[] new_brethren = new Node[brethren.length + child_node_indices.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        for (int child_node_i = 0; child_node_i < child_node_indices.length; ++child_node_i) {
                            new_brethren[brethren.length + child_node_i] = ColtRootGraph.this.getNode(child_node_indices[child_node_i]);
                        }
                        this.metaRelationshipRemovedNodes[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipEdge(Node parent_node, Edge child_edge) {
            if ((this.type & 0x80) == 0) {
                this.metaRelationshipRemovedEdges = new Object[1][];
                this.metaRelationshipRemovedEdges[0] = new Object[2];
                this.metaRelationshipRemovedEdges[0][0] = parent_node;
                this.metaRelationshipRemovedEdges[0][1] = child_edge;
                this.type |= 0x80;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_removed_edges = 0;
                if (this.metaRelationshipRemovedEdgeIndicesMap != null) {
                    if (this.metaRelationshipRemovedEdgeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_removed_edges = this.metaRelationshipRemovedEdgeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipRemovedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedEdgeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipRemovedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[][] new_mr_removed_edges = new Object[this.metaRelationshipRemovedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdges, 0, new_mr_removed_edges, 0, this.metaRelationshipRemovedEdges.length);
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length] = new Object[2];
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][0] = parent_node;
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][1] = child_edge;
                        this.metaRelationshipRemovedEdges = new_mr_removed_edges;
                    }
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[][] new_mr_removed_edge_indices = new int[this.metaRelationshipRemovedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdgeIndices, 0, new_mr_removed_edge_indices, 0, this.metaRelationshipRemovedEdgeIndices.length);
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length] = new int[2];
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length][0] = parent_node_root_graph_index;
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length][1] = child_edge.getRootGraphIndex();
                        this.metaRelationshipRemovedEdgeIndices = new_mr_removed_edge_indices;
                    }
                    if (this.metaRelationshipRemovedEdgeIndicesMap == null && this.metaRelationshipRemovedEdges.length >= 2) {
                        this.metaRelationshipRemovedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedEdges.length);
                        if (this.metaRelationshipRemovedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(this.metaRelationshipRemovedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(((Edge)this.metaRelationshipRemovedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[] brethren = this.metaRelationshipRemovedEdges[parent_node_root_graph_index];
                        Object[] new_brethren = new Object[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = child_edge;
                        this.metaRelationshipRemovedEdges[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedEdgeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_edge.getRootGraphIndex();
                        this.metaRelationshipRemovedEdgeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipEdges(Node parent_node, Edge[] child_edges) {
            if ((this.type & 0x80) == 0) {
                this.metaRelationshipRemovedEdges = new Object[1][];
                this.metaRelationshipRemovedEdges[0] = new Object[1 + child_edges.length];
                this.metaRelationshipRemovedEdges[0][0] = parent_node;
                System.arraycopy(child_edges, 0, this.metaRelationshipRemovedEdges[0], 1, child_edges.length);
                this.type |= 0x80;
            } else {
                int parent_node_i;
                int parent_node_root_graph_index = parent_node.getRootGraphIndex();
                int parent_node_index_in_mr_removed_edges = 0;
                if (this.metaRelationshipRemovedEdgeIndicesMap != null) {
                    if (this.metaRelationshipRemovedEdgeIndicesMap.containsKey(parent_node_root_graph_index)) {
                        parent_node_index_in_mr_removed_edges = this.metaRelationshipRemovedEdgeIndicesMap.get(parent_node_root_graph_index);
                    }
                } else if (this.metaRelationshipRemovedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedEdgeIndices[parent_node_i][0] != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipRemovedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_root_graph_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_root_graph_index == 0) {
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[][] new_mr_removed_edges = new Object[this.metaRelationshipRemovedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdges, 0, new_mr_removed_edges, 0, this.metaRelationshipRemovedEdges.length);
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length] = new Object[1 + child_edges.length];
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][0] = parent_node;
                        System.arraycopy(child_edges, 0, this.metaRelationshipRemovedEdges[0], 1, child_edges.length);
                        this.metaRelationshipRemovedEdges = new_mr_removed_edges;
                    }
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[][] new_mr_removed_edge_indices = new int[this.metaRelationshipRemovedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdgeIndices, 0, new_mr_removed_edge_indices, 0, this.metaRelationshipRemovedEdgeIndices.length);
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length] = new int[1 + child_edges.length];
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length][0] = parent_node_root_graph_index;
                        for (int child_edge_i = 0; child_edge_i < child_edges.length; ++child_edge_i) {
                            new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length][1 + child_edge_i] = child_edges[child_edge_i].getRootGraphIndex();
                        }
                        this.metaRelationshipRemovedEdgeIndices = new_mr_removed_edge_indices;
                    }
                    if (this.metaRelationshipRemovedEdgeIndicesMap == null && this.metaRelationshipRemovedEdges.length >= 2) {
                        this.metaRelationshipRemovedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedEdges.length);
                        if (this.metaRelationshipRemovedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(this.metaRelationshipRemovedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(((Edge)this.metaRelationshipRemovedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[] brethren = this.metaRelationshipRemovedEdges[parent_node_root_graph_index];
                        Object[] new_brethren = new Object[brethren.length + child_edges.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        System.arraycopy(child_edges, 0, new_brethren, brethren.length, child_edges.length);
                        this.metaRelationshipRemovedEdges[parent_node_root_graph_index] = new_brethren;
                    }
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedEdgeIndices[parent_node_root_graph_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_edges.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        for (int child_edge_i = 0; child_edge_i < child_edges.length; ++child_edge_i) {
                            new_brethren_indices[brethren_indices.length + child_edge_i] = child_edges[child_edge_i].getRootGraphIndex();
                        }
                        this.metaRelationshipRemovedEdgeIndices[parent_node_root_graph_index] = new_brethren_indices;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipEdgeIndex(int parent_node_index, int child_edge_index) {
            if ((this.type & 0x80) == 0) {
                this.metaRelationshipRemovedEdgeIndices = new int[1][];
                this.metaRelationshipRemovedEdgeIndices[0] = new int[2];
                this.metaRelationshipRemovedEdgeIndices[0][0] = parent_node_index;
                this.metaRelationshipRemovedEdgeIndices[0][1] = child_edge_index;
                this.type |= 0x80;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_removed_edges = 0;
                if (this.metaRelationshipRemovedEdgeIndicesMap != null) {
                    if (this.metaRelationshipRemovedEdgeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_removed_edges = this.metaRelationshipRemovedEdgeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipRemovedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedEdgeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipRemovedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[][] new_mr_removed_edge_indices = new int[this.metaRelationshipRemovedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdgeIndices, 0, new_mr_removed_edge_indices, 0, this.metaRelationshipRemovedEdgeIndices.length);
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length] = new int[2];
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length][0] = parent_node_index;
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdges.length][1] = child_edge_index;
                        this.metaRelationshipRemovedEdgeIndices = new_mr_removed_edge_indices;
                    }
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[][] new_mr_removed_edges = new Object[this.metaRelationshipRemovedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdges, 0, new_mr_removed_edges, 0, this.metaRelationshipRemovedEdges.length);
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length] = new Object[2];
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][1] = ColtRootGraph.this.getEdge(child_edge_index);
                        this.metaRelationshipRemovedEdges = new_mr_removed_edges;
                    }
                    if (this.metaRelationshipRemovedEdgeIndicesMap == null && this.metaRelationshipRemovedEdges.length >= 2) {
                        this.metaRelationshipRemovedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedEdges.length);
                        if (this.metaRelationshipRemovedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(this.metaRelationshipRemovedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(((Edge)this.metaRelationshipRemovedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedEdgeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + 1];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        new_brethren_indices[brethren_indices.length] = child_edge_index;
                        this.metaRelationshipRemovedEdgeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[] brethren = this.metaRelationshipRemovedEdges[parent_node_index];
                        Object[] new_brethren = new Object[brethren.length + 1];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        new_brethren[brethren.length] = ColtRootGraph.this.getEdge(child_edge_index);
                        this.metaRelationshipRemovedEdges[parent_node_index] = new_brethren;
                    }
                }
            }
        }

        public void addRemovedMetaRelationshipEdgeIndices(int parent_node_index, int[] child_edge_indices) {
            if ((this.type & 0x80) == 0) {
                this.metaRelationshipRemovedEdgeIndices = new int[1][];
                this.metaRelationshipRemovedEdgeIndices[0] = new int[1 + child_edge_indices.length];
                this.metaRelationshipRemovedEdgeIndices[0][0] = parent_node_index;
                System.arraycopy(child_edge_indices, 0, this.metaRelationshipRemovedEdgeIndices[0], 1, child_edge_indices.length);
                this.type |= 0x80;
            } else {
                int parent_node_i;
                int parent_node_index_in_mr_removed_edges = 0;
                if (this.metaRelationshipRemovedEdgeIndicesMap != null) {
                    if (this.metaRelationshipRemovedEdgeIndicesMap.containsKey(parent_node_index)) {
                        parent_node_index_in_mr_removed_edges = this.metaRelationshipRemovedEdgeIndicesMap.get(parent_node_index);
                    }
                } else if (this.metaRelationshipRemovedEdgeIndices != null) {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i) {
                        if (this.metaRelationshipRemovedEdgeIndices[parent_node_i][0] != parent_node_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                } else {
                    for (parent_node_i = 0; parent_node_i < this.metaRelationshipRemovedEdges.length; ++parent_node_i) {
                        if (((Edge)this.metaRelationshipRemovedEdges[parent_node_i][0]).getRootGraphIndex() != parent_node_index) continue;
                        parent_node_index_in_mr_removed_edges = parent_node_i;
                        break;
                    }
                }
                if (parent_node_index == 0) {
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[][] new_mr_removed_edge_indices = new int[this.metaRelationshipRemovedEdgeIndices.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdgeIndices, 0, new_mr_removed_edge_indices, 0, this.metaRelationshipRemovedEdgeIndices.length);
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length] = new int[1 + child_edge_indices.length];
                        new_mr_removed_edge_indices[this.metaRelationshipRemovedEdgeIndices.length][0] = parent_node_index;
                        System.arraycopy(child_edge_indices, 0, this.metaRelationshipRemovedEdgeIndices[0], 1, child_edge_indices.length);
                        this.metaRelationshipRemovedEdgeIndices = new_mr_removed_edge_indices;
                    }
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[][] new_mr_removed_edges = new Object[this.metaRelationshipRemovedEdges.length + 1][];
                        System.arraycopy(this.metaRelationshipRemovedEdges, 0, new_mr_removed_edges, 0, this.metaRelationshipRemovedEdges.length);
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length] = new Object[1 + child_edge_indices.length];
                        new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][0] = ColtRootGraph.this.getNode(parent_node_index);
                        for (int child_edge_i = 0; child_edge_i < child_edge_indices.length; ++child_edge_i) {
                            new_mr_removed_edges[this.metaRelationshipRemovedEdges.length][1 + child_edge_i] = ColtRootGraph.this.getEdge(child_edge_indices[child_edge_i]);
                        }
                        this.metaRelationshipRemovedEdges = new_mr_removed_edges;
                    }
                    if (this.metaRelationshipRemovedEdgeIndicesMap == null && this.metaRelationshipRemovedEdges.length >= 2) {
                        this.metaRelationshipRemovedEdgeIndicesMap = new OpenIntIntHashMap(this.metaRelationshipRemovedEdges.length);
                        if (this.metaRelationshipRemovedEdgeIndices != null) {
                            for (int parent_node_i2 = 0; parent_node_i2 < this.metaRelationshipRemovedEdgeIndices.length; ++parent_node_i2) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(this.metaRelationshipRemovedEdgeIndices[parent_node_i2][0], parent_node_i2);
                            }
                        } else {
                            for (int parent_node_i3 = 0; parent_node_i3 < this.metaRelationshipRemovedEdges.length; ++parent_node_i3) {
                                this.metaRelationshipRemovedEdgeIndicesMap.put(((Edge)this.metaRelationshipRemovedEdges[parent_node_i3][0]).getRootGraphIndex(), parent_node_i3);
                            }
                        }
                    }
                } else {
                    if (this.metaRelationshipRemovedEdgeIndices != null) {
                        int[] brethren_indices = this.metaRelationshipRemovedEdgeIndices[parent_node_index];
                        int[] new_brethren_indices = new int[brethren_indices.length + child_edge_indices.length];
                        System.arraycopy(brethren_indices, 0, new_brethren_indices, 0, brethren_indices.length);
                        System.arraycopy(child_edge_indices, 0, new_brethren_indices, brethren_indices.length, child_edge_indices.length);
                        this.metaRelationshipRemovedEdgeIndices[parent_node_index] = new_brethren_indices;
                    }
                    if (this.metaRelationshipRemovedEdges != null) {
                        Object[] brethren = this.metaRelationshipRemovedEdges[parent_node_index];
                        Object[] new_brethren = new Object[brethren.length + child_edge_indices.length];
                        System.arraycopy(brethren, 0, new_brethren, 0, brethren.length);
                        for (int child_edge_i = 0; child_edge_i < child_edge_indices.length; ++child_edge_i) {
                            new_brethren[brethren.length + child_edge_i] = ColtRootGraph.this.getEdge(child_edge_indices[child_edge_i]);
                        }
                        this.metaRelationshipRemovedEdges[parent_node_index] = new_brethren;
                    }
                }
            }
        }
    }
}

