/*
 * Decompiled with CFR 0.152.
 */
package coltginy;

import cern.colt.function.IntIntProcedure;
import cern.colt.function.IntProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cern.colt.matrix.ObjectMatrix2D;
import coltginy.ColtRootGraph;
import coltginy.ColtginyConstants;
import giny.filter.Filter;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import giny.model.RootGraph;
import giny.model.RootGraphChangeEvent;
import giny.model.RootGraphChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.EventListenerList;

public class ColtGraphPerspective
implements GraphPerspective,
RootGraphChangeListener {
    protected static String NOT_INITIALIZED_EXCEPTION_STRING = "You must first set the rootGraph, rootNodeIndexToPerspectiveNodeIndexMap, and rootEdgeIndexToPerspectiveEdgeIndexMap of this ColtGraphPerspective.";
    protected ColtRootGraph rootGraph;
    protected ObjectMatrix2D coltNodeDataPerspective;
    protected ObjectMatrix2D coltEdgeDataPerspective;
    protected int nodeCount;
    protected int edgeCount;
    protected OpenIntIntHashMap rootNodeIndexToPerspectiveNodeIndexMap;
    protected int[] perspectiveNodeIndexToRootNodeIndexArray;
    protected OpenIntIntHashMap rootEdgeIndexToPerspectiveEdgeIndexMap;
    protected int[] perspectiveEdgeIndexToRootEdgeIndexArray;
    protected OldNodeMapProcedure oldNodeMapProcedure;
    protected NewNodeMapProcedure newNodeMapProcedure;
    protected OldEdgeMapProcedure oldEdgeMapProcedure;
    protected NewEdgeMapProcedure newEdgeMapProcedure;
    protected ContiguityEnsuringProcedure contiguityEnsuringProcedure;
    protected ChangeEvent coltGraphPerspectiveChangeEvent;
    EventListenerList listenerList = new EventListenerList();
    protected boolean coltGraphPerspectiveInitialized = false;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$giny$model$GraphPerspectiveChangeListener;

    public ColtGraphPerspective() {
        this(null, null, null);
    }

    public ColtGraphPerspective(RootGraph root_graph, OpenIntIntHashMap r_node_i_to_p_node_i_map, OpenIntIntHashMap r_edge_i_to_p_edge_i_map) {
        this.setRootGraph((ColtRootGraph)root_graph);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(r_node_i_to_p_node_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(r_edge_i_to_p_edge_i_map);
    }

    protected void initializeColtGraphPerspective() {
        if (this.coltGraphPerspectiveInitialized) {
            return;
        }
        if (this.rootGraph == null || this.rootNodeIndexToPerspectiveNodeIndexMap == null || this.rootEdgeIndexToPerspectiveEdgeIndexMap == null || this.coltNodeDataPerspective == null || this.coltEdgeDataPerspective == null) {
            throw new IllegalStateException("Before initializing the ColtGraphPerspective you must first set its rootGraph, rootNodeIndexToPerspectiveNodeIndexMap, and rootEdgeIndexToPerspectiveEdgeIndexMap to non-null values.  The coltNodeDataPerspective and coltEdgeDataPerspective must also be non-null, but this should be accomplished automatically if the other three values are non-null.");
        }
        this.coltGraphPerspectiveInitialized = true;
    }

    protected void setRootGraph(ColtRootGraph root_graph) {
        if (this.rootGraph != null) {
            if (this.rootGraph == root_graph) {
                return;
            }
            throw new IllegalStateException("Once the rootGraph is set it may not be re-set.");
        }
        this.rootGraph = root_graph;
        this.rootGraph.addRootGraphChangeListener(this);
    }

    protected void setColtNodeDataPerspective(ObjectMatrix2D matrix_view) {
        if (this.coltNodeDataPerspective == matrix_view) {
            return;
        }
        if (ColtginyConstants.USE_ASSERTIONS && this.rootNodeIndexToPerspectiveNodeIndexMap == null) {
            throw new Error("Assertion failed: rootNodeIndexToPerspectiveNodeIndexMap must not be null when setColtNodeDataPerspective is called.");
        }
        ObjectMatrix2D old_cdp = this.coltNodeDataPerspective;
        this.coltNodeDataPerspective = matrix_view;
        if (this.rootGraph != null && this.rootEdgeIndexToPerspectiveEdgeIndexMap != null && this.coltNodeDataPerspective != null && this.coltEdgeDataPerspective != null && !this.coltGraphPerspectiveInitialized) {
            this.initializeColtGraphPerspective();
        }
        this.coltNodeDataPerspectiveChanged(old_cdp, this.coltNodeDataPerspective);
    }

    protected void coltNodeDataPerspectiveChanged(ObjectMatrix2D old_colt_node_data_perspective, ObjectMatrix2D new_colt_node_data_perspective) {
        this.nodeCount = this.coltNodeDataPerspective.columns() - 1;
    }

    protected void setRootNodeIndexToPerspectiveNodeIndexMap(OpenIntIntHashMap r_node_i_to_p_node_i_map) {
        ChangeEvent event = null;
        if (this.coltGraphPerspectiveInitialized) {
            event = this.getChangeEvent();
        }
        this.setRootNodeIndexToPerspectiveNodeIndexMap(r_node_i_to_p_node_i_map, true, event);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
    }

    protected void setRootNodeIndexToPerspectiveNodeIndexMap(OpenIntIntHashMap r_node_i_to_p_node_i_map, boolean hide_all_incident_edges, ChangeEvent event) {
        if (this.rootNodeIndexToPerspectiveNodeIndexMap == r_node_i_to_p_node_i_map || this.rootNodeIndexToPerspectiveNodeIndexMap != null && r_node_i_to_p_node_i_map != null && this.rootNodeIndexToPerspectiveNodeIndexMap.equals(r_node_i_to_p_node_i_map)) {
            return;
        }
        if (this.rootGraph == null) {
            throw new IllegalStateException("rootGraph must not be null when setRootNodeIndexToPerspectiveNodeIndexMap is called.");
        }
        if (r_node_i_to_p_node_i_map == null) {
            throw new IllegalArgumentException("You may not set rootNodeIndexToPerspectiveNodeIndexMap to null.");
        }
        OpenIntIntHashMap old_map = this.rootNodeIndexToPerspectiveNodeIndexMap;
        this.rootNodeIndexToPerspectiveNodeIndexMap = r_node_i_to_p_node_i_map;
        this.rootNodeIndexToPerspectiveNodeIndexMapChanged(old_map, this.rootNodeIndexToPerspectiveNodeIndexMap, hide_all_incident_edges, event);
    }

    protected void rootNodeIndexToPerspectiveNodeIndexMapChanged(OpenIntIntHashMap old_r_node_i_to_p_node_i_map, OpenIntIntHashMap new_r_node_i_to_p_node_i_map, boolean hide_all_incident_edges, ChangeEvent event) {
        OldNodeMapProcedure old_proc = null;
        if (hide_all_incident_edges || event != null) {
            old_proc = this.getOldNodeMapProcedure();
            old_proc.newRNodeIToPNodeIMap = new_r_node_i_to_p_node_i_map;
            if (old_r_node_i_to_p_node_i_map != null) {
                old_r_node_i_to_p_node_i_map.forEachPair(old_proc);
            }
        }
        NewNodeMapProcedure new_proc = this.getNewNodeMapProcedure();
        new_proc.oldRNodeIToPNodeIMap = old_r_node_i_to_p_node_i_map;
        new_proc.pNodeIToRNodeIMap = new OpenIntIntHashMap(new_r_node_i_to_p_node_i_map.size());
        new_proc.event = event;
        new_r_node_i_to_p_node_i_map.forEachPair(new_proc);
        int[] new_p_node_i_to_r_node_i_array = new int[new_proc.highestPerspectiveIndex + 1];
        for (int index_i = 1; index_i < new_p_node_i_to_r_node_i_array.length; ++index_i) {
            if (!new_proc.pNodeIToRNodeIMap.containsKey(index_i)) continue;
            int new_root_index = new_proc.pNodeIToRNodeIMap.get(index_i);
            if (new_root_index >= 0) {
                throw new IllegalArgumentException("The root indices in the rootNodeIndexToPerspectiveNodeIndexMap must be negative.");
            }
            new_p_node_i_to_r_node_i_array[index_i] = new_root_index;
        }
        this.perspectiveNodeIndexToRootNodeIndexArray = new_p_node_i_to_r_node_i_array;
        ObjectMatrix2D new_node_perspective = this.rootGraph.createColtNodeDataPerspective(this, new_r_node_i_to_p_node_i_map);
        this.setColtNodeDataPerspective(new_node_perspective);
        if (event != null) {
            if (old_proc.eventHiddenNodeIndices != null) {
                old_proc.eventHiddenNodeIndices.trimToSize();
                event.addHiddenNodeIndices(old_proc.eventHiddenNodeIndices.elements());
            }
            if (new_proc.eventRestoredNodeIndices != null) {
                new_proc.eventRestoredNodeIndices.trimToSize();
                event.addRestoredNodeIndices(new_proc.eventRestoredNodeIndices.elements());
            }
        }
        if (hide_all_incident_edges && old_proc.eventHiddenNodeIndices != null) {
            old_proc.eventHiddenNodeIndices.trimToSize();
            this.hideAllIncidentEdges(old_proc.eventHiddenNodeIndices.elements(), (int[][])null, event);
        }
        if (old_proc != null) {
            old_proc.reset();
        }
        new_proc.reset();
    }

    protected void setColtEdgeDataPerspective(ObjectMatrix2D matrix_view) {
        if (this.coltEdgeDataPerspective == matrix_view) {
            return;
        }
        if (ColtginyConstants.USE_ASSERTIONS && this.rootEdgeIndexToPerspectiveEdgeIndexMap == null) {
            throw new Error("Assertion failed: rootEdgeIndexToPerspectiveEdgeIndexMap must not be null when setColtEdgeDataPerspective is called.");
        }
        ObjectMatrix2D old_cdp = this.coltEdgeDataPerspective;
        this.coltEdgeDataPerspective = matrix_view;
        if (this.rootGraph != null && this.rootNodeIndexToPerspectiveNodeIndexMap != null && this.coltEdgeDataPerspective != null && this.coltNodeDataPerspective != null && !this.coltGraphPerspectiveInitialized) {
            this.initializeColtGraphPerspective();
        }
        this.coltEdgeDataPerspectiveChanged(old_cdp, this.coltEdgeDataPerspective);
    }

    protected void coltEdgeDataPerspectiveChanged(ObjectMatrix2D old_colt_edge_data_perspective, ObjectMatrix2D new_colt_edge_data_perspective) {
        this.edgeCount = this.coltEdgeDataPerspective.columns() - 1;
    }

    protected void setRootEdgeIndexToPerspectiveEdgeIndexMap(OpenIntIntHashMap r_edge_i_to_p_edge_i_map) {
        ChangeEvent event = null;
        if (this.coltGraphPerspectiveInitialized) {
            event = this.getChangeEvent();
        }
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(r_edge_i_to_p_edge_i_map, true, event);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
    }

    protected void setRootEdgeIndexToPerspectiveEdgeIndexMap(OpenIntIntHashMap r_edge_i_to_p_edge_i_map, boolean restore_all_incident_nodes, ChangeEvent event) {
        if (this.rootEdgeIndexToPerspectiveEdgeIndexMap == r_edge_i_to_p_edge_i_map || this.rootEdgeIndexToPerspectiveEdgeIndexMap != null && r_edge_i_to_p_edge_i_map != null && this.rootEdgeIndexToPerspectiveEdgeIndexMap.equals(r_edge_i_to_p_edge_i_map)) {
            return;
        }
        if (this.rootGraph == null) {
            throw new IllegalStateException("rootGraph must not be null when setRootEdgeIndexToPerspectiveEdgeIndexMap is called.");
        }
        if (r_edge_i_to_p_edge_i_map == null) {
            throw new IllegalArgumentException("You may not set rootEdgeIndexToPerspectiveEdgeIndexMap to null.");
        }
        OpenIntIntHashMap old_map = this.rootEdgeIndexToPerspectiveEdgeIndexMap;
        this.rootEdgeIndexToPerspectiveEdgeIndexMap = r_edge_i_to_p_edge_i_map;
        this.rootEdgeIndexToPerspectiveEdgeIndexMapChanged(old_map, this.rootEdgeIndexToPerspectiveEdgeIndexMap, restore_all_incident_nodes, event);
    }

    protected void rootEdgeIndexToPerspectiveEdgeIndexMapChanged(OpenIntIntHashMap old_r_edge_i_to_p_edge_i_map, OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map, boolean restore_all_incident_nodes, ChangeEvent event) {
        OldEdgeMapProcedure old_proc = null;
        if (event != null) {
            old_proc = this.getOldEdgeMapProcedure();
            old_proc.newREdgeIToPEdgeIMap = new_r_edge_i_to_p_edge_i_map;
            old_r_edge_i_to_p_edge_i_map.forEachPair(old_proc);
        }
        NewEdgeMapProcedure new_proc = this.getNewEdgeMapProcedure();
        new_proc.oldREdgeIToPEdgeIMap = old_r_edge_i_to_p_edge_i_map;
        new_proc.pEdgeIToREdgeIMap = new OpenIntIntHashMap(new_r_edge_i_to_p_edge_i_map.size());
        new_proc.event = event;
        new_proc.restoreAllIncidentNodes = restore_all_incident_nodes;
        new_r_edge_i_to_p_edge_i_map.forEachPair(new_proc);
        int[] new_p_edge_i_to_r_edge_i_array = new int[new_proc.highestPerspectiveIndex + 1];
        for (int index_i = 1; index_i < new_p_edge_i_to_r_edge_i_array.length; ++index_i) {
            if (!new_proc.pEdgeIToREdgeIMap.containsKey(index_i)) continue;
            int new_root_index = new_proc.pEdgeIToREdgeIMap.get(index_i);
            if (new_root_index >= 0) {
                throw new IllegalArgumentException("The root indices in the rootEdgeIndexToPerspectiveEdgeIndexMap must be negative.");
            }
            new_p_edge_i_to_r_edge_i_array[index_i] = new_root_index;
        }
        this.perspectiveEdgeIndexToRootEdgeIndexArray = new_p_edge_i_to_r_edge_i_array;
        ObjectMatrix2D new_edge_perspective = this.rootGraph.createColtEdgeDataPerspective(this, this.rootNodeIndexToPerspectiveNodeIndexMap, new_r_edge_i_to_p_edge_i_map);
        this.setColtEdgeDataPerspective(new_edge_perspective);
        if (event != null) {
            if (old_proc.eventHiddenEdgeIndices != null) {
                old_proc.eventHiddenEdgeIndices.trimToSize();
                event.addHiddenEdgeIndices(old_proc.eventHiddenEdgeIndices.elements());
            }
            if (new_proc.eventRestoredEdgeIndices != null) {
                new_proc.eventRestoredEdgeIndices.trimToSize();
                event.addRestoredEdgeIndices(new_proc.eventRestoredEdgeIndices.elements());
            }
        }
        if (restore_all_incident_nodes && new_proc.eventRestoredEdgeIndices != null) {
            new_proc.eventRestoredEdgeIndices.trimToSize();
            this.restoreAllIncidentNodes(new_proc.eventRestoredEdgeIndices.elements(), (int[][])null, event);
        }
        if (old_proc != null) {
            old_proc.reset();
        }
        new_proc.reset();
    }

    public Object clone() {
        return new ColtGraphPerspective(this.rootGraph, (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy(), (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy());
    }

    public RootGraph getRootGraph() {
        return this.rootGraph;
    }

    public int getNodeCount() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.nodeCount;
    }

    public int getEdgeCount() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeCount;
    }

    public Iterator nodesIterator() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return new Iterator(){
            int nextNode = 1;

            public boolean hasNext() {
                return this.nextNode <= ColtGraphPerspective.this.nodeCount;
            }

            public Object next() {
                if (this.nextNode > ColtGraphPerspective.this.nodeCount) {
                    throw new NoSuchElementException();
                }
                return (Node)ColtGraphPerspective.this.coltNodeDataPerspective.getQuick(0, this.nextNode++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List nodesList() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        ArrayList<Node> list = new ArrayList<Node>(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            list.add(this.rootGraph.getNode(this.getRootGraphNodeIndex(node_i)));
        }
        return list;
    }

    public int[] getNodeIndicesArray() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        int[] new_indices = new int[this.perspectiveNodeIndexToRootNodeIndexArray.length - 1];
        System.arraycopy(this.perspectiveNodeIndexToRootNodeIndexArray, 1, new_indices, 0, new_indices.length);
        return new_indices;
    }

    public Iterator edgesIterator() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return new Iterator(){
            int nextEdge = 1;

            public boolean hasNext() {
                return this.nextEdge <= ColtGraphPerspective.this.edgeCount;
            }

            public Object next() {
                Edge edge;
                if (this.nextEdge > ColtGraphPerspective.this.edgeCount) {
                    throw new NoSuchElementException();
                }
                if ((edge = (Edge)((Object[])ColtGraphPerspective.this.coltEdgeDataPerspective.getQuick(0, this.nextEdge++))[0]) == null) {
                    edge = ColtGraphPerspective.this.rootGraph.createEdge(ColtGraphPerspective.this.perspectiveEdgeIndexToRootEdgeIndexArray[this.nextEdge - 1]);
                    ((Object[])ColtGraphPerspective.this.coltEdgeDataPerspective.getQuick((int)0, (int)(this.nextEdge - 1)))[0] = edge;
                }
                return edge;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List edgesList() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        ArrayList<Edge> list = new ArrayList<Edge>(this.edgeCount);
        for (int edge_i = 1; edge_i <= this.edgeCount; ++edge_i) {
            Edge edge = (Edge)((Object[])this.coltEdgeDataPerspective.getQuick(0, edge_i))[0];
            if (edge == null) {
                edge = this.rootGraph.createEdge(this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_i]);
                ((Object[])this.coltEdgeDataPerspective.getQuick((int)0, (int)edge_i))[0] = edge;
            }
            list.add(edge);
        }
        return list;
    }

    public int[] getEdgeIndicesArray() {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        int[] new_indices = new int[this.perspectiveEdgeIndexToRootEdgeIndexArray.length - 1];
        System.arraycopy(this.perspectiveEdgeIndexToRootEdgeIndexArray, 1, new_indices, 0, new_indices.length);
        return new_indices;
    }

    public Node hideNode(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            return null;
        }
        if (node.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given node is not in the RootGraph.");
        }
        int node_root_index = this.rootGraph.getIndex(node);
        if (!this.rootNodeIndexToPerspectiveNodeIndexMap.containsKey(node_root_index)) {
            return null;
        }
        ChangeEvent event = this.getChangeEvent();
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        new_r_node_i_to_p_node_i_map.removeKey(node_root_index);
        this.hideAllIncidentEdges(new Node[]{node}, (Edge[][])null, event);
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        if (event != null) {
            event.addHiddenNode(node);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return node;
    }

    public int hideNode(int node_index) {
        int node_perspective_index;
        int node_root_index;
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return 0;
        }
        if (node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given value, " + node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (node_index < 0) {
            node_root_index = node_index;
            node_perspective_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_root_index);
        } else {
            node_root_index = this.perspectiveNodeIndexToRootNodeIndexArray[node_index];
            node_perspective_index = node_index;
        }
        if (node_perspective_index == 0) {
            return 0;
        }
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addHiddenNodeIndex(node_root_index);
        }
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        new_r_node_i_to_p_node_i_map.removeKey(node_root_index);
        this.hideAllIncidentEdges(new int[]{node_perspective_index}, (int[][])null, event);
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return node_index;
    }

    public List hideNodes(List nodes) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (nodes == null || nodes.isEmpty()) {
            return nodes == null ? new ArrayList() : nodes;
        }
        Iterator nodes_iterator = nodes.iterator();
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        ArrayList<Node> nodes_hidden = new ArrayList<Node>(nodes.size());
        while (nodes_iterator.hasNext()) {
            Node node = (Node)nodes_iterator.next();
            if (node.getRootGraph() != this.rootGraph) {
                throw new IllegalArgumentException("One of the Nodes in the given List is not in the RootGraph.");
            }
            int node_root_index = this.rootGraph.getIndex(node);
            if (!this.rootNodeIndexToPerspectiveNodeIndexMap.containsKey(node_root_index)) continue;
            nodes_hidden.add(node);
            new_r_node_i_to_p_node_i_map.removeKey(node_root_index);
        }
        if (nodes_hidden.isEmpty()) {
            return nodes_hidden;
        }
        ChangeEvent event = this.getChangeEvent();
        Node[] nodes_hidden_array = nodes_hidden.toArray(new Node[0]);
        this.hideAllIncidentEdges(nodes_hidden_array, (Edge[][])null, event);
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        if (event != null) {
            event.addHiddenNodes(nodes_hidden_array);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return nodes_hidden;
    }

    public int[] hideNodes(int[] node_indices) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_indices == null || node_indices.length == 0) {
            return node_indices;
        }
        int[] result_indices = new int[node_indices.length];
        IntArrayList node_indices_hidden = new IntArrayList(node_indices.length);
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        for (int index_i = 0; index_i < node_indices.length; ++index_i) {
            int node_perspective_index;
            int node_root_index;
            int node_index = node_indices[index_i];
            result_indices[index_i] = 0;
            if (node_index == 0) continue;
            if (node_index > this.nodeCount) {
                throw new IllegalArgumentException("One of the given node indices, " + node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
            }
            if (node_index < 0) {
                node_root_index = node_index;
                node_perspective_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_root_index);
            } else {
                node_root_index = this.perspectiveNodeIndexToRootNodeIndexArray[node_index];
                node_perspective_index = node_index;
            }
            if (node_perspective_index == 0) continue;
            result_indices[index_i] = node_index;
            node_indices_hidden.add(node_root_index);
            new_r_node_i_to_p_node_i_map.removeKey(node_root_index);
        }
        if (node_indices_hidden.isEmpty()) {
            return result_indices;
        }
        ChangeEvent event = this.getChangeEvent();
        node_indices_hidden.trimToSize();
        int[] node_indices_hidden_array = node_indices_hidden.elements();
        if (event != null) {
            event.addHiddenNodeIndices(node_indices_hidden_array);
        }
        this.hideAllIncidentEdges(node_indices_hidden_array, (int[][])null, event);
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return result_indices;
    }

    public Node restoreNode(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            return null;
        }
        if (node.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given node is not in the RootGraph.");
        }
        int node_root_index = this.rootGraph.getIndex(node);
        if (this.rootNodeIndexToPerspectiveNodeIndexMap.containsKey(node_root_index)) {
            return null;
        }
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        new_r_node_i_to_p_node_i_map.put(node_root_index, this.nodeCount);
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addRestoredNode(node);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return node;
    }

    public int restoreNode(int node_index) {
        int node_perspective_index;
        int node_root_index;
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index == 0) {
            return 0;
        }
        if (node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given value, " + node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (node_index < 0) {
            node_root_index = node_index;
            node_perspective_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_root_index);
        } else {
            node_root_index = this.perspectiveNodeIndexToRootNodeIndexArray[node_index];
            node_perspective_index = node_index;
        }
        if (node_perspective_index != 0) {
            return 0;
        }
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        new_r_node_i_to_p_node_i_map.put(node_root_index, this.nodeCount);
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addRestoredNodeIndex(node_root_index);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return node_index;
    }

    public List restoreNodes(List nodes) {
        return this.restoreNodes(nodes, false);
    }

    public List restoreNodes(List nodes, boolean restore_incident_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (nodes == null || nodes.isEmpty()) {
            return nodes == null ? new ArrayList() : nodes;
        }
        Iterator nodes_iterator = nodes.iterator();
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        ArrayList<Node> nodes_restored = new ArrayList<Node>(nodes.size());
        ArrayList<Integer> indices_restored = new ArrayList<Integer>(nodes.size());
        while (nodes_iterator.hasNext()) {
            Node node = (Node)nodes_iterator.next();
            if (node.getRootGraph() != this.rootGraph) {
                throw new IllegalArgumentException("One of the Nodes in the given List is not in the RootGraph.");
            }
            int node_root_index = this.rootGraph.getIndex(node);
            if (this.rootNodeIndexToPerspectiveNodeIndexMap.containsKey(node_root_index)) continue;
            nodes_restored.add(node);
            indices_restored.add(new Integer(node_root_index));
            new_r_node_i_to_p_node_i_map.put(node_root_index, this.nodeCount);
        }
        if (nodes_restored.isEmpty()) {
            return nodes_restored;
        }
        ChangeEvent event = this.getChangeEvent();
        Node[] nodes_restored_array = nodes_restored.toArray(new Node[0]);
        if (event != null) {
            event.addRestoredNodes(nodes_restored_array);
        }
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        if (restore_incident_edges) {
            int[] indices_array = new int[indices_restored.size()];
            for (int i = 0; i < indices_restored.size(); ++i) {
                indices_array[i] = (Integer)indices_restored.get(i);
            }
            this.restoreAllIncidentEdges(indices_array, null, event);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return nodes_restored;
    }

    public int[] restoreNodes(int[] node_indices) {
        return this.restoreNodes(node_indices, false);
    }

    public int[] restoreNodes(int[] node_indices, boolean restore_incident_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_indices == null || node_indices.length == 0) {
            return node_indices;
        }
        int[] result_indices = new int[node_indices.length];
        IntArrayList node_indices_restored = new IntArrayList(node_indices.length);
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        for (int index_i = 0; index_i < node_indices.length; ++index_i) {
            int node_perspective_index;
            int node_root_index;
            int node_index = node_indices[index_i];
            result_indices[index_i] = 0;
            if (node_index == 0) continue;
            if (node_index > this.nodeCount) {
                throw new IllegalArgumentException("One of the given node indices, " + node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
            }
            if (node_index < 0) {
                node_root_index = node_index;
                node_perspective_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_root_index);
            } else {
                node_root_index = this.perspectiveNodeIndexToRootNodeIndexArray[node_index];
                node_perspective_index = node_index;
            }
            if (node_perspective_index != 0) continue;
            result_indices[index_i] = node_index;
            node_indices_restored.add(node_root_index);
            new_r_node_i_to_p_node_i_map.put(node_root_index, this.nodeCount);
        }
        if (node_indices_restored.isEmpty()) {
            return result_indices;
        }
        ChangeEvent event = this.getChangeEvent();
        node_indices_restored.trimToSize();
        int[] node_indices_restored_array = node_indices_restored.elements();
        if (event != null) {
            event.addRestoredNodeIndices(node_indices_restored_array);
        }
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, null);
        if (restore_incident_edges) {
            this.restoreAllIncidentEdges(node_indices_restored_array, null, event);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return result_indices;
    }

    public Edge hideEdge(Edge edge) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            return null;
        }
        if (edge.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given edge is not in the RootGraph.");
        }
        int edge_root_index = this.rootGraph.getIndex(edge);
        if (!this.rootEdgeIndexToPerspectiveEdgeIndexMap.containsKey(edge_root_index)) {
            return null;
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        new_r_edge_i_to_p_edge_i_map.removeKey(edge_root_index);
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addHiddenEdge(edge);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return edge;
    }

    public int hideEdge(int edge_index) {
        int edge_perspective_index;
        int edge_root_index;
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0) {
            return 0;
        }
        if (edge_index > this.edgeCount) {
            throw new IllegalArgumentException("The given value, " + edge_index + ", cannot be the index of a Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
        }
        if (edge_index < 0) {
            edge_root_index = edge_index;
            edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_root_index);
        } else {
            edge_root_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_index];
            edge_perspective_index = edge_index;
        }
        if (edge_perspective_index == 0) {
            return 0;
        }
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addHiddenEdgeIndex(edge_root_index);
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        new_r_edge_i_to_p_edge_i_map.removeKey(edge_root_index);
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return edge_index;
    }

    public List hideEdges(List edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edges == null || edges.isEmpty()) {
            return edges == null ? new ArrayList() : edges;
        }
        Iterator edges_iterator = edges.iterator();
        ArrayList<Edge> edges_hidden = new ArrayList<Edge>(edges.size());
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        while (edges_iterator.hasNext()) {
            Edge edge = (Edge)edges_iterator.next();
            if (edge.getRootGraph() != this.rootGraph) {
                throw new IllegalArgumentException("One of the Edges in the given List is not in the RootGraph.");
            }
            int edge_root_index = this.rootGraph.getIndex(edge);
            if (!this.rootEdgeIndexToPerspectiveEdgeIndexMap.containsKey(edge_root_index)) continue;
            edges_hidden.add(edge);
            new_r_edge_i_to_p_edge_i_map.removeKey(edge_root_index);
        }
        if (edges_hidden.isEmpty()) {
            return edges_hidden;
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            Edge[] edges_hidden_array = edges_hidden.toArray(new Edge[0]);
            event.addHiddenEdges(edges_hidden_array);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return edges_hidden;
    }

    public int[] hideEdges(int[] edge_indices) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_indices == null || edge_indices.length == 0) {
            return edge_indices;
        }
        int[] result_indices = new int[edge_indices.length];
        IntArrayList edge_indices_hidden = new IntArrayList(edge_indices.length);
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        for (int index_i = 0; index_i < edge_indices.length; ++index_i) {
            int edge_perspective_index;
            int edge_root_index;
            int edge_index = edge_indices[index_i];
            result_indices[index_i] = 0;
            if (edge_index == 0) continue;
            if (edge_index > this.edgeCount) {
                throw new IllegalArgumentException("One of the given edge indices, " + edge_index + ", cannot be the index of a Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
            }
            if (edge_index < 0) {
                edge_root_index = edge_index;
                edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_root_index);
            } else {
                edge_root_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_index];
                edge_perspective_index = edge_index;
            }
            if (edge_perspective_index == 0) continue;
            result_indices[index_i] = edge_index;
            edge_indices_hidden.add(edge_root_index);
            new_r_edge_i_to_p_edge_i_map.removeKey(edge_root_index);
        }
        if (edge_indices_hidden.isEmpty()) {
            return result_indices;
        }
        ChangeEvent event = this.getChangeEvent();
        edge_indices_hidden.trimToSize();
        int[] edge_indices_hidden_array = edge_indices_hidden.elements();
        if (event != null) {
            event.addHiddenEdgeIndices(edge_indices_hidden_array);
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return result_indices;
    }

    public Edge restoreEdge(Edge edge) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            return null;
        }
        if (edge.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given edge is not in the RootGraph.");
        }
        int edge_root_index = this.rootGraph.getIndex(edge);
        if (this.rootEdgeIndexToPerspectiveEdgeIndexMap.containsKey(edge_root_index)) {
            return null;
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        new_r_edge_i_to_p_edge_i_map.put(edge_root_index, this.edgeCount);
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addRestoredEdge(edge);
        }
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return edge;
    }

    public int restoreEdge(int edge_index) {
        int edge_perspective_index;
        int edge_root_index;
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index == 0) {
            return 0;
        }
        if (edge_index > this.edgeCount) {
            throw new IllegalArgumentException("The given value, " + edge_index + ", cannot be the index of a Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
        }
        if (edge_index < 0) {
            edge_root_index = edge_index;
            edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_root_index);
        } else {
            edge_root_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_index];
            edge_perspective_index = edge_index;
        }
        if (edge_perspective_index != 0) {
            return 0;
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        new_r_edge_i_to_p_edge_i_map.put(edge_root_index, this.edgeCount);
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        if (event != null) {
            event.addRestoredEdgeIndex(edge_root_index);
        }
        this.restoreAllIncidentNodes(new int[]{edge_root_index}, (int[][])null, event);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return edge_index;
    }

    public List restoreEdges(List edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edges == null || edges.isEmpty()) {
            return edges == null ? new ArrayList() : edges;
        }
        Iterator edges_iterator = edges.iterator();
        ArrayList<Edge> edges_restored = new ArrayList<Edge>(edges.size());
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        while (edges_iterator.hasNext()) {
            Edge edge = (Edge)edges_iterator.next();
            if (edge.getRootGraph() != this.rootGraph) {
                throw new IllegalArgumentException("One of the Edges in the given List is not in the RootGraph.");
            }
            int edge_root_index = this.rootGraph.getIndex(edge);
            if (this.rootEdgeIndexToPerspectiveEdgeIndexMap.containsKey(edge_root_index)) continue;
            edges_restored.add(edge);
            new_r_edge_i_to_p_edge_i_map.put(edge_root_index, this.edgeCount);
        }
        if (edges_restored.isEmpty()) {
            return edges_restored;
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        Edge[] edges_restored_array = edges_restored.toArray(new Edge[0]);
        if (event != null) {
            event.addRestoredEdges(edges_restored_array);
        }
        this.restoreAllIncidentNodes(edges_restored_array, (Node[][])null, event);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return edges_restored;
    }

    public int[] restoreEdges(int[] edge_indices) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_indices == null || edge_indices.length == 0) {
            return edge_indices;
        }
        int[] result_indices = new int[edge_indices.length];
        IntArrayList edge_indices_restored = new IntArrayList(edge_indices.length);
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        for (int index_i = 0; index_i < edge_indices.length; ++index_i) {
            int edge_perspective_index;
            int edge_root_index;
            int edge_index = edge_indices[index_i];
            result_indices[index_i] = 0;
            if (edge_index == 0) continue;
            if (edge_index > this.edgeCount) {
                throw new IllegalArgumentException("One of the given edge indices, " + edge_index + ", cannot be the index of a Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
            }
            if (edge_index < 0) {
                edge_root_index = edge_index;
                edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_root_index);
            } else {
                edge_root_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_index];
                edge_perspective_index = edge_index;
            }
            if (edge_perspective_index != 0) continue;
            result_indices[index_i] = edge_index;
            edge_indices_restored.add(edge_root_index);
            new_r_edge_i_to_p_edge_i_map.put(edge_root_index, this.edgeCount);
        }
        if (edge_indices_restored.isEmpty()) {
            return result_indices;
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, null);
        ChangeEvent event = this.getChangeEvent();
        edge_indices_restored.trimToSize();
        int[] edge_indices_restored_array = edge_indices_restored.elements();
        if (event != null) {
            event.addRestoredEdgeIndices(edge_indices_restored_array);
        }
        this.restoreAllIncidentNodes(edge_indices_restored_array, (int[][])null, event);
        if (event != null) {
            this.fireGraphPerspectiveChanged(event);
        }
        return result_indices;
    }

    protected void hideAllIncidentEdges(Node[] nodes, Edge[][] edge_exceptions, ChangeEvent event) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (nodes == null || nodes.length == 0) {
            return;
        }
        if (edge_exceptions == null || edge_exceptions.length == 0) {
            edge_exceptions = new Edge[nodes.length][];
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        for (int node_i = 0; node_i < nodes.length; ++node_i) {
            int edge_exception_i;
            int edge_i;
            int[] edge_indices;
            Node node = nodes[node_i];
            int node_index = this.getIndex(node);
            if (node_index == 0) {
                throw new IllegalArgumentException("One of the given Nodes, " + node + ", at index " + node_i + " into the given Nodes array, and at index " + this.rootGraph.getIndex(node) + " in rootGraph, is not in this GraphPerspective.");
            }
            for (int to_node_index = 1; to_node_index <= this.nodeCount; ++to_node_index) {
                edge_indices = (int[])this.coltNodeDataPerspective.getQuick(node_index, to_node_index);
                if (edge_indices == null || edge_indices.length <= 1) continue;
                block2: for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_exceptions[node_i] != null) {
                        for (edge_exception_i = 0; edge_exception_i < edge_exceptions[node_i].length; ++edge_exception_i) {
                            if (this.rootGraph.getIndex(edge_exceptions[node_i][edge_exception_i]) != edge_indices[edge_i]) continue;
                            new_r_edge_i_to_p_edge_i_map.put(edge_indices[edge_i], this.edgeCount);
                            continue block2;
                        }
                    }
                    new_r_edge_i_to_p_edge_i_map.removeKey(edge_indices[edge_i]);
                }
            }
            for (int from_node_index = 1; from_node_index <= this.nodeCount; ++from_node_index) {
                if (from_node_index == node_index || (edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, node_index)) == null || edge_indices.length <= 1) continue;
                block5: for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_exceptions[node_i] != null) {
                        for (edge_exception_i = 0; edge_exception_i < edge_exceptions[node_i].length; ++edge_exception_i) {
                            if (this.rootGraph.getIndex(edge_exceptions[node_i][edge_exception_i]) != edge_indices[edge_i]) continue;
                            new_r_edge_i_to_p_edge_i_map.put(edge_indices[edge_i], this.edgeCount);
                            continue block5;
                        }
                    }
                    new_r_edge_i_to_p_edge_i_map.removeKey(edge_indices[edge_i]);
                }
            }
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, event);
    }

    protected void restoreAllIncidentEdges(int[] node_indices, Edge[][] edge_exceptions, ChangeEvent event) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_indices == null || node_indices.length == 0) {
            return;
        }
        if (edge_exceptions == null || edge_exceptions.length == 0) {
            edge_exceptions = new Edge[node_indices.length][];
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        for (int node_i = 0; node_i < node_indices.length; ++node_i) {
            int edge_exception_i;
            int edge_i;
            int[] edge_indices;
            int node_index = 0;
            if (node_indices[node_i] < 0) {
                node_index = this.getNodeIndex(node_indices[node_i]);
            } else if (node_indices[node_i] > 0) {
                node_index = node_indices[node_i];
            }
            if (node_index == 0) {
                throw new IllegalArgumentException("One of the given node indices, " + node_index + ", at index " + node_i + " into the given Nodes indices array" + " is not in this GraphPerspective.");
            }
            for (int to_node_index = 1; to_node_index <= this.nodeCount; ++to_node_index) {
                edge_indices = (int[])this.coltNodeDataPerspective.getQuick(node_index, to_node_index);
                if (edge_indices == null || edge_indices.length <= 1) continue;
                block2: for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_exceptions[node_i] != null) {
                        for (edge_exception_i = 0; edge_exception_i < edge_exceptions[node_i].length; ++edge_exception_i) {
                            if (this.rootGraph.getIndex(edge_exceptions[node_i][edge_exception_i]) != edge_indices[edge_i]) continue;
                            new_r_edge_i_to_p_edge_i_map.removeKey(edge_indices[edge_i]);
                            continue block2;
                        }
                    }
                    new_r_edge_i_to_p_edge_i_map.put(edge_indices[edge_i], this.edgeCount);
                }
            }
            for (int from_node_index = 1; from_node_index <= this.nodeCount; ++from_node_index) {
                if (from_node_index == node_index || (edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, node_index)) == null || edge_indices.length <= 1) continue;
                block5: for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_exceptions[node_i] != null) {
                        for (edge_exception_i = 0; edge_exception_i < edge_exceptions[node_i].length; ++edge_exception_i) {
                            if (this.rootGraph.getIndex(edge_exceptions[node_i][edge_exception_i]) != edge_indices[edge_i]) continue;
                            new_r_edge_i_to_p_edge_i_map.removeKey(edge_indices[edge_i]);
                            continue block5;
                        }
                    }
                    new_r_edge_i_to_p_edge_i_map.put(edge_indices[edge_i], this.edgeCount);
                }
            }
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, event);
    }

    protected void hideAllIncidentEdges(int[] node_indices, int[][] edge_index_exceptions, ChangeEvent event) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_indices == null || node_indices.length == 0) {
            return;
        }
        if (edge_index_exceptions == null || ((int[][])edge_index_exceptions).length == 0) {
            edge_index_exceptions = new int[node_indices.length][];
        }
        OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
        for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
            int edge_exception_index;
            int edge_exception_i;
            int edge_i;
            int[] edge_indices;
            int node_perspective_index;
            int node_index = node_indices[node_index_i];
            if (node_index > this.nodeCount) {
                throw new IllegalArgumentException("One of the given node indices, " + node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
            }
            if (node_index < 0) {
                node_perspective_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
                if (node_perspective_index == 0) {
                    continue;
                }
            } else {
                node_perspective_index = node_index;
            }
            for (int to_node_index = 1; to_node_index <= this.nodeCount; ++to_node_index) {
                edge_indices = (int[])this.coltNodeDataPerspective.getQuick(node_perspective_index, to_node_index);
                if (edge_indices == null || edge_indices.length <= 1) continue;
                block2: for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_index_exceptions[node_index_i] != null) {
                        for (edge_exception_i = 0; edge_exception_i < edge_index_exceptions[node_index_i].length; ++edge_exception_i) {
                            edge_exception_index = edge_index_exceptions[node_index_i][edge_exception_i];
                            if (edge_exception_index == 0) continue;
                            if (edge_exception_index > this.edgeCount) {
                                throw new IllegalArgumentException("One of the given edge exception indices, " + edge_exception_index + ", cannot be the index of an Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
                            }
                            if (edge_exception_index > 0) {
                                edge_exception_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_exception_index];
                            }
                            if (edge_exception_index != edge_indices[edge_i]) continue;
                            new_r_edge_i_to_p_edge_i_map.put(edge_indices[edge_i], this.edgeCount);
                            continue block2;
                        }
                    }
                    new_r_edge_i_to_p_edge_i_map.removeKey(edge_indices[edge_i]);
                }
            }
            for (int from_node_index = 1; from_node_index <= this.nodeCount; ++from_node_index) {
                if (from_node_index == node_perspective_index || (edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, node_perspective_index)) == null || edge_indices.length <= 1) continue;
                block5: for (edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
                    if (edge_index_exceptions[node_index_i] != null) {
                        for (edge_exception_i = 0; edge_exception_i < edge_index_exceptions[node_index_i].length; ++edge_exception_i) {
                            edge_exception_index = edge_index_exceptions[node_index_i][edge_exception_i];
                            if (edge_exception_index == 0) continue;
                            if (edge_exception_index > this.edgeCount) {
                                throw new IllegalArgumentException("One of the given edge exception indices, " + edge_exception_index + ", cannot be the index of an Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
                            }
                            if (edge_exception_index > 0) {
                                edge_exception_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_exception_index];
                            }
                            if (edge_exception_index != edge_indices[edge_i]) continue;
                            new_r_edge_i_to_p_edge_i_map.put(edge_indices[edge_i], this.edgeCount);
                            continue block5;
                        }
                    }
                    new_r_edge_i_to_p_edge_i_map.removeKey(edge_indices[edge_i]);
                }
            }
        }
        this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
        this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, event);
    }

    protected void restoreAllIncidentNodes(Edge[] edges, Node[][] node_exceptions, ChangeEvent event) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edges == null || edges.length == 0) {
            return;
        }
        if (node_exceptions == null || node_exceptions.length == 0) {
            node_exceptions = new Node[edges.length][];
        }
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
            int node_exception_i;
            Edge edge = edges[edge_i];
            int edge_index = this.getIndex(edge);
            if (edge_index == 0) {
                throw new IllegalArgumentException("One of the given Edges, " + edge + ", at index " + edge_i + " into the given Edges array, and at index " + this.rootGraph.getIndex(edge) + " in rootGraph, is not in this GraphPerspective.");
            }
            Node source_node = edge.getSource();
            int source_node_root_index = this.rootGraph.getIndex(source_node);
            boolean source_node_is_an_exception = false;
            if (node_exceptions[edge_i] != null) {
                for (node_exception_i = 0; node_exception_i < node_exceptions[edge_i].length; ++node_exception_i) {
                    if (this.rootGraph.getIndex(node_exceptions[edge_i][node_exception_i]) != source_node_root_index) continue;
                    new_r_node_i_to_p_node_i_map.put(source_node_root_index, this.nodeCount);
                    source_node_is_an_exception = true;
                    break;
                }
            }
            if (!source_node_is_an_exception) {
                new_r_node_i_to_p_node_i_map.put(source_node_root_index, this.nodeCount);
            }
            Node target_node = edge.getTarget();
            int target_node_root_index = this.rootGraph.getIndex(target_node);
            boolean target_node_is_an_exception = false;
            if (node_exceptions[edge_i] != null) {
                for (node_exception_i = 0; node_exception_i < node_exceptions[edge_i].length; ++node_exception_i) {
                    if (this.rootGraph.getIndex(node_exceptions[edge_i][node_exception_i]) != target_node_root_index) continue;
                    new_r_node_i_to_p_node_i_map.put(target_node_root_index, this.nodeCount);
                    target_node_is_an_exception = true;
                    break;
                }
            }
            if (target_node_is_an_exception) continue;
            new_r_node_i_to_p_node_i_map.put(target_node_root_index, this.nodeCount);
        }
        this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
        this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, event);
    }

    protected void restoreAllIncidentNodes(int[] edge_indices, int[][] node_exceptions, ChangeEvent event) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_indices == null || edge_indices.length == 0) {
            return;
        }
        if (node_exceptions == null || ((int[][])node_exceptions).length == 0) {
            node_exceptions = new int[edge_indices.length][];
        }
        int num_restored_nodes = 0;
        OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
        for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
            int target_node_root_index;
            int node_exception_index;
            int node_exception_i;
            int source_node_root_index;
            int gpNodeIndex;
            int edge_perspective_index;
            int edge_root_index;
            int edge_index = edge_indices[edge_index_i];
            if (edge_index == 0) continue;
            if (edge_index > this.edgeCount) {
                throw new IllegalArgumentException("One of the given edge indices, " + edge_index + ", cannot be the index of a Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
            }
            if (edge_index < 0) {
                edge_root_index = edge_index;
                edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_root_index);
                if (edge_perspective_index == 0) {
                    throw new IllegalArgumentException("One of the given edge indices, " + edge_index + ", is not the index of an Edge in this GraphPerspective, or of an Edge in the RootGraph that is shown in this perspective.");
                }
            } else {
                edge_root_index = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_index];
                edge_perspective_index = edge_index;
            }
            boolean source_node_is_an_exception = (gpNodeIndex = this.rootNodeIndexToPerspectiveNodeIndexMap.get(source_node_root_index = ((int[])((Object[])this.coltEdgeDataPerspective.getQuick(0, edge_perspective_index))[1])[0])) != 0;
            if (node_exceptions[edge_index_i] != null && !source_node_is_an_exception) {
                for (node_exception_i = 0; node_exception_i < node_exceptions[edge_index_i].length; ++node_exception_i) {
                    node_exception_index = node_exceptions[edge_index_i][node_exception_i];
                    if (node_exception_index == 0) continue;
                    if (node_exception_index > this.nodeCount) {
                        throw new IllegalArgumentException("One of the given node exception indices, " + node_exception_index + ", cannot be the index of an Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
                    }
                    if (node_exception_index > 0) {
                        node_exception_index = this.perspectiveNodeIndexToRootNodeIndexArray[node_exception_index];
                    }
                    if (node_exception_index != source_node_root_index) continue;
                    if (new_r_node_i_to_p_node_i_map.containsKey(source_node_root_index)) {
                        new_r_node_i_to_p_node_i_map.removeKey(source_node_root_index);
                    }
                    source_node_is_an_exception = true;
                    break;
                }
            }
            if (!source_node_is_an_exception) {
                ++num_restored_nodes;
                new_r_node_i_to_p_node_i_map.put(source_node_root_index, this.nodeCount);
            }
            boolean target_node_is_an_exception = (gpNodeIndex = this.rootNodeIndexToPerspectiveNodeIndexMap.get(target_node_root_index = ((int[])((Object[])this.coltEdgeDataPerspective.getQuick(0, edge_perspective_index))[1])[1])) != 0;
            if (node_exceptions[edge_index_i] != null && !target_node_is_an_exception) {
                for (node_exception_i = 0; node_exception_i < node_exceptions[edge_index_i].length; ++node_exception_i) {
                    node_exception_index = node_exceptions[edge_index_i][node_exception_i];
                    if (node_exception_index == 0) continue;
                    if (node_exception_index > this.nodeCount) {
                        throw new IllegalArgumentException("One of the given node exception indices, " + node_exception_index + ", cannot be the index of an Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
                    }
                    if (node_exception_index > 0) {
                        node_exception_index = this.perspectiveNodeIndexToRootNodeIndexArray[node_exception_index];
                    }
                    if (node_exception_index != target_node_root_index) continue;
                    new_r_node_i_to_p_node_i_map.removeKey(target_node_root_index);
                    target_node_is_an_exception = true;
                    break;
                }
            }
            if (target_node_is_an_exception) continue;
            ++num_restored_nodes;
            new_r_node_i_to_p_node_i_map.put(target_node_root_index, this.nodeCount);
        }
        if (num_restored_nodes > 0) {
            this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
            this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, event);
        }
    }

    public boolean containsNode(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.containsNode(node, false);
    }

    public boolean containsNode(Node node, boolean recurse) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node.getRootGraph() != this.rootGraph) {
            return false;
        }
        if (this.getIndex(node) != 0) {
            return true;
        }
        if (recurse) {
            throw new Error("Sorry but I never got around to implementing the recursive contains.. test!");
        }
        return false;
    }

    public boolean containsEdge(Edge edge) {
        return this.containsEdge(edge, false);
    }

    public boolean containsEdge(Edge edge, boolean recurse) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge.getRootGraph() != this.rootGraph) {
            return false;
        }
        if (this.getIndex(edge) > 0) {
            return true;
        }
        if (recurse) {
            throw new Error("Sorry but I never got around to implementing the recursive contains.. test!");
        }
        return false;
    }

    public GraphPerspective join(GraphPerspective peer) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (peer == null) {
            throw new IllegalArgumentException("The GraphPerspective argument must not be null.");
        }
        if (peer.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given GraphPerspective is not a perspective on the same RootGraph as this GraphPerspective, so cannot be joined.");
        }
        ColtGraphPerspective new_graph_perspective = (ColtGraphPerspective)this.clone();
        new_graph_perspective.restoreNodes(peer.nodesList());
        new_graph_perspective.restoreEdges(peer.edgesList());
        return new_graph_perspective;
    }

    public GraphPerspective createGraphPerspective(Node[] nodes, Edge[] edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.rootGraph.createGraphPerspective(nodes, edges);
    }

    public GraphPerspective createGraphPerspective(int[] node_indices, int[] edge_indices) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        int[] root_graph_node_indices = new int[node_indices.length];
        for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
            if (node_indices[node_index_i] < 0) {
                root_graph_node_indices[node_index_i] = node_indices[node_index_i];
                continue;
            }
            if (node_indices[node_index_i] > 0 && node_indices[node_index_i] <= this.nodeCount) {
                root_graph_node_indices[node_index_i] = this.perspectiveNodeIndexToRootNodeIndexArray[node_indices[node_index_i]];
                continue;
            }
            throw new IllegalArgumentException("The given node indices must be valid in either the RootGraph or in this GraphPerspective.  The node index " + node_indices[node_index_i] + " is not valid.");
        }
        int[] root_graph_edge_indices = new int[edge_indices.length];
        for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
            if (edge_indices[edge_index_i] < 0) {
                root_graph_edge_indices[edge_index_i] = edge_indices[edge_index_i];
                continue;
            }
            if (edge_indices[edge_index_i] > 0 && edge_indices[edge_index_i] <= this.edgeCount) {
                root_graph_edge_indices[edge_index_i] = this.perspectiveEdgeIndexToRootEdgeIndexArray[edge_indices[edge_index_i]];
                continue;
            }
            throw new IllegalArgumentException("The given edge indices must be valid in either the RootGraph or in this GraphPerspective.  The edge index " + edge_indices[edge_index_i] + " is not valid.");
        }
        return this.rootGraph.createGraphPerspective(root_graph_node_indices, root_graph_edge_indices);
    }

    public GraphPerspective createGraphPerspective(int[] node_indices) {
        return this.createGraphPerspective(node_indices, this.getConnectingEdgeIndicesArray(node_indices));
    }

    public GraphPerspective createGraphPerspective(Filter filter) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (filter == null) {
            return (ColtGraphPerspective)this.clone();
        }
        Iterator nodes_iterator = this.nodesIterator();
        ArrayList<Node> post_filtered_nodes_list = new ArrayList<Node>(this.nodeCount);
        while (nodes_iterator.hasNext()) {
            Node node = (Node)nodes_iterator.next();
            if (!filter.passesFilter(node)) continue;
            post_filtered_nodes_list.add(node);
        }
        Node[] filtered_nodes = post_filtered_nodes_list.toArray(new Node[0]);
        Iterator edges_iterator = this.nodesIterator();
        ArrayList<Edge> post_filtered_edges_list = new ArrayList<Edge>(this.edgeCount);
        while (edges_iterator.hasNext()) {
            Edge edge = (Edge)edges_iterator.next();
            if (!filter.passesFilter(edge)) continue;
            post_filtered_edges_list.add(edge);
        }
        Edge[] filtered_edges = post_filtered_edges_list.toArray(new Edge[0]);
        return this.createGraphPerspective(filtered_nodes, filtered_edges);
    }

    public int[] getConnectingNodeIndicesArray(int[] edge_indices) {
        OpenIntIntHashMap nodes = new OpenIntIntHashMap(this.getNodeCount());
        for (int i = 0; i < edge_indices.length; ++i) {
            nodes.put(this.getRootGraphNodeIndex(this.getEdgeSourceIndex(edge_indices[i])), 1);
            nodes.put(this.getRootGraphNodeIndex(this.getEdgeTargetIndex(edge_indices[i])), 1);
        }
        IntArrayList node_s = nodes.keys();
        node_s.trimToSize();
        return node_s.elements();
    }

    public int[] getConnectingEdgeIndicesArray(int[] node_indices) {
        IntArrayList edges = new IntArrayList();
        for (int from_node = 0; from_node < node_indices.length; ++from_node) {
            for (int to_node = from_node; to_node < node_indices.length; ++to_node) {
                int[] edges_between = this.getEdgeIndicesArray(node_indices[from_node], node_indices[to_node], true, true);
                if (edges_between == null) continue;
                for (int i = 0; i < edges_between.length; ++i) {
                    edges.add(this.getRootGraphEdgeIndex(edges_between[i]));
                }
            }
        }
        edges.trimToSize();
        return edges.elements();
    }

    public List getConnectingEdges(List nodes) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int from_node = 0; from_node < nodes.size(); ++from_node) {
            for (int to_node = from_node; to_node < nodes.size(); ++to_node) {
                int[] edges_between = this.getEdgeIndicesArray(this.getIndex((Node)nodes.get(from_node)), this.getIndex((Node)nodes.get(to_node)), true, true);
                if (edges_between == null) continue;
                for (int i = 0; i < edges_between.length; ++i) {
                    edges.add(this.getEdge(edges_between[i]));
                }
            }
        }
        return edges;
    }

    public int[] getAdjacentEdgeIndicesArray(int node_index, boolean include_undirected_edges, boolean incoming_edges, boolean outgoing_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (!(include_undirected_edges || incoming_edges || outgoing_edges)) {
            return new int[0];
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        IntArrayList edges = new IntArrayList();
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNeighbor(node_index, node_i)) continue;
            int[] edges_between = null;
            if (incoming_edges && outgoing_edges) {
                edges_between = this.getEdgeIndicesArray(node_index, node_i, include_undirected_edges, true);
            } else if (incoming_edges && !outgoing_edges) {
                edges_between = this.getEdgeIndicesArray(node_i, node_index, include_undirected_edges);
            } else if (!incoming_edges && outgoing_edges) {
                edges_between = this.getEdgeIndicesArray(node_index, node_i, include_undirected_edges);
            } else if (include_undirected_edges) {
                edges_between = this.getEdgeIndicesArray(node_index, node_i, include_undirected_edges);
            }
            if (edges_between == null) continue;
            for (int i = 0; i < edges_between.length; ++i) {
                edges.add(edges_between[i]);
            }
        }
        edges.trimToSize();
        return edges.elements();
    }

    public List getAdjacentEdgesList(Node node, boolean include_undirected_edges, boolean incoming_edges, boolean outgoing_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The given Node must not be null.");
        }
        int node_index = this.getIndex(node);
        if (node_index == 0) {
            return new ArrayList();
        }
        int[] edge_indices = this.getAdjacentEdgeIndicesArray(node_index, include_undirected_edges, incoming_edges, outgoing_edges);
        if (edge_indices == null) {
            return new ArrayList();
        }
        ArrayList<Edge> edges = new ArrayList<Edge>(edge_indices.length);
        for (int i = 0; i < edge_indices.length; ++i) {
            edges.add(this.getEdge(edge_indices[i]));
        }
        return edges;
    }

    public List neighborsList(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The given Node must not be null.");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        ArrayList<Node> neighbors_list = new ArrayList<Node>(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNeighbor(index, node_i)) continue;
            neighbors_list.add(this.getNode(node_i));
        }
        return neighbors_list;
    }

    public int[] neighborsArray(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        int[] neighbors_list = new int[this.nodeCount];
        int count = 0;
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNeighbor(node_index, node_i)) continue;
            neighbors_list[count] = node_i;
            ++count;
        }
        int[] array = new int[count];
        System.arraycopy(neighbors_list, 0, array, 0, count);
        return array;
    }

    public boolean isNeighbor(Node a_node, Node another_node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeExists(a_node, another_node) || this.edgeExists(another_node, a_node);
    }

    public boolean isNeighbor(int a_node_index, int another_node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.edgeExists(a_node_index, another_node_index) || this.edgeExists(another_node_index, a_node_index);
    }

    public boolean edgeExists(Node from, Node to) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from == null || to == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        return this.edgeExists(this.getIndex(from), this.getIndex(to));
    }

    public boolean edgeExists(int from_node_index, int to_node_index) {
        if (from_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'from' node index, " + from_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (from_node_index < 0) {
            from_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(from_node_index);
        }
        if (from_node_index == 0) {
            return false;
        }
        if (to_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'to' node index, " + to_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (to_node_index < 0) {
            to_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(to_node_index);
        }
        if (to_node_index == 0) {
            return false;
        }
        int[] edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, to_node_index);
        if (edge_indices == null || edge_indices.length == 1) {
            return false;
        }
        for (int edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
            if (this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_indices[edge_i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int getEdgeCount(Node from, Node to, boolean count_undirected_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from == null || to == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        return this.getEdgeCount(this.getIndex(from), this.getIndex(to), count_undirected_edges);
    }

    public int getEdgeCount(int from_node_index, int to_node_index, boolean count_undirected_edges) {
        if (from_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'from' node index, " + from_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (from_node_index < 0) {
            from_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(from_node_index);
        }
        if (from_node_index == 0) {
            return 0;
        }
        if (to_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'to' node index, " + to_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (to_node_index < 0) {
            to_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(to_node_index);
        }
        if (to_node_index == 0) {
            return 0;
        }
        if (from_node_index == to_node_index && !count_undirected_edges) {
            return 0;
        }
        int[] edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, to_node_index);
        if (edge_indices == null || edge_indices.length == 1) {
            return 0;
        }
        int edge_count = 0;
        boolean edge_is_directed = false;
        for (int edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
            int edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_indices[edge_i]);
            if (edge_perspective_index == 0) continue;
            if (!count_undirected_edges) {
                boolean bl = edge_is_directed = ((int[])((Object[])this.coltEdgeDataPerspective.getQuick(0, edge_perspective_index))[1])[2] != 0;
            }
            if (!count_undirected_edges && !edge_is_directed) continue;
            ++edge_count;
        }
        return edge_count;
    }

    public List edgesList(Node from, Node to) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from == null || to == null) {
            throw new IllegalArgumentException("The Node arguments must not be null.");
        }
        return this.edgesList(this.getIndex(from), this.getIndex(to), true);
    }

    public List edgesList(int from_node_index, int to_node_index, boolean include_undirected_edges) {
        if (from_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'from' node index, " + from_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (from_node_index < 0) {
            from_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(from_node_index);
        }
        if (from_node_index == 0) {
            return null;
        }
        if (to_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'to' node index, " + to_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (to_node_index < 0) {
            to_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(to_node_index);
        }
        if (to_node_index == 0) {
            return null;
        }
        if (from_node_index == to_node_index && !include_undirected_edges) {
            return null;
        }
        int[] edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, to_node_index);
        if (edge_indices == null || edge_indices.length == 1) {
            return null;
        }
        ArrayList<Edge> edges_list = new ArrayList<Edge>(edge_indices.length);
        boolean edge_is_directed = false;
        for (int edge_i = 1; edge_i < edge_indices.length; ++edge_i) {
            int edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_indices[edge_i]);
            if (edge_perspective_index == 0) continue;
            if (!include_undirected_edges) {
                boolean bl = edge_is_directed = ((int[])((Object[])this.coltEdgeDataPerspective.getQuick(0, edge_perspective_index))[1])[2] != 0;
            }
            if (!include_undirected_edges && !edge_is_directed) continue;
            edges_list.add(this.getEdge(edge_perspective_index));
        }
        if (edges_list.isEmpty()) {
            return null;
        }
        return edges_list;
    }

    public int[] getEdgeIndicesArray(int from_node_index, int to_node_index, boolean include_undirected_edges, boolean include_both_directions) {
        if (include_undirected_edges && include_both_directions) {
            int[] s_t = this.getEdgeIndicesArray(from_node_index, to_node_index, true);
            int[] t_s = this.getEdgeIndicesArray(to_node_index, from_node_index, false);
            if (s_t == null && t_s != null) {
                return t_s;
            }
            if (t_s == null && s_t != null) {
                return s_t;
            }
            if (s_t == null && t_s == null) {
                return new int[0];
            }
            int[] edges_array = new int[t_s.length + s_t.length];
            System.arraycopy(s_t, 0, edges_array, 0, s_t.length);
            System.arraycopy(t_s, 0, edges_array, s_t.length, t_s.length);
            return edges_array;
        }
        if (!include_undirected_edges && include_both_directions) {
            int[] s_t = this.getEdgeIndicesArray(from_node_index, to_node_index, false);
            int[] t_s = this.getEdgeIndicesArray(to_node_index, from_node_index, false);
            if (s_t == null && t_s != null) {
                return t_s;
            }
            if (t_s == null && s_t != null) {
                return s_t;
            }
            if (s_t == null && t_s == null) {
                return new int[0];
            }
            int[] edges_array = new int[t_s.length + s_t.length];
            System.arraycopy(s_t, 0, edges_array, 0, s_t.length);
            System.arraycopy(t_s, 0, edges_array, s_t.length, t_s.length);
            return edges_array;
        }
        if (!include_both_directions) {
            return this.getEdgeIndicesArray(from_node_index, to_node_index, include_undirected_edges);
        }
        return null;
    }

    public int[] getEdgeIndicesArray(int from_node_index, int to_node_index, boolean include_undirected_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (from_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'from' node index, " + from_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (from_node_index < 0) {
            from_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(from_node_index);
        }
        if (from_node_index == 0) {
            return new int[0];
        }
        if (to_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given 'to' node index, " + to_node_index + ", cannot be the index of a Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        if (to_node_index < 0) {
            to_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(to_node_index);
        }
        if (to_node_index == 0) {
            return new int[0];
        }
        if (from_node_index == to_node_index && !include_undirected_edges) {
            return new int[0];
        }
        int[] non_hidden_edge_indices = (int[])this.coltNodeDataPerspective.getQuick(from_node_index, to_node_index);
        if (non_hidden_edge_indices == null || non_hidden_edge_indices.length == 1) {
            return new int[0];
        }
        IntArrayList edge_indices_list = new IntArrayList(non_hidden_edge_indices.length);
        boolean edge_is_directed = false;
        for (int edge_i = 1; edge_i < non_hidden_edge_indices.length; ++edge_i) {
            int edge_perspective_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(non_hidden_edge_indices[edge_i]);
            if (edge_perspective_index == 0) continue;
            if (!include_undirected_edges) {
                boolean bl = edge_is_directed = ((int[])((Object[])this.coltEdgeDataPerspective.getQuick(0, edge_perspective_index))[1])[2] != 0;
            }
            if (!include_undirected_edges && !edge_is_directed) continue;
            edge_indices_list.add(edge_perspective_index);
        }
        if (edge_indices_list.isEmpty()) {
            return new int[0];
        }
        edge_indices_list.trimToSize();
        return edge_indices_list.elements();
    }

    public int getInDegree(Node node) {
        return this.getInDegree(node, true);
    }

    public int getInDegree(int node_index) {
        return this.getInDegree(node_index, true);
    }

    public int getInDegree(Node node, boolean count_undirected_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        return this.getInDegree(this.getIndex(node), count_undirected_edges);
    }

    public int getInDegree(int node_index, boolean count_undirected_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return 0;
        }
        int in_degree = 0;
        for (int from_node_i = 1; from_node_i <= this.nodeCount; ++from_node_i) {
            in_degree += this.getEdgeCount(from_node_i, node_index, count_undirected_edges);
        }
        return in_degree;
    }

    public int getOutDegree(Node node) {
        return this.getOutDegree(node, true);
    }

    public int getOutDegree(int node_index) {
        return this.getOutDegree(node_index, true);
    }

    public int getOutDegree(Node node, boolean count_undirected_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        return this.getOutDegree(this.getIndex(node), count_undirected_edges);
    }

    public int getOutDegree(int node_index, boolean count_undirected_edges) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return 0;
        }
        int out_degree = 0;
        for (int to_node_i = 1; to_node_i <= this.nodeCount; ++to_node_i) {
            out_degree += this.getEdgeCount(node_index, to_node_i, count_undirected_edges);
        }
        return out_degree;
    }

    public int getDegree(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        return this.getInDegree(node, true) + this.getOutDegree(node, false);
    }

    public int getDegree(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        return this.getInDegree(node_index, true) + this.getOutDegree(node_index, false);
    }

    public int getIndex(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null.");
        }
        if (node.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given node is not in the RootGraph.");
        }
        return this.rootNodeIndexToPerspectiveNodeIndexMap.get(this.rootGraph.getIndex(node));
    }

    public int getNodeIndex(int root_graph_node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (root_graph_node_index == 0) {
            return 0;
        }
        if (root_graph_node_index > 0) {
            throw new IllegalArgumentException("The given index, " + root_graph_node_index + ", cannot be the index of a Node in the RootGraph, in which indices are all negative.");
        }
        return this.rootNodeIndexToPerspectiveNodeIndexMap.get(root_graph_node_index);
    }

    public int getRootGraphNodeIndex(int perspective_node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (perspective_node_index == 0) {
            return 0;
        }
        if (perspective_node_index < 0) {
            return perspective_node_index;
        }
        if (perspective_node_index > this.nodeCount) {
            throw new IllegalArgumentException("The given node index, " + perspective_node_index + ", cannot be the index of an Node in this GraphPerspective, in which indices are found only in the range 1 to " + this.nodeCount + ", inclusive.");
        }
        return this.perspectiveNodeIndexToRootNodeIndexArray[perspective_node_index];
    }

    public Node getNode(int index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (index < 0) {
            index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(index);
        }
        if (index == 0 || index > this.nodeCount) {
            return null;
        }
        Node node = (Node)this.coltNodeDataPerspective.getQuick(0, index);
        if (node == null) {
            node = this.rootGraph.createNode(this.perspectiveNodeIndexToRootNodeIndexArray[index]);
            this.coltNodeDataPerspective.setQuick(0, index, node);
        }
        return node;
    }

    public int getIndex(Edge edge) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            throw new IllegalArgumentException("The Edge argument must not be null.");
        }
        if (edge.getRootGraph() != this.rootGraph) {
            throw new IllegalArgumentException("The given edge is not in the RootGraph.");
        }
        return this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(this.rootGraph.getIndex(edge));
    }

    public int getEdgeIndex(int root_graph_edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (root_graph_edge_index == 0) {
            return 0;
        }
        if (root_graph_edge_index > 0) {
            throw new IllegalArgumentException("The given index, " + root_graph_edge_index + ", cannot be the index of an Edge in the RootGraph, in which indices are all negative.");
        }
        return this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(root_graph_edge_index);
    }

    public int getRootGraphEdgeIndex(int perspective_edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (perspective_edge_index == 0) {
            return 0;
        }
        if (perspective_edge_index < 0 || perspective_edge_index > this.edgeCount) {
            throw new IllegalArgumentException("The given edge index, " + perspective_edge_index + ", cannot be the index of an Edge in this GraphPerspective, in which indices are found only in the range 1 to " + this.edgeCount + ", inclusive.");
        }
        return this.perspectiveEdgeIndexToRootEdgeIndexArray[perspective_edge_index];
    }

    public Edge getEdge(int index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (index < 0) {
            index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(index);
        }
        if (index == 0 || index > this.edgeCount) {
            return null;
        }
        Object[] edge_data = (Object[])this.coltEdgeDataPerspective.getQuick(0, index);
        Edge edge = (Edge)edge_data[0];
        if (edge == null) {
            edge = this.rootGraph.createEdge(this.perspectiveEdgeIndexToRootEdgeIndexArray[index]);
            edge_data[0] = edge;
        }
        return edge;
    }

    public int getEdgeSourceIndex(int edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index < 0) {
            edge_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_index);
        }
        if (edge_index == 0 || edge_index > this.edgeCount) {
            return 0;
        }
        return this.rootNodeIndexToPerspectiveNodeIndexMap.get(((int[])((Object[])this.coltEdgeDataPerspective.get(0, edge_index))[1])[0]);
    }

    public int getEdgeTargetIndex(int edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index < 0) {
            edge_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_index);
        }
        if (edge_index == 0 || edge_index > this.edgeCount) {
            return 0;
        }
        return this.rootNodeIndexToPerspectiveNodeIndexMap.get(((int[])((Object[])this.coltEdgeDataPerspective.get(0, edge_index))[1])[1]);
    }

    public boolean isEdgeDirected(int edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index < 0) {
            edge_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_index);
        }
        if (edge_index == 0 || edge_index > this.edgeCount) {
            return false;
        }
        return ((int[])((Object[])this.coltEdgeDataPerspective.get(0, edge_index))[1])[2] != 0;
    }

    public boolean isMetaParent(Node child, Node parent) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child == null || parent == null) {
            throw new IllegalArgumentException("The Node arguments must not be null");
        }
        int child_index = this.getIndex(child);
        if (child_index == 0) {
            return false;
        }
        int parent_index = this.getIndex(parent);
        if (parent_index == 0) {
            return false;
        }
        return this.isNodeMetaParent(child_index, parent_index);
    }

    public boolean isNodeMetaParent(int child_node_index, int parent_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child_node_index == parent_index) {
            return false;
        }
        if (child_node_index < 0) {
            child_node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(child_node_index);
        }
        if (child_node_index == 0) {
            return false;
        }
        if (parent_index < 0) {
            parent_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(parent_index);
        }
        if (parent_index == 0) {
            return false;
        }
        int[] edge_indices = (int[])this.coltNodeDataPerspective.getQuick(parent_index, child_node_index);
        return edge_indices != null && edge_indices[0] == 1;
    }

    public List metaParentsList(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        return this.nodeMetaParentsList(index);
    }

    public List nodeMetaParentsList(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return null;
        }
        ArrayList<Node> meta_parents_list = new ArrayList<Node>(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNodeMetaParent(node_index, node_i)) continue;
            meta_parents_list.add(this.getNode(node_i));
        }
        return meta_parents_list;
    }

    public int[] getNodeMetaParentIndicesArray(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList meta_parent_indices_list = new IntArrayList(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNodeMetaParent(node_index, node_i)) continue;
            meta_parent_indices_list.add(node_i);
        }
        meta_parent_indices_list.trimToSize();
        return meta_parent_indices_list.elements();
    }

    public boolean isMetaChild(Node parent, Node child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isNodeMetaChild(int parent_index, int child_node_index) {
        return this.isNodeMetaParent(child_node_index, parent_index);
    }

    public List nodeMetaChildrenList(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        return this.nodeMetaChildrenList(index);
    }

    public List nodeMetaChildrenList(int parent_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (parent_index < 0) {
            parent_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(parent_index);
        }
        if (parent_index == 0) {
            return null;
        }
        ArrayList<Node> meta_children_list = new ArrayList<Node>(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNodeMetaChild(parent_index, node_i)) continue;
            meta_children_list.add(this.getNode(node_i));
        }
        return meta_children_list;
    }

    public int[] getNodeMetaChildIndicesArray(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList meta_children_indices_list = new IntArrayList(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isNodeMetaChild(node_index, node_i)) continue;
            meta_children_indices_list.add(node_i);
        }
        meta_children_indices_list.trimToSize();
        return meta_children_indices_list.elements();
    }

    public boolean isMetaParent(Edge child, Node parent) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child == null) {
            throw new IllegalArgumentException("The Edge argument must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int child_index = this.getIndex(child);
        if (child_index == 0) {
            return false;
        }
        int parent_index = this.getIndex(parent);
        if (parent_index == 0) {
            return false;
        }
        return this.isEdgeMetaParent(child_index, parent_index);
    }

    public boolean isEdgeMetaParent(int child_edge_index, int parent_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (child_edge_index < 0) {
            child_edge_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(child_edge_index);
        }
        if (child_edge_index == 0) {
            return false;
        }
        if (parent_index < 0) {
            parent_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(parent_index);
        }
        if (parent_index == 0) {
            return false;
        }
        int[] meta_edge = (int[])this.coltEdgeDataPerspective.getQuick(parent_index, child_edge_index);
        return meta_edge != null && meta_edge[0] == 1;
    }

    public List metaParentsList(Edge edge) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge == null) {
            throw new IllegalArgumentException("The Edge argument must not be null");
        }
        int index = this.getIndex(edge);
        if (index == 0) {
            return null;
        }
        return this.edgeMetaParentsList(index);
    }

    public List edgeMetaParentsList(int edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index < 0) {
            edge_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_index);
        }
        if (edge_index == 0) {
            return null;
        }
        ArrayList<Node> meta_parents_list = new ArrayList<Node>(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isEdgeMetaParent(edge_index, node_i)) continue;
            meta_parents_list.add(this.getNode(node_i));
        }
        return meta_parents_list;
    }

    public int[] getEdgeMetaParentIndicesArray(int edge_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (edge_index < 0) {
            edge_index = this.rootEdgeIndexToPerspectiveEdgeIndexMap.get(edge_index);
        }
        if (edge_index == 0) {
            return null;
        }
        IntArrayList meta_parent_indices_list = new IntArrayList(this.nodeCount);
        for (int node_i = 1; node_i <= this.nodeCount; ++node_i) {
            if (!this.isEdgeMetaParent(edge_index, node_i)) continue;
            meta_parent_indices_list.add(node_i);
        }
        meta_parent_indices_list.trimToSize();
        return meta_parent_indices_list.elements();
    }

    public boolean isMetaChild(Node parent, Edge child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isEdgeMetaChild(int parent_index, int child_edge_index) {
        return this.isEdgeMetaParent(child_edge_index, parent_index);
    }

    public List edgeMetaChildrenList(Node node) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node == null) {
            throw new IllegalArgumentException("The Node argument must not be null");
        }
        int index = this.getIndex(node);
        if (index == 0) {
            return null;
        }
        return this.edgeMetaChildrenList(index);
    }

    public List edgeMetaChildrenList(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return null;
        }
        ArrayList<Edge> meta_children_list = new ArrayList<Edge>(this.edgeCount);
        for (int edge_i = 1; edge_i <= this.edgeCount; ++edge_i) {
            if (!this.isEdgeMetaChild(node_index, edge_i)) continue;
            meta_children_list.add(this.getEdge(edge_i));
        }
        return meta_children_list;
    }

    public int[] getEdgeMetaChildIndicesArray(int node_index) {
        if (!this.coltGraphPerspectiveInitialized) {
            throw new IllegalStateException(NOT_INITIALIZED_EXCEPTION_STRING);
        }
        if (node_index < 0) {
            node_index = this.rootNodeIndexToPerspectiveNodeIndexMap.get(node_index);
        }
        if (node_index == 0) {
            return null;
        }
        IntArrayList meta_children_indices_list = new IntArrayList(this.edgeCount);
        for (int edge_i = 1; edge_i <= this.edgeCount; ++edge_i) {
            if (!this.isEdgeMetaChild(node_index, edge_i)) continue;
            meta_children_indices_list.add(edge_i);
        }
        meta_children_indices_list.trimToSize();
        return meta_children_indices_list.elements();
    }

    public void rootGraphChanged(RootGraphChangeEvent root_event) {
        ChangeEvent perspective_event = null;
        if (root_event.isNodesRemovedType()) {
            int[] removed_node_indices = root_event.getRemovedNodeIndices();
            OpenIntIntHashMap new_r_node_i_to_p_node_i_map = (OpenIntIntHashMap)this.rootNodeIndexToPerspectiveNodeIndexMap.copy();
            for (int removed_node_i = 0; removed_node_i < removed_node_indices.length; ++removed_node_i) {
                new_r_node_i_to_p_node_i_map.removeKey(removed_node_indices[removed_node_i]);
            }
            perspective_event = this.getChangeEvent();
            this.ensureValuesAreContiguousFrom1(new_r_node_i_to_p_node_i_map);
            this.setRootNodeIndexToPerspectiveNodeIndexMap(new_r_node_i_to_p_node_i_map, false, perspective_event);
        }
        if (root_event.isEdgesRemovedType()) {
            int[] removed_edge_indices = root_event.getRemovedEdgeIndices();
            OpenIntIntHashMap new_r_edge_i_to_p_edge_i_map = (OpenIntIntHashMap)this.rootEdgeIndexToPerspectiveEdgeIndexMap.copy();
            for (int removed_edge_i = 0; removed_edge_i < removed_edge_indices.length; ++removed_edge_i) {
                new_r_edge_i_to_p_edge_i_map.removeKey(removed_edge_indices[removed_edge_i]);
            }
            if (perspective_event == null) {
                perspective_event = this.getChangeEvent();
            }
            this.ensureValuesAreContiguousFrom1(new_r_edge_i_to_p_edge_i_map);
            this.setRootEdgeIndexToPerspectiveEdgeIndexMap(new_r_edge_i_to_p_edge_i_map, false, perspective_event);
        }
        if (root_event instanceof ColtRootGraph.ChangeEvent && ((ColtRootGraph.ChangeEvent)root_event).isColtNodeDataChangedType()) {
            this.coltNodeDataPerspective = this.rootGraph.createColtNodeDataPerspective(this, this.rootNodeIndexToPerspectiveNodeIndexMap);
        }
        if (root_event instanceof ColtRootGraph.ChangeEvent && ((ColtRootGraph.ChangeEvent)root_event).isColtEdgeDataChangedType()) {
            this.coltEdgeDataPerspective = this.rootGraph.createColtEdgeDataPerspective(this, this.rootNodeIndexToPerspectiveNodeIndexMap, this.rootEdgeIndexToPerspectiveEdgeIndexMap);
        }
        if (perspective_event != null) {
            this.fireGraphPerspectiveChanged(perspective_event);
        }
    }

    public void addGraphPerspectiveChangeListener(GraphPerspectiveChangeListener listener) {
        this.listenerList.add(class$giny$model$GraphPerspectiveChangeListener == null ? (class$giny$model$GraphPerspectiveChangeListener = ColtGraphPerspective.class$("giny.model.GraphPerspectiveChangeListener")) : class$giny$model$GraphPerspectiveChangeListener, listener);
    }

    public void removeGraphPerspectiveChangeListener(GraphPerspectiveChangeListener listener) {
        this.listenerList.remove(class$giny$model$GraphPerspectiveChangeListener == null ? (class$giny$model$GraphPerspectiveChangeListener = ColtGraphPerspective.class$("giny.model.GraphPerspectiveChangeListener")) : class$giny$model$GraphPerspectiveChangeListener, listener);
    }

    protected void fireGraphPerspectiveChanged(ChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$giny$model$GraphPerspectiveChangeListener == null ? ColtGraphPerspective.class$("giny.model.GraphPerspectiveChangeListener") : class$giny$model$GraphPerspectiveChangeListener)) continue;
            ((GraphPerspectiveChangeListener)listeners[i + 1]).graphPerspectiveChanged(event);
        }
        event.reset();
    }

    protected ChangeEvent getChangeEvent() {
        if (this.coltGraphPerspectiveChangeEvent == null) {
            this.coltGraphPerspectiveChangeEvent = this.createChangeEvent();
        }
        return this.coltGraphPerspectiveChangeEvent;
    }

    protected OldNodeMapProcedure getOldNodeMapProcedure() {
        if (this.oldNodeMapProcedure == null) {
            this.oldNodeMapProcedure = this.createOldNodeMapProcedure();
        }
        return this.oldNodeMapProcedure;
    }

    protected NewNodeMapProcedure getNewNodeMapProcedure() {
        if (this.newNodeMapProcedure == null) {
            this.newNodeMapProcedure = this.createNewNodeMapProcedure();
        }
        return this.newNodeMapProcedure;
    }

    protected OldEdgeMapProcedure getOldEdgeMapProcedure() {
        if (this.oldEdgeMapProcedure == null) {
            this.oldEdgeMapProcedure = this.createOldEdgeMapProcedure();
        }
        return this.oldEdgeMapProcedure;
    }

    protected NewEdgeMapProcedure getNewEdgeMapProcedure() {
        if (this.newEdgeMapProcedure == null) {
            this.newEdgeMapProcedure = this.createNewEdgeMapProcedure();
        }
        return this.newEdgeMapProcedure;
    }

    protected ContiguityEnsuringProcedure getContiguityEnsuringProcedure() {
        if (this.contiguityEnsuringProcedure == null) {
            this.contiguityEnsuringProcedure = this.createContiguityEnsuringProcedure();
        }
        return this.contiguityEnsuringProcedure;
    }

    protected ChangeEvent createChangeEvent() {
        return new ChangeEvent();
    }

    protected OldNodeMapProcedure createOldNodeMapProcedure() {
        return new OldNodeMapProcedure();
    }

    protected NewNodeMapProcedure createNewNodeMapProcedure() {
        return new NewNodeMapProcedure();
    }

    protected OldEdgeMapProcedure createOldEdgeMapProcedure() {
        return new OldEdgeMapProcedure();
    }

    protected NewEdgeMapProcedure createNewEdgeMapProcedure() {
        return new NewEdgeMapProcedure();
    }

    protected ContiguityEnsuringProcedure createContiguityEnsuringProcedure() {
        return new ContiguityEnsuringProcedure();
    }

    public void ensureValuesAreContiguousFrom1(OpenIntIntHashMap map) {
        IntArrayList keys = new IntArrayList(map.size());
        map.keys(keys);
        ContiguityEnsuringProcedure proc = this.getContiguityEnsuringProcedure();
        proc.map = map;
        keys.forEach(this.contiguityEnsuringProcedure);
        proc.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ChangeEvent
    extends GraphPerspectiveChangeEvent {
        protected int type;
        protected int[] restoredNodeIndices;
        protected int[] restoredEdgeIndices;
        protected int[] hiddenNodeIndices;
        protected int[] hiddenEdgeIndices;
        protected int[] selectedNodeIndices;
        protected int[] unselectedNodeIndices;
        protected int[] selectedEdgeIndices;
        protected int[] unselectedEdgeIndices;
        protected Node[] restoredNodes;
        protected Edge[] restoredEdges;
        protected Node[] hiddenNodes;
        protected Edge[] hiddenEdges;
        protected Node[] selectedNodes;
        protected Node[] unselectedNodes;
        protected Edge[] selectedEdges;
        protected Edge[] unselectedEdges;

        ChangeEvent() {
            super(ColtGraphPerspective.this);
            this.reset();
        }

        public void reset() {
            this.type = 0;
            this.restoredNodeIndices = null;
            this.restoredEdgeIndices = null;
            this.hiddenNodeIndices = null;
            this.hiddenEdgeIndices = null;
            this.restoredNodes = null;
            this.restoredEdges = null;
            this.hiddenNodes = null;
            this.hiddenEdges = null;
        }

        public int getType() {
            return this.type;
        }

        public boolean isNodesRestoredType() {
            return (this.type & 1) != 0;
        }

        public boolean isEdgesRestoredType() {
            return (this.type & 2) != 0;
        }

        public boolean isNodesHiddenType() {
            return (this.type & 4) != 0;
        }

        public boolean isEdgesHiddenType() {
            return (this.type & 8) != 0;
        }

        public boolean isNodesSelectedType() {
            return (this.type & 0x10) != 0;
        }

        public boolean isNodesUnselectedType() {
            return (this.type & 0x20) != 0;
        }

        public boolean isEdgesSelectedType() {
            return (this.type & 0x40) != 0;
        }

        public boolean isEdgesUnselectedType() {
            return (this.type & 0x80) != 0;
        }

        public Node[] getSelectedNodes() {
            if ((this.type & 0x10) == 0) {
                return null;
            }
            if (this.selectedNodes == null) {
                this.selectedNodes = new Node[this.selectedNodeIndices.length];
                for (int node_i = 0; node_i < this.selectedNodes.length; ++node_i) {
                    this.selectedNodes[node_i] = ((ColtGraphPerspective)this.source).getNode(this.selectedNodeIndices[node_i]);
                }
            }
            return this.selectedNodes;
        }

        public int[] getSelectedNodeIndices() {
            if ((this.type & 0x10) == 0) {
                return null;
            }
            if (this.selectedNodeIndices == null) {
                this.selectedNodeIndices = new int[this.selectedNodes.length];
                for (int node_i = 0; node_i < this.selectedNodeIndices.length; ++node_i) {
                    this.selectedNodeIndices[node_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.selectedNodes[node_i]);
                }
            }
            return this.selectedNodeIndices;
        }

        public Node[] getUnselectedNodes() {
            if ((this.type & 0x20) == 0) {
                return null;
            }
            if (this.unselectedNodes == null) {
                this.unselectedNodes = new Node[this.unselectedNodeIndices.length];
                for (int node_i = 0; node_i < this.unselectedNodes.length; ++node_i) {
                    this.unselectedNodes[node_i] = ((ColtGraphPerspective)this.source).getNode(this.unselectedNodeIndices[node_i]);
                }
            }
            return this.unselectedNodes;
        }

        public int[] getUnselectedNodeIndices() {
            if ((this.type & 0x20) == 0) {
                return null;
            }
            if (this.unselectedNodeIndices == null) {
                this.unselectedNodeIndices = new int[this.unselectedNodes.length];
                for (int node_i = 0; node_i < this.unselectedNodeIndices.length; ++node_i) {
                    this.unselectedNodeIndices[node_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.unselectedNodes[node_i]);
                }
            }
            return this.unselectedNodeIndices;
        }

        public Edge[] getSelectedEdges() {
            if ((this.type & 0x40) == 0) {
                return null;
            }
            if (this.selectedEdges == null) {
                this.selectedEdges = new Edge[this.selectedEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.selectedEdges.length; ++edge_i) {
                    this.selectedEdges[edge_i] = ((ColtGraphPerspective)this.source).getEdge(this.selectedEdgeIndices[edge_i]);
                }
            }
            return this.selectedEdges;
        }

        public int[] getSelectedEdgeIndices() {
            if ((this.type & 0x40) == 0) {
                return null;
            }
            if (this.selectedEdgeIndices == null) {
                this.selectedEdgeIndices = new int[this.selectedEdges.length];
                for (int edge_i = 0; edge_i < this.selectedEdgeIndices.length; ++edge_i) {
                    this.selectedEdgeIndices[edge_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.selectedEdges[edge_i]);
                }
            }
            return this.selectedEdgeIndices;
        }

        public Edge[] getUnselectedEdges() {
            if ((this.type & 0x80) == 0) {
                return null;
            }
            if (this.unselectedEdges == null) {
                this.unselectedEdges = new Edge[this.unselectedEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.unselectedEdges.length; ++edge_i) {
                    this.unselectedEdges[edge_i] = ((ColtGraphPerspective)this.source).getEdge(this.unselectedEdgeIndices[edge_i]);
                }
            }
            return this.unselectedEdges;
        }

        public int[] getUnselectedEdgeIndices() {
            if ((this.type & 0x80) == 0) {
                return null;
            }
            if (this.unselectedEdgeIndices == null) {
                this.unselectedEdgeIndices = new int[this.unselectedEdges.length];
                for (int edge_i = 0; edge_i < this.unselectedEdgeIndices.length; ++edge_i) {
                    this.unselectedEdgeIndices[edge_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.unselectedEdges[edge_i]);
                }
            }
            return this.unselectedEdgeIndices;
        }

        public Node[] getRestoredNodes() {
            if ((this.type & 1) == 0) {
                return null;
            }
            if (this.restoredNodes == null) {
                this.restoredNodes = new Node[this.restoredNodeIndices.length];
                for (int node_i = 0; node_i < this.restoredNodes.length; ++node_i) {
                    this.restoredNodes[node_i] = ((ColtGraphPerspective)this.source).getNode(this.restoredNodeIndices[node_i]);
                }
            }
            return this.restoredNodes;
        }

        public Edge[] getRestoredEdges() {
            if ((this.type & 2) == 0) {
                return null;
            }
            if (this.restoredEdges == null) {
                this.restoredEdges = new Edge[this.restoredEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.restoredEdges.length; ++edge_i) {
                    this.restoredEdges[edge_i] = ((ColtGraphPerspective)this.source).getEdge(this.restoredEdgeIndices[edge_i]);
                }
            }
            return this.restoredEdges;
        }

        public Node[] getHiddenNodes() {
            if ((this.type & 4) == 0) {
                return null;
            }
            if (this.hiddenNodes == null) {
                this.hiddenNodes = new Node[this.hiddenNodeIndices.length];
                for (int node_i = 0; node_i < this.hiddenNodes.length; ++node_i) {
                    this.hiddenNodes[node_i] = ((ColtGraphPerspective)this.source).getNode(this.hiddenNodeIndices[node_i]);
                }
            }
            return this.hiddenNodes;
        }

        public Edge[] getHiddenEdges() {
            if ((this.type & 8) == 0) {
                return null;
            }
            if (this.hiddenEdges == null) {
                this.hiddenEdges = new Edge[this.hiddenEdgeIndices.length];
                for (int edge_i = 0; edge_i < this.hiddenEdges.length; ++edge_i) {
                    this.hiddenEdges[edge_i] = ((ColtGraphPerspective)this.source).getEdge(this.hiddenEdgeIndices[edge_i]);
                }
            }
            return this.hiddenEdges;
        }

        public int[] getRestoredNodeIndices() {
            if ((this.type & 1) == 0) {
                return null;
            }
            if (this.restoredNodeIndices == null) {
                this.restoredNodeIndices = new int[this.restoredNodes.length];
                for (int node_i = 0; node_i < this.restoredNodeIndices.length; ++node_i) {
                    this.restoredNodeIndices[node_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.restoredNodes[node_i]);
                }
            }
            return this.restoredNodeIndices;
        }

        public int[] getRestoredEdgeIndices() {
            if ((this.type & 2) == 0) {
                return null;
            }
            if (this.restoredEdgeIndices == null) {
                this.restoredEdgeIndices = new int[this.restoredEdges.length];
                for (int edge_i = 0; edge_i < this.restoredEdgeIndices.length; ++edge_i) {
                    this.restoredEdgeIndices[edge_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.restoredEdges[edge_i]);
                }
            }
            return this.restoredEdgeIndices;
        }

        public int[] getHiddenNodeIndices() {
            if ((this.type & 4) == 0) {
                return null;
            }
            if (this.hiddenNodeIndices == null) {
                this.hiddenNodeIndices = new int[this.hiddenNodes.length];
                for (int node_i = 0; node_i < this.hiddenNodeIndices.length; ++node_i) {
                    this.hiddenNodeIndices[node_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.hiddenNodes[node_i]);
                }
            }
            return this.hiddenNodeIndices;
        }

        public int[] getHiddenEdgeIndices() {
            if ((this.type & 8) == 0) {
                return null;
            }
            if (this.hiddenEdgeIndices == null) {
                this.hiddenEdgeIndices = new int[this.hiddenEdges.length];
                for (int edge_i = 0; edge_i < this.hiddenEdgeIndices.length; ++edge_i) {
                    this.hiddenEdgeIndices[edge_i] = ColtGraphPerspective.this.rootGraph.getIndex(this.hiddenEdges[edge_i]);
                }
            }
            return this.hiddenEdgeIndices;
        }

        public void addHiddenNode(Node node) {
            if ((this.type & 4) == 0) {
                this.hiddenNodes = new Node[1];
                this.hiddenNodes[0] = node;
                this.type |= 4;
            } else {
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + 1];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    new_hidden_nodes[this.hiddenNodes.length] = node;
                    this.hiddenNodes = new_hidden_nodes;
                }
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + 1];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    new_hidden_node_indices[this.hiddenNodeIndices.length] = node.getRootGraphIndex();
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
            }
        }

        public void addHiddenNodes(Node[] nodes) {
            if ((this.type & 4) == 0) {
                this.hiddenNodes = nodes;
                this.type |= 4;
            } else {
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + nodes.length];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    System.arraycopy(nodes, 0, new_hidden_nodes, this.hiddenNodes.length, nodes.length);
                    this.hiddenNodes = new_hidden_nodes;
                }
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + nodes.length];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_hidden_node_indices[this.hiddenNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
            }
        }

        public void addHiddenNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((ColtGraphPerspective)this.source).getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 4) == 0) {
                this.hiddenNodeIndices = new int[1];
                this.hiddenNodeIndices[0] = node_index;
                this.type |= 4;
            } else {
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + 1];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    new_hidden_node_indices[this.hiddenNodeIndices.length] = node_index;
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + 1];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    new_hidden_nodes[this.hiddenNodes.length] = ColtGraphPerspective.this.rootGraph.getNode(node_index);
                    this.hiddenNodes = new_hidden_nodes;
                }
            }
        }

        public void addHiddenNodeIndices(int[] node_indices) {
            if ((this.type & 4) == 0) {
                this.hiddenNodeIndices = node_indices;
                this.type |= 4;
            } else {
                if (this.hiddenNodeIndices != null) {
                    int[] new_hidden_node_indices = new int[this.hiddenNodeIndices.length + node_indices.length];
                    System.arraycopy(this.hiddenNodeIndices, 0, new_hidden_node_indices, 0, this.hiddenNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_hidden_node_indices, this.hiddenNodeIndices.length, node_indices.length);
                    this.hiddenNodeIndices = new_hidden_node_indices;
                }
                if (this.hiddenNodes != null) {
                    Node[] new_hidden_nodes = new Node[this.hiddenNodes.length + node_indices.length];
                    System.arraycopy(this.hiddenNodes, 0, new_hidden_nodes, 0, this.hiddenNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_hidden_nodes[this.hiddenNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.hiddenNodes = new_hidden_nodes;
                }
            }
        }

        public void addRestoredNode(Node node) {
            if ((this.type & 1) == 0) {
                this.restoredNodes = new Node[1];
                this.restoredNodes[0] = node;
                this.type |= 1;
            } else {
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + 1];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    new_restored_nodes[this.restoredNodes.length] = node;
                    this.restoredNodes = new_restored_nodes;
                }
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + 1];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    new_restored_node_indices[this.restoredNodeIndices.length] = node.getRootGraphIndex();
                    this.restoredNodeIndices = new_restored_node_indices;
                }
            }
        }

        public void addRestoredNodes(Node[] nodes) {
            if ((this.type & 1) == 0) {
                this.restoredNodes = nodes;
                this.type |= 1;
            } else {
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + nodes.length];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    System.arraycopy(nodes, 0, new_restored_nodes, this.restoredNodes.length, nodes.length);
                    this.restoredNodes = new_restored_nodes;
                }
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + nodes.length];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_restored_node_indices[this.restoredNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.restoredNodeIndices = new_restored_node_indices;
                }
            }
        }

        public void addRestoredNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((ColtGraphPerspective)this.source).getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 1) == 0) {
                this.restoredNodeIndices = new int[1];
                this.restoredNodeIndices[0] = node_index;
                this.type |= 1;
            } else {
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + 1];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    new_restored_node_indices[this.restoredNodeIndices.length] = node_index;
                    this.restoredNodeIndices = new_restored_node_indices;
                }
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + 1];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    new_restored_nodes[this.restoredNodes.length] = ColtGraphPerspective.this.rootGraph.getNode(node_index);
                    this.restoredNodes = new_restored_nodes;
                }
            }
        }

        public void addRestoredNodeIndices(int[] node_indices) {
            if ((this.type & 1) == 0) {
                this.restoredNodeIndices = node_indices;
                this.type |= 1;
            } else {
                if (this.restoredNodeIndices != null) {
                    int[] new_restored_node_indices = new int[this.restoredNodeIndices.length + node_indices.length];
                    System.arraycopy(this.restoredNodeIndices, 0, new_restored_node_indices, 0, this.restoredNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_restored_node_indices, this.restoredNodeIndices.length, node_indices.length);
                    this.restoredNodeIndices = new_restored_node_indices;
                }
                if (this.restoredNodes != null) {
                    Node[] new_restored_nodes = new Node[this.restoredNodes.length + node_indices.length];
                    System.arraycopy(this.restoredNodes, 0, new_restored_nodes, 0, this.restoredNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_restored_nodes[this.restoredNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.restoredNodes = new_restored_nodes;
                }
            }
        }

        public void addHiddenEdge(Edge edge) {
            if ((this.type & 8) == 0) {
                this.hiddenEdges = new Edge[1];
                this.hiddenEdges[0] = edge;
                this.type |= 8;
            } else {
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + 1];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    new_hidden_edges[this.hiddenEdges.length] = edge;
                    this.hiddenEdges = new_hidden_edges;
                }
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + 1];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    new_hidden_edge_indices[this.hiddenEdgeIndices.length] = edge.getRootGraphIndex();
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
            }
        }

        public void addHiddenEdges(Edge[] edges) {
            if ((this.type & 8) == 0) {
                this.hiddenEdges = edges;
                this.type |= 8;
            } else {
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + edges.length];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    System.arraycopy(edges, 0, new_hidden_edges, this.hiddenEdges.length, edges.length);
                    this.hiddenEdges = new_hidden_edges;
                }
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + edges.length];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_hidden_edge_indices[this.hiddenEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
            }
        }

        public void addHiddenEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((ColtGraphPerspective)this.source).getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 8) == 0) {
                this.hiddenEdgeIndices = new int[1];
                this.hiddenEdgeIndices[0] = edge_index;
                this.type |= 8;
            } else {
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + 1];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    new_hidden_edge_indices[this.hiddenEdgeIndices.length] = edge_index;
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + 1];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    new_hidden_edges[this.hiddenEdges.length] = ColtGraphPerspective.this.rootGraph.getEdge(edge_index);
                    this.hiddenEdges = new_hidden_edges;
                }
            }
        }

        public void addHiddenEdgeIndices(int[] edge_indices) {
            if ((this.type & 8) == 0) {
                this.hiddenEdgeIndices = edge_indices;
                this.type |= 8;
            } else {
                if (this.hiddenEdgeIndices != null) {
                    int[] new_hidden_edge_indices = new int[this.hiddenEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.hiddenEdgeIndices, 0, new_hidden_edge_indices, 0, this.hiddenEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_hidden_edge_indices, this.hiddenEdgeIndices.length, edge_indices.length);
                    this.hiddenEdgeIndices = new_hidden_edge_indices;
                }
                if (this.hiddenEdges != null) {
                    Edge[] new_hidden_edges = new Edge[this.hiddenEdges.length + edge_indices.length];
                    System.arraycopy(this.hiddenEdges, 0, new_hidden_edges, 0, this.hiddenEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_hidden_edges[this.hiddenEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.hiddenEdges = new_hidden_edges;
                }
            }
        }

        public void addRestoredEdge(Edge edge) {
            if ((this.type & 2) == 0) {
                this.restoredEdges = new Edge[1];
                this.restoredEdges[0] = edge;
                this.type |= 2;
            } else {
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + 1];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    new_restored_edges[this.restoredEdges.length] = edge;
                    this.restoredEdges = new_restored_edges;
                }
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + 1];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    new_restored_edge_indices[this.restoredEdgeIndices.length] = edge.getRootGraphIndex();
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
            }
        }

        public void addRestoredEdges(Edge[] edges) {
            if ((this.type & 2) == 0) {
                this.restoredEdges = edges;
                this.type |= 2;
            } else {
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + edges.length];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    System.arraycopy(edges, 0, new_restored_edges, this.restoredEdges.length, edges.length);
                    this.restoredEdges = new_restored_edges;
                }
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + edges.length];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_restored_edge_indices[this.restoredEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
            }
        }

        public void addRestoredEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((ColtGraphPerspective)this.source).getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 2) == 0) {
                this.restoredEdgeIndices = new int[1];
                this.restoredEdgeIndices[0] = edge_index;
                this.type |= 2;
            } else {
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + 1];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    new_restored_edge_indices[this.restoredEdgeIndices.length] = edge_index;
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + 1];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    new_restored_edges[this.restoredEdges.length] = ColtGraphPerspective.this.rootGraph.getEdge(edge_index);
                    this.restoredEdges = new_restored_edges;
                }
            }
        }

        public void addRestoredEdgeIndices(int[] edge_indices) {
            if ((this.type & 2) == 0) {
                this.restoredEdgeIndices = edge_indices;
                this.type |= 2;
            } else {
                if (this.restoredEdgeIndices != null) {
                    int[] new_restored_edge_indices = new int[this.restoredEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.restoredEdgeIndices, 0, new_restored_edge_indices, 0, this.restoredEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_restored_edge_indices, this.restoredEdgeIndices.length, edge_indices.length);
                    this.restoredEdgeIndices = new_restored_edge_indices;
                }
                if (this.restoredEdges != null) {
                    Edge[] new_restored_edges = new Edge[this.restoredEdges.length + edge_indices.length];
                    System.arraycopy(this.restoredEdges, 0, new_restored_edges, 0, this.restoredEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_restored_edges[this.restoredEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.restoredEdges = new_restored_edges;
                }
            }
        }

        public void addSelectedNode(Node node) {
            if ((this.type & 0x10) == 0) {
                this.selectedNodes = new Node[1];
                this.selectedNodes[0] = node;
                this.type |= 0x10;
            } else {
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + 1];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    new_selected_nodes[this.selectedNodes.length] = node;
                    this.selectedNodes = new_selected_nodes;
                }
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + 1];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    new_selected_node_indices[this.selectedNodeIndices.length] = node.getRootGraphIndex();
                    this.selectedNodeIndices = new_selected_node_indices;
                }
            }
        }

        public void addSelectedNodes(Node[] nodes) {
            if ((this.type & 0x10) == 0) {
                this.selectedNodes = nodes;
                this.type |= 0x10;
            } else {
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + nodes.length];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    System.arraycopy(nodes, 0, new_selected_nodes, this.selectedNodes.length, nodes.length);
                    this.selectedNodes = new_selected_nodes;
                }
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + nodes.length];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_selected_node_indices[this.selectedNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.selectedNodeIndices = new_selected_node_indices;
                }
            }
        }

        public void addSelectedNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((ColtGraphPerspective)this.source).getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 0x10) == 0) {
                this.selectedNodeIndices = new int[1];
                this.selectedNodeIndices[0] = node_index;
                this.type |= 0x10;
            } else {
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + 1];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    new_selected_node_indices[this.selectedNodeIndices.length] = node_index;
                    this.selectedNodeIndices = new_selected_node_indices;
                }
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + 1];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    new_selected_nodes[this.selectedNodes.length] = ColtGraphPerspective.this.rootGraph.getNode(node_index);
                    this.selectedNodes = new_selected_nodes;
                }
            }
        }

        public void addSelectedNodeIndices(int[] node_indices) {
            if ((this.type & 0x10) == 0) {
                this.selectedNodeIndices = node_indices;
                this.type |= 0x10;
            } else {
                if (this.selectedNodeIndices != null) {
                    int[] new_selected_node_indices = new int[this.selectedNodeIndices.length + node_indices.length];
                    System.arraycopy(this.selectedNodeIndices, 0, new_selected_node_indices, 0, this.selectedNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_selected_node_indices, this.selectedNodeIndices.length, node_indices.length);
                    this.selectedNodeIndices = new_selected_node_indices;
                }
                if (this.selectedNodes != null) {
                    Node[] new_selected_nodes = new Node[this.selectedNodes.length + node_indices.length];
                    System.arraycopy(this.selectedNodes, 0, new_selected_nodes, 0, this.selectedNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_selected_nodes[this.selectedNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.selectedNodes = new_selected_nodes;
                }
            }
        }

        public void addUnselectedNode(Node node) {
            if ((this.type & 0x20) == 0) {
                this.unselectedNodes = new Node[1];
                this.unselectedNodes[0] = node;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + 1];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    new_unselected_nodes[this.unselectedNodes.length] = node;
                    this.unselectedNodes = new_unselected_nodes;
                }
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + 1];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    new_unselected_node_indices[this.unselectedNodeIndices.length] = node.getRootGraphIndex();
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
            }
        }

        public void addUnselectedNodes(Node[] nodes) {
            if ((this.type & 0x20) == 0) {
                this.unselectedNodes = nodes;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + nodes.length];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    System.arraycopy(nodes, 0, new_unselected_nodes, this.unselectedNodes.length, nodes.length);
                    this.unselectedNodes = new_unselected_nodes;
                }
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + nodes.length];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    for (int node_i = 0; node_i < nodes.length; ++node_i) {
                        new_unselected_node_indices[this.unselectedNodeIndices.length + node_i] = nodes[node_i].getRootGraphIndex();
                    }
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
            }
        }

        public void addUnselectedNodeIndex(int node_index) {
            if (node_index == 0) {
                throw new IllegalArgumentException("The node_index argument must not be 0.");
            }
            if (node_index > 0) {
                node_index = ((ColtGraphPerspective)this.source).getRootGraphNodeIndex(node_index);
            }
            if ((this.type & 0x20) == 0) {
                this.unselectedNodeIndices = new int[1];
                this.unselectedNodeIndices[0] = node_index;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + 1];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    new_unselected_node_indices[this.unselectedNodeIndices.length] = node_index;
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + 1];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    new_unselected_nodes[this.unselectedNodes.length] = ColtGraphPerspective.this.rootGraph.getNode(node_index);
                    this.unselectedNodes = new_unselected_nodes;
                }
            }
        }

        public void addUnselectedNodeIndices(int[] node_indices) {
            if ((this.type & 0x20) == 0) {
                this.unselectedNodeIndices = node_indices;
                this.type |= 0x20;
            } else {
                if (this.unselectedNodeIndices != null) {
                    int[] new_unselected_node_indices = new int[this.unselectedNodeIndices.length + node_indices.length];
                    System.arraycopy(this.unselectedNodeIndices, 0, new_unselected_node_indices, 0, this.unselectedNodeIndices.length);
                    System.arraycopy(node_indices, 0, new_unselected_node_indices, this.unselectedNodeIndices.length, node_indices.length);
                    this.unselectedNodeIndices = new_unselected_node_indices;
                }
                if (this.unselectedNodes != null) {
                    Node[] new_unselected_nodes = new Node[this.unselectedNodes.length + node_indices.length];
                    System.arraycopy(this.unselectedNodes, 0, new_unselected_nodes, 0, this.unselectedNodes.length);
                    for (int node_index_i = 0; node_index_i < node_indices.length; ++node_index_i) {
                        new_unselected_nodes[this.unselectedNodes.length + node_index_i] = ((GraphPerspective)this.source).getRootGraph().getNode(node_indices[node_index_i]);
                    }
                    this.unselectedNodes = new_unselected_nodes;
                }
            }
        }

        public void addSelectedEdge(Edge edge) {
            if ((this.type & 0x40) == 0) {
                this.selectedEdges = new Edge[1];
                this.selectedEdges[0] = edge;
                this.type |= 0x40;
            } else {
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + 1];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    new_selected_edges[this.selectedEdges.length] = edge;
                    this.selectedEdges = new_selected_edges;
                }
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + 1];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    new_selected_edge_indices[this.selectedEdgeIndices.length] = edge.getRootGraphIndex();
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
            }
        }

        public void addSelectedEdges(Edge[] edges) {
            if ((this.type & 0x40) == 0) {
                this.selectedEdges = edges;
                this.type |= 0x40;
            } else {
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + edges.length];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    System.arraycopy(edges, 0, new_selected_edges, this.selectedEdges.length, edges.length);
                    this.selectedEdges = new_selected_edges;
                }
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + edges.length];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_selected_edge_indices[this.selectedEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
            }
        }

        public void addSelectedEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((ColtGraphPerspective)this.source).getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 0x40) == 0) {
                this.selectedEdgeIndices = new int[1];
                this.selectedEdgeIndices[0] = edge_index;
                this.type |= 0x40;
            } else {
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + 1];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    new_selected_edge_indices[this.selectedEdgeIndices.length] = edge_index;
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + 1];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    new_selected_edges[this.selectedEdges.length] = ColtGraphPerspective.this.rootGraph.getEdge(edge_index);
                    this.selectedEdges = new_selected_edges;
                }
            }
        }

        public void addSelectedEdgeIndices(int[] edge_indices) {
            if ((this.type & 0x40) == 0) {
                this.selectedEdgeIndices = edge_indices;
                this.type |= 0x40;
            } else {
                if (this.selectedEdgeIndices != null) {
                    int[] new_selected_edge_indices = new int[this.selectedEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.selectedEdgeIndices, 0, new_selected_edge_indices, 0, this.selectedEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_selected_edge_indices, this.selectedEdgeIndices.length, edge_indices.length);
                    this.selectedEdgeIndices = new_selected_edge_indices;
                }
                if (this.selectedEdges != null) {
                    Edge[] new_selected_edges = new Edge[this.selectedEdges.length + edge_indices.length];
                    System.arraycopy(this.selectedEdges, 0, new_selected_edges, 0, this.selectedEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_selected_edges[this.selectedEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.selectedEdges = new_selected_edges;
                }
            }
        }

        public void addUnselectedEdge(Edge edge) {
            if ((this.type & 0x80) == 0) {
                this.unselectedEdges = new Edge[1];
                this.unselectedEdges[0] = edge;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + 1];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    new_unselected_edges[this.unselectedEdges.length] = edge;
                    this.unselectedEdges = new_unselected_edges;
                }
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + 1];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    new_unselected_edge_indices[this.unselectedEdgeIndices.length] = edge.getRootGraphIndex();
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
            }
        }

        public void addUnselectedEdges(Edge[] edges) {
            if ((this.type & 0x80) == 0) {
                this.unselectedEdges = edges;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + edges.length];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    System.arraycopy(edges, 0, new_unselected_edges, this.unselectedEdges.length, edges.length);
                    this.unselectedEdges = new_unselected_edges;
                }
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + edges.length];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    for (int edge_i = 0; edge_i < edges.length; ++edge_i) {
                        new_unselected_edge_indices[this.unselectedEdgeIndices.length + edge_i] = edges[edge_i].getRootGraphIndex();
                    }
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
            }
        }

        public void addUnselectedEdgeIndex(int edge_index) {
            if (edge_index == 0) {
                throw new IllegalArgumentException("The edge_index argument must not be 0.");
            }
            if (edge_index > 0) {
                edge_index = ((ColtGraphPerspective)this.source).getRootGraphEdgeIndex(edge_index);
            }
            if ((this.type & 0x80) == 0) {
                this.unselectedEdgeIndices = new int[1];
                this.unselectedEdgeIndices[0] = edge_index;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + 1];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    new_unselected_edge_indices[this.unselectedEdgeIndices.length] = edge_index;
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + 1];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    new_unselected_edges[this.unselectedEdges.length] = ColtGraphPerspective.this.rootGraph.getEdge(edge_index);
                    this.unselectedEdges = new_unselected_edges;
                }
            }
        }

        public void addUnselectedEdgeIndices(int[] edge_indices) {
            if ((this.type & 0x80) == 0) {
                this.unselectedEdgeIndices = edge_indices;
                this.type |= 0x80;
            } else {
                if (this.unselectedEdgeIndices != null) {
                    int[] new_unselected_edge_indices = new int[this.unselectedEdgeIndices.length + edge_indices.length];
                    System.arraycopy(this.unselectedEdgeIndices, 0, new_unselected_edge_indices, 0, this.unselectedEdgeIndices.length);
                    System.arraycopy(edge_indices, 0, new_unselected_edge_indices, this.unselectedEdgeIndices.length, edge_indices.length);
                    this.unselectedEdgeIndices = new_unselected_edge_indices;
                }
                if (this.unselectedEdges != null) {
                    Edge[] new_unselected_edges = new Edge[this.unselectedEdges.length + edge_indices.length];
                    System.arraycopy(this.unselectedEdges, 0, new_unselected_edges, 0, this.unselectedEdges.length);
                    for (int edge_index_i = 0; edge_index_i < edge_indices.length; ++edge_index_i) {
                        new_unselected_edges[this.unselectedEdges.length + edge_index_i] = ((GraphPerspective)this.source).getRootGraph().getEdge(edge_indices[edge_index_i]);
                    }
                    this.unselectedEdges = new_unselected_edges;
                }
            }
        }
    }

    class ContiguityEnsuringProcedure
    implements IntProcedure {
        int nextContiguousIndex = 1;
        OpenIntIntHashMap map = null;

        public ContiguityEnsuringProcedure() {
            this.reset();
        }

        public void reset() {
            this.nextContiguousIndex = 1;
            this.map = null;
        }

        public boolean apply(int key) {
            this.map.put(key, this.nextContiguousIndex++);
            return true;
        }
    }

    class NewEdgeMapProcedure
    implements IntIntProcedure {
        IntArrayList eventRestoredEdgeIndices = null;
        OpenIntIntHashMap oldREdgeIToPEdgeIMap = null;
        OpenIntIntHashMap pEdgeIToREdgeIMap = null;
        ChangeEvent event = null;
        boolean restoreAllIncidentNodes = false;
        int highestPerspectiveIndex = 0;

        public NewEdgeMapProcedure() {
            this.reset();
        }

        public void reset() {
            this.eventRestoredEdgeIndices = null;
            this.oldREdgeIToPEdgeIMap = null;
            this.pEdgeIToREdgeIMap = null;
            this.highestPerspectiveIndex = 0;
            this.event = null;
            this.restoreAllIncidentNodes = false;
        }

        public boolean apply(int root_index, int new_p_index) {
            if (!(!this.restoreAllIncidentNodes && this.event == null || this.oldREdgeIToPEdgeIMap != null && this.oldREdgeIToPEdgeIMap.containsKey(root_index))) {
                if (this.eventRestoredEdgeIndices == null) {
                    this.eventRestoredEdgeIndices = new IntArrayList();
                }
                this.eventRestoredEdgeIndices.add(root_index);
            }
            if (new_p_index > this.highestPerspectiveIndex) {
                this.highestPerspectiveIndex = new_p_index;
            }
            this.pEdgeIToREdgeIMap.put(new_p_index, root_index);
            return true;
        }
    }

    class OldEdgeMapProcedure
    implements IntIntProcedure {
        IntArrayList eventHiddenEdgeIndices = null;
        OpenIntIntHashMap newREdgeIToPEdgeIMap = null;

        public OldEdgeMapProcedure() {
            this.reset();
        }

        public void reset() {
            this.eventHiddenEdgeIndices = null;
            this.newREdgeIToPEdgeIMap = null;
        }

        public boolean apply(int root_index, int old_p_index) {
            if (!this.newREdgeIToPEdgeIMap.containsKey(root_index)) {
                if (this.eventHiddenEdgeIndices == null) {
                    this.eventHiddenEdgeIndices = new IntArrayList();
                }
                this.eventHiddenEdgeIndices.add(root_index);
            }
            return true;
        }
    }

    class NewNodeMapProcedure
    implements IntIntProcedure {
        IntArrayList eventRestoredNodeIndices = null;
        OpenIntIntHashMap oldRNodeIToPNodeIMap = null;
        OpenIntIntHashMap pNodeIToRNodeIMap = null;
        ChangeEvent event = null;
        int highestPerspectiveIndex = 0;

        public NewNodeMapProcedure() {
            this.reset();
        }

        public void reset() {
            this.eventRestoredNodeIndices = null;
            this.oldRNodeIToPNodeIMap = null;
            this.pNodeIToRNodeIMap = null;
            this.highestPerspectiveIndex = 0;
            this.event = null;
        }

        public boolean apply(int root_index, int new_p_index) {
            if (!(this.event == null || this.oldRNodeIToPNodeIMap != null && this.oldRNodeIToPNodeIMap.containsKey(root_index))) {
                if (this.eventRestoredNodeIndices == null) {
                    this.eventRestoredNodeIndices = new IntArrayList();
                }
                this.eventRestoredNodeIndices.add(root_index);
            }
            if (new_p_index > this.highestPerspectiveIndex) {
                this.highestPerspectiveIndex = new_p_index;
            }
            this.pNodeIToRNodeIMap.put(new_p_index, root_index);
            return true;
        }
    }

    protected class OldNodeMapProcedure
    implements IntIntProcedure {
        IntArrayList eventHiddenNodeIndices = null;
        OpenIntIntHashMap newRNodeIToPNodeIMap = null;

        public OldNodeMapProcedure() {
            this.reset();
        }

        public void reset() {
            this.eventHiddenNodeIndices = null;
            this.newRNodeIToPNodeIMap = null;
        }

        public boolean apply(int root_index, int old_p_index) {
            if (!this.newRNodeIToPNodeIMap.containsKey(root_index)) {
                if (this.eventHiddenNodeIndices == null) {
                    this.eventHiddenNodeIndices = new IntArrayList();
                }
                this.eventHiddenNodeIndices.add(root_index);
            }
            return true;
        }
    }
}

