/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import org.jfree.util.Log;

public class LogContext {
    private String contextPrefix;

    public LogContext(String string) {
        this.contextPrefix = string;
    }

    public boolean isDebugEnabled() {
        return Log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return Log.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return Log.isWarningEnabled();
    }

    public boolean isErrorEnabled() {
        return Log.isErrorEnabled();
    }

    public void debug(Object object) {
        this.log(3, object);
    }

    public void debug(Object object, Exception exception) {
        this.log(3, object, exception);
    }

    public void info(Object object) {
        this.log(2, object);
    }

    public void info(Object object, Exception exception) {
        this.log(2, object, exception);
    }

    public void warn(Object object) {
        this.log(1, object);
    }

    public void warn(Object object, Exception exception) {
        this.log(1, object, exception);
    }

    public void error(Object object) {
        this.log(0, object);
    }

    public void error(Object object, Exception exception) {
        this.log(0, object, exception);
    }

    public void log(int n, Object object) {
        if (this.contextPrefix != null) {
            Log.getInstance().doLog(n, new Log.SimpleMessage(this.contextPrefix, ":", object));
        } else {
            Log.getInstance().doLog(n, object);
        }
    }

    public void log(int n, Object object, Exception exception) {
        if (this.contextPrefix != null) {
            Log.getInstance().doLog(n, new Log.SimpleMessage(this.contextPrefix, ":", object), exception);
        } else {
            Log.getInstance().doLog(n, object, exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LogContext)) {
            return false;
        }
        LogContext logContext = (LogContext)object;
        return !(this.contextPrefix != null ? !this.contextPrefix.equals(logContext.contextPrefix) : logContext.contextPrefix != null);
    }

    public int hashCode() {
        return this.contextPrefix != null ? this.contextPrefix.hashCode() : 0;
    }
}

