/*
 * Decompiled with CFR 0.152.
 */
package diff;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import diff.Diff;
import filter.model.Filter;
import filter.view.FilterListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DiffView
extends JFrame
implements ActionListener,
PropertyChangeListener {
    FilterListPanel filterListPanel1;
    FilterListPanel filterListPanel2;
    JComboBox networkBox1;
    JComboBox networkBox2;
    JButton filterApply;
    JButton networkApply;
    Map titleIdMap;
    JButton createNetwork;
    JButton createFilter;
    TableModel diffTableModel;
    JTable diffTable;
    JPanel post_panel;
    String diff1;
    String diff2;

    public DiffView() {
        super("DiffViewer");
        this.initialize();
    }

    protected void initialize() {
        this.titleIdMap = new HashMap();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        JPanel pre_panel = new JPanel();
        JTabbedPane tabs = new JTabbedPane();
        JPanel network_diff_panel = new JPanel();
        network_diff_panel.setLayout(new BorderLayout());
        this.networkBox1 = this.getNetworkBox();
        this.networkBox2 = this.getNetworkBox();
        JPanel n1 = new JPanel();
        n1.add(new JLabel("Network 1:"));
        n1.add(this.networkBox1);
        JPanel n2 = new JPanel();
        n2.add(new JLabel("Network 2:"));
        n2.add(this.networkBox2);
        network_diff_panel.add((Component)n1, "West");
        network_diff_panel.add((Component)n2, "East");
        this.networkApply = new JButton("Diff");
        this.networkApply.addActionListener(this);
        network_diff_panel.add((Component)this.networkApply, "South");
        tabs.addTab("Networks", network_diff_panel);
        JPanel filter_diff_panel = new JPanel();
        filter_diff_panel.setLayout(new BorderLayout());
        this.filterListPanel1 = new FilterListPanel(1);
        this.filterListPanel2 = new FilterListPanel(1);
        JPanel f1 = new JPanel();
        f1.setLayout(new BorderLayout());
        f1.add((Component)new JLabel("Filter 1:"), "North");
        f1.add((Component)this.filterListPanel1, "Center");
        filter_diff_panel.add((Component)f1, "East");
        JPanel f2 = new JPanel();
        f2.setLayout(new BorderLayout());
        f2.add((Component)new JLabel("Filter 2:"), "North");
        f2.add((Component)this.filterListPanel2, "Center");
        filter_diff_panel.add((Component)f1, "West");
        filter_diff_panel.add((Component)f2, "East");
        this.filterApply = new JButton("Diff");
        this.filterApply.addActionListener(this);
        filter_diff_panel.add((Component)this.filterApply, "South");
        tabs.add("Filters", filter_diff_panel);
        pre_panel.add(tabs);
        this.post_panel = new JPanel();
        this.post_panel.setLayout(new BorderLayout());
        JPanel button_panel = new JPanel();
        JButton createNetwork = new JButton("Create Network");
        createNetwork.addActionListener(this);
        JButton createFilter = new JButton("Create Filter");
        createFilter.addActionListener(this);
        button_panel.add(createNetwork);
        button_panel.add(createFilter);
        this.post_panel.add((Component)button_panel, "South");
        this.diffTableModel = new DefaultTableModel(new Object[]{"1", "diff", "2"}, 1);
        this.diffTable = new JTable(this.diffTableModel);
        JScrollPane scroll = new JScrollPane(this.diffTable);
        this.post_panel.add((Component)scroll, "Center");
        JSplitPane split = new JSplitPane(0, pre_panel, this.post_panel);
        this.setContentPane(split);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.filterApply) {
            this.filterDiff();
        } else if (e.getSource() == this.networkApply) {
            this.networkDiff();
        }
    }

    protected void filterDiff() {
        Iterator nodes_i = Cytoscape.getRootGraph().nodesList().iterator();
        HashSet<CyNode> passes1 = new HashSet<CyNode>();
        HashSet<CyNode> passes2 = new HashSet<CyNode>();
        Filter filter1 = this.filterListPanel1.getSelectedFilter();
        Filter filter2 = this.filterListPanel2.getSelectedFilter();
        while (nodes_i.hasNext()) {
            CyNode node = (CyNode)nodes_i.next();
            try {
                if (filter1.passesFilter(node)) {
                    passes1.add(node);
                }
                if (!filter2.passesFilter(node)) continue;
                passes2.add(node);
            }
            catch (StackOverflowError soe) {
                return;
            }
        }
        ArrayList list1 = new ArrayList(passes1);
        ArrayList list2 = new ArrayList(passes2);
        List diff = Diff.nodesDiff(list1, list2);
        this.updateModel(list1, list2, diff);
    }

    protected void networkDiff() {
        String network_id_1 = (String)this.titleIdMap.get(this.networkBox1.getSelectedItem());
        String network_id_2 = (String)this.titleIdMap.get(this.networkBox2.getSelectedItem());
        CyNetwork n1 = Cytoscape.getNetwork((String)network_id_1);
        CyNetwork n2 = Cytoscape.getNetwork((String)network_id_2);
        List list1 = n1.nodesList();
        List list2 = n2.nodesList();
        List diff = Diff.nodesDiff(list1, list2);
        this.updateModel(list1, list2, diff);
    }

    protected void updateModel(List list1, List list2, List diff) {
        Vector row;
        CyNode node;
        Vector data = new Vector();
        HashMap<CyNode, Vector> node_vector = new HashMap<CyNode, Vector>();
        Iterator i1 = list1.iterator();
        Iterator i2 = list2.iterator();
        Iterator di = diff.iterator();
        HashSet<CyNode> shared_set = new HashSet<CyNode>();
        while (i1.hasNext()) {
            node = (CyNode)i1.next();
            if (!node_vector.containsKey(node)) {
                row = new Vector(3);
                row.add("");
                row.add("");
                row.add("");
                node_vector.put(node, row);
            } else {
                row = (Vector)node_vector.get(node);
            }
            row.add(0, node);
        }
        while (di.hasNext()) {
            node = (CyNode)di.next();
            if (!node_vector.containsKey(node)) {
                row = new Vector(3);
                row.add("");
                row.add("");
                row.add("");
                node_vector.put(node, row);
            } else {
                row = (Vector)node_vector.get(node);
            }
            row.add(1, node);
        }
        while (i2.hasNext()) {
            node = (CyNode)i2.next();
            if (!node_vector.containsKey(node)) {
                row = new Vector(3);
                row.add("");
                row.add("");
                row.add("");
                node_vector.put(node, row);
            } else {
                row = (Vector)node_vector.get(node);
            }
            if (row.get(0) instanceof CyNode) {
                shared_set.add(node);
            }
            row.add(2, node);
        }
        HashSet<CyNode> in_set = new HashSet<CyNode>();
        i1 = list1.iterator();
        i2 = list2.iterator();
        di = shared_set.iterator();
        while (i1.hasNext()) {
            node = (CyNode)i1.next();
            if (in_set.contains(node) || shared_set.contains(node)) continue;
            data.add(node_vector.get(node));
            in_set.add(node);
        }
        while (di.hasNext()) {
            node = (CyNode)di.next();
            if (in_set.contains(node)) continue;
            data.add(node_vector.get(node));
            in_set.add(node);
        }
        while (i2.hasNext()) {
            node = (CyNode)i2.next();
            if (in_set.contains(node) || shared_set.contains(node)) continue;
            data.add(node_vector.get(node));
            in_set.add(node);
        }
        Vector<String> col = new Vector<String>(3);
        col.add("1");
        col.add("diff");
        col.add("2");
        System.out.println("list1 size: " + list1.size() + "list2 size: " + list2.size() + "diff size: " + diff.size());
        ((DefaultTableModel)this.diffTableModel).setDataVector(data, col);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals(Cytoscape.NETWORK_CREATED) || e.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED)) {
            this.updateNetworkBox();
        }
    }

    protected void updateNetworkBox() {
        Iterator i = Cytoscape.getNetworkSet().iterator();
        Vector<String> vector = new Vector<String>();
        vector.add("Current Network");
        while (i.hasNext()) {
            CyNetwork net = Cytoscape.getNetwork((String)((String)i.next()));
            this.titleIdMap.put(net.getTitle(), net.getIdentifier());
            vector.add(net.getTitle());
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(vector);
        this.networkBox1.setModel(model);
        model = new DefaultComboBoxModel(vector);
        this.networkBox2.setModel(model);
    }

    protected JComboBox getNetworkBox() {
        Iterator i = Cytoscape.getNetworkSet().iterator();
        Vector<String> vector = new Vector<String>();
        vector.add("Current Network");
        while (i.hasNext()) {
            CyNetwork net = Cytoscape.getNetwork((String)((String)i.next()));
            this.titleIdMap.put(net.getTitle(), net.getIdentifier());
            vector.add(net.getTitle());
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(vector);
        return new JComboBox(model);
    }
}

