/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.datamatrix;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class LensedDataMatrix
extends DataMatrix
implements Serializable {
    int[] columnOrder;
    boolean[] columnState;
    boolean[] rowState;
    boolean noExplicitRowSelection = true;
    DataMatrix underlyingMatrix;
    Hashtable nameMap = new Hashtable();
    static final /* synthetic */ boolean $assertionsDisabled;

    public LensedDataMatrix(DataMatrix dataMatrix) throws Exception {
        this.underlyingMatrix = dataMatrix;
        this.rowTitlesTitle = dataMatrix.getRowTitlesTitle();
        this.columnTitles = dataMatrix.getColumnTitles();
        this.rowTitles = dataMatrix.getRowTitles();
        this.data = dataMatrix.get();
        this.uri = dataMatrix.getFullName();
        this.fullName = dataMatrix.getFullName();
        this.shortName = dataMatrix.getShortName();
        this.fileExtension = dataMatrix.getFileExtension();
        this.dataTypeBriefName = dataMatrix.getDataTypeBriefName();
        this.species = dataMatrix.getSpecies();
        for (int i = 0; i < this.rowTitles.length; ++i) {
            this.nameMap.put(this.rowTitles[i], new Integer(i));
        }
        this.init();
    }

    public DataMatrix getUnderlyingMatrix() {
        return this.underlyingMatrix;
    }

    private void init() {
        this.clear();
    }

    public void clear() {
        int n = this.columnTitles.length;
        this.columnState = new boolean[n];
        this.columnOrder = new int[n];
        for (int i = 0; i < n; ++i) {
            this.columnState[i] = true;
            this.columnOrder[i] = i;
        }
        this.rowState = new boolean[this.rowTitles.length];
        this.setRowState(false);
        this.noExplicitRowSelection = true;
    }

    public void setColumnState(boolean bl) {
        for (int i = 0; i < this.columnState.length; ++i) {
            this.columnState[i] = bl;
        }
    }

    public void setColumnState(int[] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.columnState[nArray[i]] = bl;
        }
    }

    public void setColumnState(int n, boolean bl) {
        this.columnState[n] = bl;
    }

    public boolean[] getColumnState() {
        return this.columnState;
    }

    public boolean getColumnState(int n) {
        return this.columnState[n];
    }

    public void setRowState(boolean bl) {
        for (int i = 0; i < this.underlyingMatrix.getRowCount(); ++i) {
            this.rowState[i] = bl;
        }
    }

    public void setRowState(int[] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.setRowState(nArray[i], bl);
        }
    }

    public void setRowState(int n, boolean bl) {
        this.rowState[n] = bl;
    }

    public void enableRow(int n) {
        this.setRowState(n, true);
    }

    public void enableRows(int[] nArray) {
        this.setRowState(nArray, true);
    }

    public void enableAllRows() {
        for (int i = 0; i < this.rowState.length; ++i) {
            this.setRowState(i, true);
        }
    }

    public void disableRow(int n) {
        this.setRowState(n, false);
    }

    public void disableRows(int[] nArray) {
        this.setRowState(nArray, false);
    }

    public void disableAllRows() {
        for (int i = 0; i < this.rowState.length; ++i) {
            this.setRowState(i, false);
        }
    }

    public void enableColumn(int n) {
        this.setColumnState(n, true);
    }

    public void enableColumns(int[] nArray) {
        this.setColumnState(nArray, true);
    }

    public void enableAllColumns() {
        for (int i = 0; i < this.columnState.length; ++i) {
            this.setColumnState(i, true);
        }
    }

    public void disableColumn(int n) {
        this.setColumnState(n, false);
    }

    public void disableColumns(int[] nArray) {
        this.setColumnState(nArray, false);
    }

    public void disableAllColumns() {
        for (int i = 0; i < this.columnState.length; ++i) {
            this.setColumnState(i, false);
        }
    }

    public boolean[] getRowState() {
        return this.rowState;
    }

    public boolean getRowState(int n) {
        return this.rowState[n];
    }

    public int getRowCount() {
        int n = 0;
        for (int i = 0; i < this.rowState.length; ++i) {
            if (!this.rowState[i]) continue;
            ++n;
        }
        return n;
    }

    public int getColumnCount() {
        int n = 0;
        for (int i = 0; i < this.columnState.length; ++i) {
            if (!this.columnState[i]) continue;
            ++n;
        }
        return n;
    }

    public void changeColumnPosition(int n, int n2) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            vector.add(new Integer(this.columnOrder[i]));
        }
        Integer n3 = (Integer)vector.remove(n);
        vector.add(n2, n3);
        for (int i = 0; i < this.columnOrder.length; ++i) {
            this.columnOrder[i] = (Integer)vector.get(i);
        }
    }

    public int getColumnOrder(int n) {
        return this.columnOrder[n];
    }

    public String[] getColumnTitles() {
        return this.adjustTitlesForColumnOrderAndState(this.columnTitles);
    }

    public String[] getRowTitles() {
        String[] stringArray = this.underlyingMatrix.getRowTitles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.rowState.length; ++i) {
            if (!this.rowState[i]) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public int adjustRowIndexForRowState(int n) {
        if (!$assertionsDisabled && n >= this.getRowCount()) {
            throw new AssertionError();
        }
        int n2 = -1;
        for (int i = 0; i < this.rowState.length; ++i) {
            if (!this.rowState[i] || n != ++n2) continue;
            return i;
        }
        throw new IllegalArgumentException("requestedRow " + n + " is out of range.  visible row count: " + this.getRowCount());
    }

    public DataMatrix getVisibleMatrix() {
        DataMatrix dataMatrix = new DataMatrix();
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        dataMatrix.setSize(n, n2);
        dataMatrix.setColumnTitles(this.getColumnTitles());
        dataMatrix.setRowTitles(this.getRowTitles());
        dataMatrix.setRowTitlesTitle(this.getRowTitlesTitle());
        dataMatrix.setSpecies(this.getSpecies());
        int n3 = this.underlyingMatrix.getRowCount();
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.get(i);
            for (int j = 0; j < dArray.length; ++j) {
                dataMatrix.set(i, j, dArray[j]);
            }
        }
        return dataMatrix;
    }

    public String toString() {
        return this.getVisibleMatrix().toString();
    }

    public void printTransformation() {
        int n;
        if (!$assertionsDisabled && this.columnState.length != this.columnOrder.length) {
            throw new AssertionError();
        }
        int n2 = this.columnState.length;
        if (!$assertionsDisabled && this.columnState.length != this.underlyingMatrix.getColumnCount()) {
            throw new AssertionError();
        }
        System.out.print("column\t");
        for (n = 0; n < n2; ++n) {
            System.out.print(n + "\t");
        }
        System.out.println();
        System.out.println("---------------------------");
        System.out.print("order\t");
        for (n = 0; n < n2; ++n) {
            System.out.print(this.columnOrder[n] + "\t");
        }
        System.out.println();
        System.out.print("state\t");
        for (n = 0; n < n2; ++n) {
            String string = "F";
            if (this.columnState[n]) {
                string = "T";
            }
            System.out.print(string + "\t");
        }
        System.out.println();
        System.out.println();
        System.out.println("row\tstate\t");
        System.out.println("------------------");
        for (n = 0; n < this.rowState.length; ++n) {
            System.out.println(n + "\t" + this.rowState[n]);
        }
    }

    public double[] get(int n) {
        int n2 = this.adjustRowIndexForRowState(n);
        return this.adjustRowForColumnOrderAndState(this.underlyingMatrix.get(n2));
    }

    public double get(int n, int n2) {
        int n3 = this.adjustRowIndexForRowState(n);
        return this.adjustRowForColumnOrderAndState(this.underlyingMatrix.get(n3))[n2];
    }

    public double[] get(String string) {
        return this.adjustRowForColumnOrderAndState(this.underlyingMatrix.get(string));
    }

    public double[][] get() {
        double[][] dArray = new double[this.getRowCount()][this.getColumnCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            dArray[i] = this.get(i);
        }
        return dArray;
    }

    public double[] getColumn(int n) {
        int n2 = this.columnOrder[n];
        return this.underlyingMatrix.getColumn(n2);
    }

    public int getRowIndex(String string) {
        return (Integer)this.nameMap.get(string);
    }

    protected double[] adjustRowForColumnOrderAndState(double[] dArray) {
        int n = this.getColumnCount();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (!this.columnState[i]) continue;
            double d = dArray[this.columnOrder[i]];
            arrayList.add(new Double(d));
        }
        double[] dArray2 = new double[arrayList.size()];
        Double[] doubleArray = arrayList.toArray(new Double[0]);
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray2[i] = doubleArray[i];
        }
        return dArray2;
    }

    protected String[] adjustTitlesForColumnOrderAndState(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (!this.columnState[i]) continue;
            String string = stringArray2[this.columnOrder[i]];
            arrayList.add(string);
        }
        String[] stringArray3 = arrayList.toArray(new String[0]);
        return stringArray3;
    }

    static {
        $assertionsDisabled = !LensedDataMatrix.class.desiredAssertionStatus();
    }
}

