#!/usr/local/bin/perl

###############################################################################
# Program     : readDtaFile.pl
# Author      : Eric Deutsch <edeutsch@systemsbiology.org>
# $Id: calcNTransmembraneRegions.pl,v 1.1 2003/01/22 20:36:58 edeutsch Exp $
#
# Description : Test program to read a sequest .dta file using
#               SBEAMS::Proteomics::Utilities
#
# SBEAMS is Copyright (C) 2000-2002 by Eric Deutsch
# This program is governed by the terms of the GNU General Public License (GPL)
# version 2 as published by the Free Software Foundation.  It is provided
# WITHOUT ANY WARRANTY.  See the full description of GPL terms in the
# LICENSE file distributed with this software.
#
###############################################################################


  use strict;

  #### Set up the SBEAMS - Proteomics module object
  use lib qw (../perl ../../perl ../../../perl);
  use SBEAMS::Proteomics::Utilities;
  my $sbeamsPR = SBEAMS::Proteomics::Utilities->new();


  #### Define standard variables
  my ($i,$element,$key,$value,$line,$result,$sql);
  my $verbose = 0;


  #### Define a test protein: Drosophila ptc|FBgn0003892|CT7996|FBan0002411
  my $protein = 'MDRDSLPRVPDTHGDVVDEKLFSDLYIRTSWVDAQVALDQIDKGKARGSRTAIYLRSVFQSHLETLGSSVQKHAGKVLFVAILVLSTFCVGLKSAQIHSKVHQLWIQEGGRLEAELAYTQKTIGEDESATHQLLIQTTHDPNASVLHPQALLAHLEVLVKATAVKVHLYDTEWGLRDMCNMPSTPSFEGIYYIEQILRHLIPCSIITPLDCFWEGSQLLGPESAVVIPGLNQRLLWTTLNPASVMQYMKQKMSEEKISFDFETVEQYMKRAAIGSGYMEKPCLNPLNPNCPDTAPNKNSTQPPDVGAILSGGCYGYAAKHMHWPEELIVGGAKRNRSGHLRKAQALQSVVQLMTEKEMYDQWQDNYKVHHLGWTQEKAAEVLNAWQRNFSREVEQLLRKQSRIATNYDIYVFSSAALDDILAKFSHPSALSIVIGVAVTVLYAFCTLLRWRDPVRGQSSVGVAGVLLMCFSTAAGLGLSALLGIVFNAASTQVVPFLALGLGVDHIFMLTAAYAESNRREQTKLILKKVGPSILFSACSTAGSFFAAAFIPVPALKVFCLQAAIVMCSNLAAALLVFPAMISLDLRRRTAGRADIFCCCFPVWKEQPKVAPPVLPLNNNNGRGARHPKSCNNNRVPLPAQNPLLEQRADIPGSSHSLASFSLATFAFQHYTPFLMRSWVKFLTVMGFLAALISSLYASTRLQDGLDIIDLVPKDSNEHKFLDAQTRLFGFYSMYAVTQGNFEYPTQQQLLRDYHDSFVRVPHVIKNDNGGLPDFWLLLFSEWLGNLQKIFDEEYRDGRLTKECWFPNASSDAILAYKLIVQTGHVDNPVDKELVLTNRLVNSDGIINQRAFYNYLSAWATNDVFAYGASQGKLYPEPRQYFHQPNEYDLKIPKSLPLVYAQMPFYLHGLTDTSQIKTLIGHIRDLSVKYEGFGLPNYPSGIPFIFWEQYMTLRSSLAMILACVLLAALVLVSLLLLSVWAAVLVILSVLASLAQIFGAMTLLGIKLSAIPAVILILSVGMMLCFNVLISLGFMTSVGNRQRRVQLSMQMSLGPLVHGMLTSGVAVFMLSTSPFEFVIRHFCWLLLVVLCVGACNSLLVFPILLSMVGPEAELVPLEHPDRISTPSPLPVRSSKRSGKSYVVQGSRSSRGSCQKSHHHHHKDLNDPSLTTITEEPQSWKSSNSSIQMPNDWTYQPREQRPASYAAPPPAYHKAAAQQHHQHQGPPTTPPPPFPTAYPPELQSIVVQPEVTVETTHSDSNTTKVTATANIKVELAMPGRAVRSYNFTS';

  my $ntmr = SBEAMS::Proteomics::Utilities::calcNTransmembraneRegions(
    peptide=>$protein,
    #verbose=>2,
    calc_method=>'NewMethod',
  );

  print "Number of Transmembrane Regions: $ntmr\n\n";





