#!/bin/csh

###############################################################################
# Program     : batch_update_driver_tables.pl
# Author      : Eric Deutsch <edeutsch@systemsbiology.org>
# $Id: batch_update_driver_tables.pl,v 1.5 2002/10/21 21:31:08 edeutsch Exp $
#
# Description : This script runs the reload of all configuration files
#               from the top.
#
# SBEAMS is Copyright (C) 2000-2002 by Eric Deutsch
# This program is governed by the terms of the GNU General Public License (GPL)
# version 2 as published by the Free Software Foundation.  It is provided
# WITHOUT ANY WARRANTY.  See the full description of GPL terms in the
# LICENSE file distributed with this software.
#
###############################################################################

  set CONFDIR = "../../conf"

  if ( 0 == 1 ) then
    ./update_driver_tables.pl --delete_existing
  endif


  ./update_driver_tables.pl $CONFDIR/Core/Core_table_property.txt
  ./update_driver_tables.pl $CONFDIR/Core/Core_table_column.txt

  ./update_driver_tables.pl $CONFDIR/Proteomics/Proteomics_table_property.txt
  ./update_driver_tables.pl $CONFDIR/Proteomics/Proteomics_table_column.txt
  ./update_driver_tables.pl $CONFDIR/Proteomics/Proteomics_table_column_manual.txt

  ./update_driver_tables.pl $CONFDIR/Microarray/Microarray_table_property.txt
  ./update_driver_tables.pl $CONFDIR/Microarray/Microarray_table_column.txt
  ./update_driver_tables.pl $CONFDIR/Microarray/Microarray_table_column_manual.txt

  ./update_driver_tables.pl $CONFDIR/Inkjet/Inkjet_table_property.txt
  ./update_driver_tables.pl $CONFDIR/Inkjet/Inkjet_table_column.txt
  ./update_driver_tables.pl $CONFDIR/Inkjet/Inkjet_table_column_manual.txt

  ./update_driver_tables.pl $CONFDIR/PhenoArray/PhenoArray_table_property.txt
  ./update_driver_tables.pl $CONFDIR/PhenoArray/PhenoArray_table_column.txt

  ./update_driver_tables.pl $CONFDIR/SNP/SNP_table_property.txt
  ./update_driver_tables.pl $CONFDIR/SNP/SNP_table_column.txt

  ./update_driver_tables.pl $CONFDIR/Biosap/Biosap_table_property.txt
  ./update_driver_tables.pl $CONFDIR/Biosap/Biosap_table_column.txt

  ./update_driver_tables.pl $CONFDIR/BEDB/BEDB_table_property.txt
  ./update_driver_tables.pl $CONFDIR/BEDB/BEDB_table_column.txt

  ./update_driver_tables.pl $CONFDIR/GEAP/GEAP_table_property.txt
  ./update_driver_tables.pl $CONFDIR/GEAP/GEAP_table_column.txt







